/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.util;

import java.util.Comparator;
import java.util.TreeSet;
import one.microstream.X;
import one.microstream.collections.old.OldCollections;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerTreeSet
extends AbstractBinaryHandlerCustomCollection<TreeSet<?>> {
    static final long BINARY_OFFSET_COMPARATOR = 0L;
    static final long BINARY_OFFSET_ELEMENTS = 0L + (long)Binary.objectIdByteLength();

    private static Class<TreeSet<?>> handledType() {
        return TreeSet.class;
    }

    private static <E> Comparator<? super E> getComparator(Binary data, PersistenceLoadHandler handler) {
        return (Comparator)handler.lookupObject(data.read_long(0L));
    }

    static final int getElementCount(Binary data) {
        return X.checkArrayRange((long)data.getListElementCountReferences(BINARY_OFFSET_ELEMENTS));
    }

    public static BinaryHandlerTreeSet New() {
        return new BinaryHandlerTreeSet();
    }

    BinaryHandlerTreeSet() {
        super(BinaryHandlerTreeSet.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerTreeSet.SimpleArrayFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerTreeSet.CustomField(Comparator.class, "comparator")}));
    }

    @Override
    public final void store(Binary data, TreeSet<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeIterableAsList(this.typeId(), objectId, BINARY_OFFSET_ELEMENTS, (Iterable<?>)instance, instance.size(), (PersistenceFunction)handler);
        data.store_long(0L, handler.apply(instance.comparator()));
    }

    @Override
    public final TreeSet<?> create(Binary data, PersistenceLoadHandler handler) {
        return new TreeSet(BinaryHandlerTreeSet.getComparator(data, handler));
    }

    public final void updateState(Binary data, TreeSet<?> instance, PersistenceLoadHandler handler) {
        instance.clear();
        Object[] elementsHelper = new Object[BinaryHandlerTreeSet.getElementCount(data)];
        data.collectElementsIntoArray(BINARY_OFFSET_ELEMENTS, handler, elementsHelper);
        data.registerHelper(instance, elementsHelper);
    }

    @Override
    public final void complete(Binary data, TreeSet<?> instance, PersistenceLoadHandler handler) {
        OldCollections.populateCollectionFromHelperArray(instance, (Object)data.getHelper(instance));
    }

    @Override
    public final void iterateInstanceReferences(TreeSet<?> instance, PersistenceFunction iterator) {
        iterator.apply(instance.comparator());
        Persistence.iterateReferencesIterable((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(data.read_long(0L));
        data.iterateListElementReferences(BINARY_OFFSET_ELEMENTS, (PersistenceObjectIdAcceptor)iterator);
    }
}

