/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.util.regex;

import java.util.regex.Pattern;
import one.microstream.chars.XChars;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomValueVariableLength;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerPattern
extends AbstractBinaryHandlerCustomValueVariableLength<Pattern, String> {
    public static int binaryOffsetFlags() {
        return 0;
    }

    public static int binaryOffsetPatternString() {
        return 4;
    }

    public static BinaryHandlerPattern New() {
        return new BinaryHandlerPattern();
    }

    BinaryHandlerPattern() {
        super(Pattern.class, (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerPattern.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerPattern.CustomField(Integer.TYPE, "flags"), BinaryHandlerPattern.chars("pattern")}));
    }

    @Override
    public final void store(Binary data, Pattern instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        char[] patternChars = XChars.readChars((String)instance.pattern());
        data.storeEntityHeader(4L + Binary.calculateBinaryLengthChars(patternChars.length), this.typeId(), objectId);
        data.store_int(BinaryHandlerPattern.binaryOffsetFlags(), instance.flags());
        data.storeStringValue((long)BinaryHandlerPattern.binaryOffsetPatternString(), patternChars);
    }

    @Override
    public Pattern create(Binary data, PersistenceLoadHandler handler) {
        String pattern = data.buildString(BinaryHandlerPattern.binaryOffsetPatternString());
        int flags = data.read_int(BinaryHandlerPattern.binaryOffsetFlags());
        return Pattern.compile(pattern, flags);
    }

    @Override
    public String getValidationStateFromInstance(Pattern instance) {
        return BinaryHandlerPattern.stateString(instance.pattern(), instance.flags());
    }

    @Override
    public String getValidationStateFromBinary(Binary data) {
        return BinaryHandlerPattern.stateString(data.buildString(BinaryHandlerPattern.binaryOffsetPatternString()), data.read_int(BinaryHandlerPattern.binaryOffsetFlags()));
    }

    private static String stateString(String pattern, int flags) {
        return "pattern = " + pattern + ", flags = " + flags;
    }
}

