/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.one.microstream.collections;

import java.lang.reflect.Field;
import one.microstream.X;
import one.microstream.collections.EqConstHashTable;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.hashing.HashEqualator;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.one.microstream.collections.XCollectionsInternals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import one.microstream.typing.KeyValue;

public final class BinaryHandlerEqConstHashTable
extends AbstractBinaryHandlerCustomCollection<EqConstHashTable<?, ?>> {
    static final long BINARY_OFFSET_EQUALATOR = 0L;
    static final long BINARY_OFFSET_KEYS = 0L + (long)Binary.objectIdByteLength();
    static final long BINARY_OFFSET_VALUES = BINARY_OFFSET_KEYS + (long)Binary.objectIdByteLength();
    static final long BINARY_OFFSET_HASH_DENSITY = BINARY_OFFSET_VALUES + (long)Binary.objectIdByteLength();
    static final long BINARY_OFFSET_ELEMENTS = BINARY_OFFSET_HASH_DENSITY + 4L;
    static final Field FIELD_EQUALATOR = BinaryHandlerEqConstHashTable.getInstanceFieldOfType(EqConstHashTable.class, HashEqualator.class);
    static final Field FIELD_KEYS = BinaryHandlerEqConstHashTable.getInstanceFieldOfType(EqConstHashTable.class, EqConstHashTable.Keys.class);
    static final Field FIELD_VALUES = BinaryHandlerEqConstHashTable.getInstanceFieldOfType(EqConstHashTable.class, EqConstHashTable.Values.class);

    private static Class<EqConstHashTable<?, ?>> handledType() {
        return EqConstHashTable.class;
    }

    private static int getBuildItemElementCount(Binary data) {
        return X.checkArrayRange((long)data.getListElementCountKeyValue(BINARY_OFFSET_ELEMENTS));
    }

    private static float getBuildItemHashDensity(Binary data) {
        return data.read_float(BINARY_OFFSET_HASH_DENSITY);
    }

    public static BinaryHandlerEqConstHashTable New() {
        return new BinaryHandlerEqConstHashTable();
    }

    BinaryHandlerEqConstHashTable() {
        super(BinaryHandlerEqConstHashTable.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerEqConstHashTable.keyValuesFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerEqConstHashTable.CustomField(HashEqualator.class, "hashEqualator"), BinaryHandlerEqConstHashTable.CustomField(EqConstHashTable.Keys.class, "keys"), BinaryHandlerEqConstHashTable.CustomField(EqConstHashTable.Values.class, "values"), BinaryHandlerEqConstHashTable.CustomField(Float.TYPE, "hashDensity")}));
    }

    @Override
    public final void store(Binary data, EqConstHashTable<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeKeyValuesAsEntries(this.typeId(), objectId, BINARY_OFFSET_ELEMENTS, (Iterable<? extends KeyValue<?, ?>>)instance, instance.size(), (PersistenceFunction)handler);
        data.store_long(0L, handler.apply((Object)instance.hashEquality()));
        data.store_long(BINARY_OFFSET_KEYS, handler.apply((Object)instance.keys()));
        data.store_long(BINARY_OFFSET_VALUES, handler.apply((Object)instance.values()));
        data.store_float(BINARY_OFFSET_HASH_DENSITY, instance.hashDensity());
    }

    @Override
    public final EqConstHashTable<?, ?> create(Binary data, PersistenceLoadHandler handler) {
        return EqConstHashTable.NewCustom((int)BinaryHandlerEqConstHashTable.getBuildItemElementCount(data), (float)BinaryHandlerEqConstHashTable.getBuildItemHashDensity(data));
    }

    public final void updateState(Binary data, EqConstHashTable<?, ?> instance, PersistenceLoadHandler handler) {
        if (instance.size() != 0L) {
            throw new IllegalStateException("Instance already contains data: " + instance);
        }
        XMemory.setObject(instance, (long)XMemory.objectFieldOffset((Field)FIELD_EQUALATOR), (Object)handler.lookupObject(data.read_long(0L)));
        XMemory.setObject(instance, (long)XMemory.objectFieldOffset((Field)FIELD_KEYS), (Object)handler.lookupObject(data.read_long(BINARY_OFFSET_KEYS)));
        XMemory.setObject(instance, (long)XMemory.objectFieldOffset((Field)FIELD_VALUES), (Object)handler.lookupObject(data.read_long(BINARY_OFFSET_VALUES)));
        XCollectionsInternals.setSize(instance, data.collectKeyValueReferences(BINARY_OFFSET_ELEMENTS, BinaryHandlerEqConstHashTable.getBuildItemElementCount(data), handler, (k, v) -> XCollectionsInternals.internalAdd(instance, k, v)));
    }

    @Override
    public final void complete(Binary data, EqConstHashTable<?, ?> instance, PersistenceLoadHandler handler) {
        XCollectionsInternals.internalRehash(instance);
    }

    @Override
    public final void iterateInstanceReferences(EqConstHashTable<?, ?> instance, PersistenceFunction iterator) {
        iterator.apply((Object)instance.equality());
        iterator.apply((Object)instance.keys());
        iterator.apply((Object)instance.values());
        Persistence.iterateReferences((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(data.read_long(0L));
        iterator.acceptObjectId(data.read_long(BINARY_OFFSET_KEYS));
        iterator.acceptObjectId(data.read_long(BINARY_OFFSET_VALUES));
        data.iterateKeyValueEntriesReferences(BINARY_OFFSET_ELEMENTS, (PersistenceObjectIdAcceptor)iterator);
    }
}

