/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.one.microstream.collections;

import one.microstream.X;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.one.microstream.collections.XCollectionsInternals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import one.microstream.typing.KeyValue;

public final class BinaryHandlerHashTable
extends AbstractBinaryHandlerCustomCollection<HashTable<?, ?>> {
    static final long BINARY_OFFSET_KEYS = 0L;
    static final long BINARY_OFFSET_VALUES = 0L + (long)Binary.objectIdByteLength();
    static final long BINARY_OFFSET_HASH_DENSITY = BINARY_OFFSET_VALUES + (long)Binary.objectIdByteLength();
    static final long BINARY_OFFSET_ELEMENTS = BINARY_OFFSET_HASH_DENSITY + 4L;

    private static Class<HashTable<?, ?>> handledType() {
        return HashTable.class;
    }

    private static int getBuildItemElementCount(Binary data) {
        return X.checkArrayRange((long)data.getListElementCountKeyValue(BINARY_OFFSET_ELEMENTS));
    }

    private static float getBuildItemHashDensity(Binary data) {
        return data.read_float(BINARY_OFFSET_HASH_DENSITY);
    }

    public static BinaryHandlerHashTable New() {
        return new BinaryHandlerHashTable();
    }

    BinaryHandlerHashTable() {
        super(BinaryHandlerHashTable.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerHashTable.keyValuesFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerHashTable.CustomField(HashTable.Keys.class, "keys"), BinaryHandlerHashTable.CustomField(HashTable.Values.class, "values"), BinaryHandlerHashTable.CustomField(Float.TYPE, "hashDensity")}));
    }

    @Override
    public final void store(Binary data, HashTable<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeKeyValuesAsEntries(this.typeId(), objectId, BINARY_OFFSET_ELEMENTS, (Iterable<? extends KeyValue<?, ?>>)instance, instance.size(), (PersistenceFunction)handler);
        data.store_long(0L, handler.apply((Object)instance.keys()));
        data.store_long(BINARY_OFFSET_VALUES, handler.apply((Object)instance.values()));
        data.store_float(BINARY_OFFSET_HASH_DENSITY, instance.hashDensity());
    }

    @Override
    public final HashTable<?, ?> create(Binary data, PersistenceLoadHandler handler) {
        return HashTable.NewCustom((int)BinaryHandlerHashTable.getBuildItemElementCount(data), (float)BinaryHandlerHashTable.getBuildItemHashDensity(data));
    }

    public final void updateState(Binary data, HashTable<?, ?> instance, PersistenceLoadHandler handler) {
        instance.clear();
        XCollectionsInternals.setKeys(instance, (HashTable.Keys)handler.lookupObject(data.read_long(0L)));
        XCollectionsInternals.setValues(instance, (HashTable.Values)handler.lookupObject(data.read_long(BINARY_OFFSET_VALUES)));
        data.collectKeyValueReferences(BINARY_OFFSET_ELEMENTS, BinaryHandlerHashTable.getBuildItemElementCount(data), handler, (k, v) -> XCollectionsInternals.internalAdd(instance, k, v));
    }

    @Override
    public final void iterateInstanceReferences(HashTable<?, ?> instance, PersistenceFunction iterator) {
        iterator.apply((Object)instance.keys());
        iterator.apply((Object)instance.values());
        Persistence.iterateReferences((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(data.read_long(0L));
        iterator.acceptObjectId(data.read_long(BINARY_OFFSET_VALUES));
        data.iterateKeyValueEntriesReferences(BINARY_OFFSET_ELEMENTS, (PersistenceObjectIdAcceptor)iterator);
    }
}

