/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.HashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingMap;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.AbstractBinaryLegacyTypeHandlerReflective;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryLegacyTypeHandlerGenericEnum;
import one.microstream.persistence.binary.types.BinaryLegacyTypeHandlerGenericEnumMapped;
import one.microstream.persistence.binary.types.BinaryLegacyTypeHandlerGenericType;
import one.microstream.persistence.binary.types.BinaryLegacyTypeHandlerRerouting;
import one.microstream.persistence.binary.types.BinaryValueSetter;
import one.microstream.persistence.binary.types.BinaryValueTranslatorProvider;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlerCreator;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlerWrapperEnum;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlingListener;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResult;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerReflective;
import one.microstream.reflect.XReflect;
import one.microstream.typing.KeyValue;
import one.microstream.util.similarity.Similarity;

public interface BinaryLegacyTypeHandlerCreator
extends PersistenceLegacyTypeHandlerCreator<Binary> {
    public static BinaryLegacyTypeHandlerCreator New(BinaryValueTranslatorProvider valueTranslatorProvider, PersistenceLegacyTypeHandlingListener<Binary> legacyTypeHandlingListener, boolean switchByteOrder) {
        return new Default((BinaryValueTranslatorProvider)X.notNull((Object)valueTranslatorProvider), (PersistenceLegacyTypeHandlingListener<Binary>)((PersistenceLegacyTypeHandlingListener)X.mayNull(legacyTypeHandlingListener)), switchByteOrder);
    }

    public static final class Default
    extends PersistenceLegacyTypeHandlerCreator.Abstract<Binary>
    implements BinaryLegacyTypeHandlerCreator {
        private final BinaryValueTranslatorProvider valueTranslatorProvider;
        private final PersistenceLegacyTypeHandlingListener<Binary> legacyTypeHandlingListener;
        private final boolean switchByteOrder;

        Default(BinaryValueTranslatorProvider valueTranslatorProvider, PersistenceLegacyTypeHandlingListener<Binary> legacyTypeHandlingListener, boolean switchByteOrder) {
            this.valueTranslatorProvider = valueTranslatorProvider;
            this.legacyTypeHandlingListener = legacyTypeHandlingListener;
            this.switchByteOrder = switchByteOrder;
        }

        private static HashTable<PersistenceTypeDefinitionMember, Long> createBinaryOffsetMap(XGettingEnum<? extends PersistenceTypeDefinitionMember> members) {
            HashTable memberOffsets = HashTable.New();
            long totalOffset = 0L;
            for (PersistenceTypeDefinitionMember member : members) {
                memberOffsets.add((Object)member, (Object)totalOffset);
                totalOffset += member.persistentMaximumLength();
            }
            return memberOffsets;
        }

        private static HashTable<PersistenceTypeDefinitionMember, Long> createFieldOffsetMap(Class<?> entityClass, XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> members) {
            Field[] fields = (Field[])((BulkList)PersistenceTypeDefinitionMemberFieldReflective.unbox(members, (Consumer)BulkList.New())).toArray(Field.class);
            long[] offsets = XMemory.objectFieldOffsets(entityClass, (Field[])fields);
            HashTable memberOffsets = HashTable.New();
            int i = 0;
            for (PersistenceTypeDefinitionMemberFieldReflective member : members) {
                memberOffsets.add((Object)member, (Object)offsets[i++]);
            }
            return memberOffsets;
        }

        private XGettingEnum<KeyValue<Long, BinaryValueSetter>> deriveValueTranslators(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<Binary, ?> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToTargetMembers, HashTable<PersistenceTypeDefinitionMember, Long> targetMemberOffsets, boolean resolveReferences) {
            HashEnum translatorsWithTargetOffsets = HashEnum.New();
            BinaryValueTranslatorProvider creator = this.valueTranslatorProvider;
            for (PersistenceTypeDefinitionMember legacyMember : legacyTypeDefinition.instanceMembers()) {
                PersistenceTypeDefinitionMember currentMember = (PersistenceTypeDefinitionMember)Similarity.targetElement((Similarity)((Similarity)legacyToTargetMembers.get((Object)legacyMember)));
                BinaryValueSetter translator = resolveReferences ? creator.provideTargetValueTranslator(legacyTypeDefinition, legacyMember, currentTypeHandler, currentMember) : creator.provideBinaryValueTranslator(legacyTypeDefinition, legacyMember, currentTypeHandler, currentMember);
                Long targetOffset = (Long)targetMemberOffsets.get((Object)currentMember);
                translatorsWithTargetOffsets.add((Object)X.KeyValue((Object)targetOffset, (Object)translator));
            }
            return translatorsWithTargetOffsets;
        }

        protected <T> PersistenceLegacyTypeHandler<Binary, T> deriveCustomWrappingHandler(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult) {
            PersistenceTypeHandler currentTypeHandler = mappingResult.currentTypeHandler();
            if (currentTypeHandler.hasPersistedVariableLength()) {
                throw new UnsupportedOperationException("Types with varying persisted length are not supported, yet by generic mapping. Use a custom handler for type" + currentTypeHandler.toRuntimeTypeIdentifier());
            }
            HashTable<PersistenceTypeDefinitionMember, Long> targetMemberOffsets = Default.createBinaryOffsetMap((XGettingEnum<? extends PersistenceTypeDefinitionMember>)mappingResult.currentTypeHandler().instanceMembers());
            XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets = this.deriveValueTranslators(mappingResult.legacyTypeDefinition(), mappingResult.currentTypeHandler(), (XGettingMap<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)mappingResult.legacyToCurrentMembers(), targetMemberOffsets, false);
            BinaryLegacyTypeHandlerRerouting reroutingTypeHandler = BinaryLegacyTypeHandlerRerouting.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, this.legacyTypeHandlingListener, this.switchByteOrder);
            if (XReflect.isEnum((Class)currentTypeHandler.type())) {
                return this.deriveCustomWrappingHandlerEnum(mappingResult, reroutingTypeHandler);
            }
            return reroutingTypeHandler;
        }

        protected <T> PersistenceLegacyTypeHandler<Binary, T> deriveCustomWrappingHandlerEnum(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, BinaryLegacyTypeHandlerRerouting<T> reroutingTypeHandler) {
            if (PersistenceLegacyTypeMappingResult.isUnchangedStaticStructure(mappingResult)) {
                return reroutingTypeHandler;
            }
            Integer[] ordinalMapping = Default.deriveEnumOrdinalMapping(mappingResult);
            return PersistenceLegacyTypeHandlerWrapperEnum.New((PersistenceTypeDefinition)mappingResult.legacyTypeDefinition(), reroutingTypeHandler, (Integer[])ordinalMapping);
        }

        protected <T> AbstractBinaryLegacyTypeHandlerReflective<T> deriveReflectiveHandler(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, PersistenceTypeHandlerReflective<Binary, T> currentTypeHandler) {
            HashTable<PersistenceTypeDefinitionMember, Long> targetMemberOffsets = Default.createFieldOffsetMap(currentTypeHandler.type(), (XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective>)currentTypeHandler.settingMembers());
            XGettingEnum<KeyValue<Long, BinaryValueSetter>> valueTranslators = this.deriveValueTranslators(mappingResult.legacyTypeDefinition(), mappingResult.currentTypeHandler(), (XGettingMap<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)mappingResult.legacyToCurrentMembers(), targetMemberOffsets, true);
            return XReflect.isEnum((Class)currentTypeHandler.type()) ? this.deriveReflectiveHandlerGenericEnum(mappingResult, (PersistenceTypeHandler<Binary, T>)currentTypeHandler, valueTranslators) : this.deriveReflectiveHandlerGenericType(mappingResult, currentTypeHandler, valueTranslators);
        }

        private <T> AbstractBinaryLegacyTypeHandlerReflective<T> deriveReflectiveHandlerGenericEnum(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, PersistenceTypeHandler<Binary, T> currentTypeHandler, XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
            if (PersistenceLegacyTypeMappingResult.isUnchangedStaticStructure(mappingResult)) {
                return BinaryLegacyTypeHandlerGenericEnum.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, this.legacyTypeHandlingListener, this.switchByteOrder);
            }
            Integer[] ordinalMapping = Default.deriveEnumOrdinalMapping(mappingResult);
            return BinaryLegacyTypeHandlerGenericEnumMapped.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, ordinalMapping, this.legacyTypeHandlingListener, this.switchByteOrder);
        }

        private <T> BinaryLegacyTypeHandlerGenericType<T> deriveReflectiveHandlerGenericType(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, PersistenceTypeHandlerReflective<Binary, T> currentTypeHandler, XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
            return BinaryLegacyTypeHandlerGenericType.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, this.legacyTypeHandlingListener, this.switchByteOrder);
        }
    }
}

