/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.math.XMath;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceException;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerSingleton;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryChannelCountProvider;
import one.microstream.persistence.binary.types.BinaryEntityDataReader;
import one.microstream.persistence.binary.types.BinaryLoadItem;
import one.microstream.persistence.binary.types.BinaryLoadItemByteReversing;
import one.microstream.persistence.binary.types.LoadItemsChain;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeHandlerConsistencyUnhandledTypeId;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceLoader;
import one.microstream.persistence.types.PersistenceObjectRegistry;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceRoots;
import one.microstream.persistence.types.PersistenceSource;
import one.microstream.persistence.types.PersistenceSourceSupplier;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerLookup;
import one.microstream.persistence.types.Persister;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface BinaryLoader
extends PersistenceLoader,
PersistenceLoadHandler {
    public static Creator CreatorSimple(boolean switchByteOrder) {
        return new CreatorSimple(switchByteOrder);
    }

    public static Default New(PersistenceTypeHandlerLookup<Binary> typeLookup, PersistenceObjectRegistry registry, Persister persister, PersistenceSourceSupplier<Binary> sourceSupplier, LoadItemsChain loadItems, boolean switchByteOrder) {
        return new Default((PersistenceTypeHandlerLookup<Binary>)((PersistenceTypeHandlerLookup)X.notNull(typeLookup)), (PersistenceObjectRegistry)X.notNull((Object)registry), (Persister)X.notNull((Object)persister), (PersistenceSourceSupplier<Binary>)((PersistenceSourceSupplier)X.notNull(sourceSupplier)), (LoadItemsChain)X.notNull((Object)loadItems), switchByteOrder);
    }

    public static final class CreatorChannelHashing
    implements Creator {
        private final boolean switchByteOrder;
        private final BinaryChannelCountProvider channelCountProvider;

        public CreatorChannelHashing(BinaryChannelCountProvider channelCountProvider, boolean switchByteOrder) {
            this.switchByteOrder = switchByteOrder;
            this.channelCountProvider = channelCountProvider;
        }

        @Override
        public BinaryLoader createLoader(PersistenceTypeHandlerLookup<Binary> typeLookup, PersistenceObjectRegistry registry, Persister persister, PersistenceSourceSupplier<Binary> sourceSupplier) {
            return new Default(typeLookup, registry, persister, sourceSupplier, new LoadItemsChain.ChannelHashing(this.channelCountProvider.getChannelCount()), this.switchByteOrder);
        }
    }

    public static final class CreatorSimple
    implements Creator {
        private final boolean switchByteOrder;

        CreatorSimple(boolean switchByteOrder) {
            this.switchByteOrder = switchByteOrder;
        }

        @Override
        public BinaryLoader createLoader(PersistenceTypeHandlerLookup<Binary> typeLookup, PersistenceObjectRegistry registry, Persister persister, PersistenceSourceSupplier<Binary> source) {
            return new Default(typeLookup, registry, persister, source, new LoadItemsChain.Simple(), this.switchByteOrder);
        }
    }

    public static final class Default
    implements BinaryLoader,
    BinaryEntityDataReader,
    PersistenceReferenceLoader {
        private static final Logger logger = Logging.getLogger(Default.class);
        private static final int DEFAULT_HASH_SLOTS_LENGTH = 1024;
        private final PersistenceTypeHandlerLookup<Binary> typeHandlerLookup;
        private final PersistenceObjectRegistry objectRegistry;
        private final Persister persister;
        private final PersistenceSourceSupplier<Binary> sourceSupplier;
        private final LoadItemsChain loadItems;
        private final boolean switchByteOrder;
        private final BulkList<XGettingCollection<? extends Binary>> anchor = new BulkList();
        private final BinaryLoadItem buildItemsHead;
        private BinaryLoadItem buildItemsTail = this.buildItemsHead = this.createLoadItemDummy();
        private int buildItemsSize;
        private BinaryLoadItem[] buildItemsHashSlots = new BinaryLoadItem[1024];
        private int buildItemsHashRange = this.buildItemsHashSlots.length - 1;

        Default(PersistenceTypeHandlerLookup<Binary> typeLookup, PersistenceObjectRegistry objectRegistry, Persister persister, PersistenceSourceSupplier<Binary> sourceSupplier, LoadItemsChain loadItems, boolean switchByteOrder) {
            this.typeHandlerLookup = typeLookup;
            this.objectRegistry = objectRegistry;
            this.persister = persister;
            this.sourceSupplier = sourceSupplier;
            this.loadItems = loadItems;
            this.switchByteOrder = switchByteOrder;
        }

        public final Persister getPersister() {
            return this.persister;
        }

        @Override
        public void readBinaryEntities(ByteBuffer entitiesData) {
            if (this.switchByteOrder) {
                this.internalReadBinaryEntitiesByteReversing(entitiesData);
            } else {
                this.internalReadBinaryEntities(entitiesData);
            }
        }

        private void internalReadBinaryEntities(ByteBuffer entitiesData) {
            long startAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)entitiesData);
            long boundAddress = startAddress + (long)entitiesData.limit();
            for (long address = startAddress; address < boundAddress; address += XMemory.get_long((long)address)) {
                this.createBuildItem(new BinaryLoadItem(Binary.toEntityContentOffset(address)));
            }
        }

        private void internalReadBinaryEntitiesByteReversing(ByteBuffer entitiesData) {
            long startAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)entitiesData);
            long boundAddress = startAddress + (long)entitiesData.limit();
            for (long address = startAddress; address < boundAddress; address += Long.reverseBytes(XMemory.get_long((long)address))) {
                this.createBuildItem(new BinaryLoadItemByteReversing(Binary.toEntityContentOffset(address)));
            }
        }

        private static PersistenceTypeHandler<Binary, Object> damnTypeErasure(PersistenceTypeHandler<Binary, ?> typeHandler) {
            return typeHandler;
        }

        protected PersistenceTypeHandler<Binary, Object> lookupTypeHandler(long tid) {
            PersistenceTypeHandler<Binary, Object> handler = Default.damnTypeErasure(this.typeHandlerLookup.lookupTypeHandler(tid));
            if (handler == null) {
                throw new PersistenceExceptionTypeHandlerConsistencyUnhandledTypeId(tid);
            }
            return handler;
        }

        private void createBuildItem(BinaryLoadItem loadItem) {
            loadItem.handler = this.lookupTypeHandler(loadItem.getBuildItemTypeId());
            loadItem.existingInstance = this.objectRegistry.lookupObject(loadItem.getBuildItemObjectId());
            if (loadItem.existingInstance == null) {
                loadItem.createdInstance = loadItem.handler.create((Object)loadItem, (PersistenceLoadHandler)this);
            }
            this.putBuildItem(loadItem);
        }

        protected void handleAllReferences(BinaryLoadItem item) {
            while ((item = item.next) != null) {
                if (!item.hasData()) continue;
                this.loadReferences(item);
            }
        }

        private Object getEffectiveInstance(BinaryLoadItem entry) {
            if (entry.existingInstance != null) {
                return entry.existingInstance;
            }
            if (entry.createdInstance == null) {
                return null;
            }
            entry.existingInstance = this.objectRegistry.optionalRegisterObject(entry.getBuildItemObjectId(), entry.createdInstance);
            return entry.existingInstance;
        }

        protected void loadReferences(BinaryLoadItem entry) {
            entry.handler.iterateLoadableReferences((Object)entry, (PersistenceReferenceLoader)this);
        }

        public final Object lookupObject(long objectId) {
            return this.getBuildInstance(objectId);
        }

        public final void requireRoot(Object rootInstance, long rootObjectId) {
            this.registerRoot(rootInstance, rootObjectId);
            this.requireReferenceEager(rootObjectId);
        }

        @Deprecated
        public final void registerCustomRootRefactoring(Object rootInstance, long customRootObjectId) {
            this.registerRoot(rootInstance, customRootObjectId);
        }

        @Deprecated
        public final void registerDefaultRootRefactoring(Object rootInstance, long defaultRootObjectId) {
            BinaryLoadItem defaultRootLoadItem = this.lookupLoadItem(defaultRootObjectId);
            long defaultRootInstanceObjectId = BinaryHandlerSingleton.getReferenceObjectId(defaultRootLoadItem);
            this.registerRoot(rootInstance, defaultRootInstanceObjectId);
        }

        private void registerRoot(Object rootInstance, long rootObjectId) {
            this.objectRegistry.registerObject(rootObjectId, rootInstance);
        }

        public void validateType(Object object, long objectId) {
            BinaryLoadItem loadItem = this.lookupLoadItem(objectId);
            if (loadItem == null) {
                return;
            }
            if (object.getClass() == loadItem.handler.type()) {
                return;
            }
            throw new BinaryPersistenceException("Type mismatch: object type (" + object.getClass() + ") does not match the loaded type id: " + loadItem.handler.toTypeIdentifier());
        }

        private void build() {
            this.buildInstances();
            this.completeInstances();
        }

        private void buildInstances() {
            BinaryLoadItem entry = this.buildItemsHead.next;
            while (entry != null) {
                if (entry.hasData()) {
                    logger.trace("Updating {}", (Object)entry);
                    Object effectiveInstance = this.getEffectiveInstance(entry);
                    if (effectiveInstance != null) {
                        if (effectiveInstance == entry.createdInstance) {
                            entry.handler.initializeState((Object)entry, effectiveInstance, (PersistenceLoadHandler)this);
                        } else {
                            entry.handler.updateState((Object)entry, effectiveInstance, (PersistenceLoadHandler)this);
                        }
                    }
                }
                entry = entry.next;
            }
        }

        private void completeInstances() {
            BinaryLoadItem entry = this.buildItemsHead.next;
            while (entry != null) {
                if (entry.hasData()) {
                    entry.handler.complete((Object)entry, entry.existingInstance, (PersistenceLoadHandler)this);
                }
                entry = entry.next;
            }
        }

        public final void acceptObjectId(long objectId) {
            this.requireReferenceLazy(objectId);
        }

        public final void requireReferenceLazy(long objectId) {
            if (this.isUnrequiredReferenceLazy(objectId)) {
                return;
            }
            this.requireReference(objectId);
        }

        public final void requireReferenceEager(long objectId) {
            if (this.isUnrequiredReferenceEager(objectId)) {
                return;
            }
            this.requireReference(objectId);
        }

        private Object internalGetFirst() {
            BinaryLoadItem item = this.buildItemsHead.next;
            while (item != null) {
                if (item.existingInstance != null) {
                    return item.existingInstance;
                }
                item = item.next;
            }
            return null;
        }

        private void rebuildBuildItems() {
            if (XMath.isGreaterThanOrEqualHighestPowerOf2((int)this.buildItemsHashSlots.length)) {
                return;
            }
            int newRange = (this.buildItemsHashSlots.length << 1) - 1;
            BinaryLoadItem[] newSlots = new BinaryLoadItem[newRange + 1];
            for (BinaryLoadItem entry : this.buildItemsHashSlots) {
                while (entry != null) {
                    BinaryLoadItem next = entry.link;
                    entry.link = newSlots[(int)entry.getBuildItemObjectId() & newRange];
                    newSlots[(int)entry.getBuildItemObjectId() & newRange] = entry;
                    entry = next;
                }
            }
            this.buildItemsHashSlots = newSlots;
            this.buildItemsHashRange = newRange;
        }

        private void putBuildItem(BinaryLoadItem entry) {
            entry.link = this.buildItemsHashSlots[(int)entry.getBuildItemObjectId() & this.buildItemsHashRange];
            this.buildItemsTail = this.buildItemsTail.next = entry;
            this.buildItemsHashSlots[(int)entry.getBuildItemObjectId() & this.buildItemsHashRange] = this.buildItemsTail.next;
            if (++this.buildItemsSize >= this.buildItemsHashRange) {
                this.rebuildBuildItems();
            }
        }

        private void putSkipItem(long objectId, Object instance) {
            this.putBuildItem(new BinaryLoadItem(objectId, instance));
        }

        private boolean isUnrequiredReferenceLazy(long objectId) {
            if (this.isUnrequiredReferenceEager(objectId)) {
                return true;
            }
            Object instance = this.objectRegistry.lookupObject(objectId);
            if (instance != null) {
                this.putSkipItem(objectId, instance);
                return true;
            }
            return false;
        }

        private boolean isUnrequiredReferenceEager(long objectId) {
            if (objectId == 0L) {
                return true;
            }
            BinaryLoadItem e = this.buildItemsHashSlots[(int)(objectId & (long)this.buildItemsHashRange)];
            while (e != null) {
                if (e.getBuildItemObjectId() == objectId) {
                    return true;
                }
                e = e.link;
            }
            return false;
        }

        private Object getBuildInstance(long objectId) {
            BinaryLoadItem e = this.buildItemsHashSlots[(int)(objectId & (long)this.buildItemsHashRange)];
            while (e != null) {
                if (e.getBuildItemObjectId() == objectId) {
                    return this.getEffectiveInstance(e);
                }
                e = e.link;
            }
            return null;
        }

        private BinaryLoadItem lookupLoadItem(long objectId) {
            BinaryLoadItem e = this.buildItemsHashSlots[(int)(objectId & (long)this.buildItemsHashRange)];
            while (e != null) {
                if (e.getBuildItemObjectId() == objectId) {
                    return e;
                }
                e = e.link;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerSkipOid(long objectId) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                BinaryLoadItem e = this.buildItemsHashSlots[(int)(objectId & (long)this.buildItemsHashRange)];
                while (e != null) {
                    if (e.getBuildItemObjectId() == objectId) {
                        return;
                    }
                    e = e.link;
                }
                this.putSkipItem(objectId, null);
            }
        }

        private BinaryLoadItem createLoadItemDummy() {
            return new BinaryLoadItem(0L);
        }

        private void clearBuildItems() {
            this.buildItemsTail = this.buildItemsHead;
            this.buildItemsHead.next = null;
            BinaryLoadItem[] slots = this.buildItemsHashSlots;
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = null;
            }
            this.buildItemsSize = 0;
            this.anchor.clear();
        }

        private void readLoadOnce() {
            this.addChunks((XGettingCollection<? extends Binary>)this.sourceSupplier.source().read());
            this.readLoadOidData();
        }

        private void readLoadOidData() {
            PersistenceSource source = this.sourceSupplier.source();
            while (!this.loadItems.isEmpty()) {
                this.addChunks((XGettingCollection<? extends Binary>)source.readByObjectIds(this.loadItems.getObjectIdSets()));
            }
        }

        protected void addChunks(XGettingCollection<? extends Binary> chunks) {
            this.loadItems.clear();
            BinaryLoadItem referenceHandlingBaseItem = this.buildItemsTail;
            this.anchor.add(chunks);
            for (Binary chunk : (XGettingCollection)this.anchor.last()) {
                chunk.iterateEntityData(this);
            }
            this.handleAllReferences(referenceHandlingBaseItem);
        }

        private void populate(Consumer<Object> collector, long ... oids) {
            for (int i = 0; i < oids.length; ++i) {
                collector.accept(this.getBuildInstance(oids[i]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object get() {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                this.readLoadOnce();
                this.build();
                Object instance = this.internalGetFirst();
                this.clearBuildItems();
                return instance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object getObject(long objectId) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                this.requireReference(objectId);
                this.readLoadOidData();
                this.build();
                Object instance = this.getBuildInstance(objectId);
                this.clearBuildItems();
                return instance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <C extends Consumer<Object>> C collect(C collector, long ... objectIds) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                for (int i = 0; i < objectIds.length; ++i) {
                    this.requireReference(objectIds[i]);
                }
                this.readLoadOidData();
                this.build();
                this.populate(collector, objectIds);
                this.clearBuildItems();
                return collector;
            }
        }

        public PersistenceRoots loadRoots() {
            Object initial = this.get();
            if (initial == null) {
                return null;
            }
            if (!(initial instanceof PersistenceRoots)) {
                throw new BinaryPersistenceException("Initially read data is no roots instance");
            }
            return (PersistenceRoots)initial;
        }

        public final void registerSkip(long objectId) {
            this.registerSkipOid(objectId);
        }

        private final void requireReference(long objectId) {
            this.loadItems.addLoadItem(objectId);
        }
    }

    public static interface Creator
    extends PersistenceLoader.Creator<Binary> {
        public BinaryLoader createLoader(PersistenceTypeHandlerLookup<Binary> var1, PersistenceObjectRegistry var2, Persister var3, PersistenceSourceSupplier<Binary> var4);
    }
}

