/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceExceptionStateInvalidLength;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryEntityDataReader;
import one.microstream.persistence.binary.types.BinaryReferenceTraverser;
import one.microstream.persistence.binary.types.MemoryRangeReader;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.util.BufferSizeProviderIncremental;

public class ChunksBuffer
extends Binary
implements MemoryRangeReader {
    private static final int DEFAULT_BUFFERS_CAPACITY = 8;
    private final ChunksBuffer[] channelBuffers;
    private final BufferSizeProviderIncremental bufferSizeProvider;
    private ByteBuffer[] buffers;
    private int currentBuffersIndex;
    private ByteBuffer currentBuffer;
    private long currentBufferStartAddress;
    private long currentAddress;
    private long currentBound;
    private long totalLength;

    public static ChunksBuffer New(ChunksBuffer[] channelBuffers, BufferSizeProviderIncremental bufferSizeProvider) {
        return new ChunksBuffer((ChunksBuffer[])X.notNull((Object)channelBuffers), (BufferSizeProviderIncremental)X.notNull((Object)bufferSizeProvider));
    }

    ChunksBuffer(ChunksBuffer[] channelBuffers, BufferSizeProviderIncremental bufferSizeProvider) {
        this.channelBuffers = channelBuffers;
        this.bufferSizeProvider = bufferSizeProvider;
        ByteBuffer[] byteBufferArray = new ByteBuffer[8];
        this.buffers = byteBufferArray;
        this.currentBuffersIndex = 0;
        ByteBuffer byteBuffer = XMemory.allocateDirectNative((long)bufferSizeProvider.provideBufferSize());
        byteBufferArray[0] = byteBuffer;
        this.setCurrent(byteBuffer);
    }

    @Override
    public final Binary channelChunk(int channelIndex) {
        return this.channelBuffers[channelIndex];
    }

    @Override
    public final int channelCount() {
        return this.channelBuffers.length;
    }

    private void setCurrent(ByteBuffer byteBuffer) {
        this.currentBuffer = byteBuffer;
        this.currentAddress = this.currentBufferStartAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)this.currentBuffer);
        this.currentBound = this.currentAddress + (long)byteBuffer.capacity();
        byteBuffer.clear();
    }

    private void updateCurrentBufferPosition() {
        long contentLength = this.currentAddress - this.currentBufferStartAddress;
        this.currentBuffer.position(X.checkArrayRange((long)contentLength)).flip();
        this.totalLength += contentLength;
    }

    private boolean isEmptyCurrentBuffer() {
        return this.currentAddress == this.currentBufferStartAddress;
    }

    private void enlargeBufferCapacity(int bufferCapacity) {
        if (this.isEmptyCurrentBuffer()) {
            XMemory.deallocateDirectByteBuffer((ByteBuffer)this.currentBuffer);
            this.allocateNewCurrent(bufferCapacity);
            return;
        }
        this.updateCurrentBufferPosition();
        this.addBuffer(bufferCapacity);
    }

    private int calculateNewBufferCapacity(long requiredCapacity) {
        long defaultBufferCapacity = this.bufferSizeProvider.provideIncrementalBufferSize();
        return X.checkArrayRange((long)Math.max(requiredCapacity, defaultBufferCapacity));
    }

    private void ensureFreeStoreCapacity(long requiredCapacity) {
        if (this.currentAddress + requiredCapacity > this.currentBound) {
            this.enlargeBufferCapacity(this.calculateNewBufferCapacity(requiredCapacity));
        }
    }

    private void incrementBuffersCount() {
        if (++this.currentBuffersIndex >= this.buffers.length) {
            this.buffers = new ByteBuffer[this.buffers.length << 1];
            System.arraycopy(this.buffers, 0, this.buffers, 0, this.currentBuffersIndex);
        }
    }

    private void addBuffer(int bufferCapacity) {
        this.incrementBuffersCount();
        this.allocateNewCurrent(bufferCapacity);
    }

    private void allocateNewCurrent(int bufferCapacity) {
        this.buffers[this.currentBuffersIndex] = XMemory.allocateDirectNative((int)bufferCapacity);
        this.setCurrent(this.buffers[this.currentBuffersIndex]);
    }

    @Override
    public final void clear() {
        ByteBuffer[] buffers = this.buffers;
        for (int i = this.currentBuffersIndex; i >= 1; --i) {
            XMemory.deallocateDirectByteBuffer((ByteBuffer)buffers[i]);
            buffers[i] = null;
        }
        this.currentBuffersIndex = 0;
        this.setCurrent(buffers[0]);
    }

    @Override
    public void readMemory(long address, long length) {
        this.ensureFreeStoreCapacity(length);
        XMemory.copyRange((long)address, (long)this.currentAddress, (long)length);
        this.currentAddress += length;
    }

    @Override
    public final void storeEntityHeader(long entityContentLength, long entityTypeId, long entityObjectId) {
        if (entityContentLength < 0L) {
            throw new BinaryPersistenceExceptionStateInvalidLength(this.currentAddress, entityContentLength, entityTypeId, entityObjectId);
        }
        long entityTotalLength = Binary.entityTotalLength(entityContentLength);
        this.ensureFreeStoreCapacity(entityTotalLength);
        this.storeEntityHeaderToAddress(this.currentAddress, entityTotalLength, entityTypeId, entityObjectId);
        this.address = (this.currentAddress += entityTotalLength) - entityContentLength;
    }

    @Override
    public final ByteBuffer[] buffers() {
        if (this.currentBuffer != null) {
            throw new IllegalStateException("Cannot return buffers of incomplete chunks");
        }
        ByteBuffer[] buffers = new ByteBuffer[this.currentBuffersIndex + 1];
        System.arraycopy(this.buffers, 0, buffers, 0, buffers.length);
        return buffers;
    }

    public final ChunksBuffer complete() {
        if (this.currentBuffer == null) {
            return this;
        }
        this.updateCurrentBufferPosition();
        this.currentBuffer = null;
        this.currentBufferStartAddress = 0L;
        this.currentAddress = 0L;
        this.address = 0L;
        this.currentBound = 0L;
        return this;
    }

    private void iterateEntityDataLocal(BinaryEntityDataReader reader) {
        if (this.currentBuffer != null) {
            throw new IllegalStateException("Incomplete chunks");
        }
        ByteBuffer[] buffers = this.buffers;
        int buffersCount = this.currentBuffersIndex + 1;
        for (int i = 0; i < buffersCount; ++i) {
            reader.readBinaryEntities(buffers[i]);
        }
    }

    @Override
    public void iterateEntityData(BinaryEntityDataReader reader) {
        for (ChunksBuffer channelBuffer : this.channelBuffers) {
            channelBuffer.iterateEntityDataLocal(reader);
        }
    }

    @Override
    public void iterateChannelChunks(Consumer<? super Binary> logic) {
        for (ChunksBuffer channelBuffer : this.channelBuffers) {
            logic.accept(channelBuffer);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.buffers[0] == null;
    }

    @Override
    public final long totalLength() {
        return this.totalLength;
    }

    @Override
    public final long loadItemEntityContentAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void modifyLoadItem(ByteBuffer directByteBuffer, long offset, long entityTotalLength, long entityTypeId, long entityObjectId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long iterateReferences(BinaryReferenceTraverser[] traversers, PersistenceObjectIdAcceptor acceptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mark() {
        for (int i = 0; i <= this.currentBuffersIndex; ++i) {
            this.buffers[i].mark();
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i <= this.currentBuffersIndex; ++i) {
            this.buffers[i].reset();
        }
    }
}

