/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import one.microstream.chars.VarString;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XGettingList;
import one.microstream.collections.types.XList;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.util.SerializerTypeInfo;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionRegistrationObserver;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryAssembler;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface SerializerTypeInfoStrategy
extends PersistenceTypeDefinitionRegistrationObserver {
    public SerializerTypeInfo get();

    public boolean hasUpdate();

    public boolean includeOnce();

    public static class TypeDictionary
    implements SerializerTypeInfoStrategy {
        protected static final Logger logger = Logging.getLogger(SerializerTypeInfoStrategy.class);
        protected final PersistenceTypeDictionary persistenceTypeDictionary;
        protected final PersistenceTypeDictionaryAssembler typeAssembler;
        protected boolean updateAvailable;
        protected final boolean includeTypeInfoOnce;

        public TypeDictionary(PersistenceManager<Binary> persistenceManager, boolean includeTypeInfoOnce) {
            this.persistenceTypeDictionary = persistenceManager.typeDictionary();
            this.typeAssembler = PersistenceTypeDictionaryAssembler.New();
            this.includeTypeInfoOnce = includeTypeInfoOnce;
            persistenceManager.typeDictionary().setTypeDescriptionRegistrationObserver((PersistenceTypeDefinitionRegistrationObserver)this);
        }

        public void observeTypeDefinitionRegistration(PersistenceTypeDefinition typeDefinition) {
            logger.debug("New type registered: {}.", (Object)typeDefinition);
            this.updateAvailable = true;
        }

        @Override
        public SerializerTypeInfo get() {
            String assembledTypeDictionary = this.typeAssembler.assemble(this.persistenceTypeDictionary);
            SerializerTypeInfo typeInfo = new SerializerTypeInfo((XGettingList<String>)new BulkList((Object)assembledTypeDictionary).immure());
            this.updateAvailable = false;
            return typeInfo;
        }

        @Override
        public boolean hasUpdate() {
            return this.updateAvailable;
        }

        @Override
        public boolean includeOnce() {
            return this.includeTypeInfoOnce;
        }
    }

    public static class Diff
    extends IncrementalDiff {
        public Diff(PersistenceManager<Binary> persistenceManager, boolean includeTypeInfoOnce) {
            super(persistenceManager, includeTypeInfoOnce);
        }

        @Override
        public SerializerTypeInfo get() {
            SerializerTypeInfo typeInfo = new SerializerTypeInfo((XGettingList<String>)this.newTypes.immure());
            this.updateAvailable = false;
            return typeInfo;
        }
    }

    public static class IncrementalDiff
    implements SerializerTypeInfoStrategy {
        protected static final Logger logger = Logging.getLogger(SerializerTypeInfoStrategy.class);
        protected final PersistenceTypeDictionaryAssembler typeAssembler = PersistenceTypeDictionaryAssembler.New();
        protected final XList<String> newTypes = BulkList.New();
        protected boolean updateAvailable;
        protected final boolean includeTypeInfoOnce;

        public IncrementalDiff(PersistenceManager<Binary> persistenceManager, boolean includeTypeInfoOnce) {
            this.includeTypeInfoOnce = includeTypeInfoOnce;
            persistenceManager.typeDictionary().setTypeDescriptionRegistrationObserver((PersistenceTypeDefinitionRegistrationObserver)this);
        }

        public void observeTypeDefinitionRegistration(PersistenceTypeDefinition typeDefinition) {
            logger.debug("new type registered: {}", (Object)typeDefinition);
            VarString vc = VarString.New();
            this.typeAssembler.assembleTypeDescription(vc, (PersistenceTypeDescription)typeDefinition);
            this.newTypes.add((Object)vc.toString());
            this.updateAvailable = true;
        }

        @Override
        public SerializerTypeInfo get() {
            SerializerTypeInfo typeInfo = new SerializerTypeInfo((XGettingList<String>)this.newTypes.immure());
            this.newTypes.clear();
            this.updateAvailable = false;
            return typeInfo;
        }

        @Override
        public boolean hasUpdate() {
            return this.updateAvailable;
        }

        @Override
        public boolean includeOnce() {
            return this.includeTypeInfoOnce;
        }
    }
}

