/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import one.microstream.collections.types.XGettingSequence;
import one.microstream.equality.Equalator;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceExceptionTypeImportTypeNotFound;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerEnsurer;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface TypeDefinitionImporter {
    public void importTypeDefinition(PersistenceTypeDefinition var1);

    public void importTypeDefinitions(XGettingSequence<PersistenceTypeDefinition> var1);

    public static class Default
    implements TypeDefinitionImporter {
        private static final Logger logger = Logging.getLogger(Default.class);
        private final PersistenceTypeHandlerManager<Binary> typeHandlerManager;
        private final PersistenceTypeHandlerEnsurer<Binary> typeHandlerEnsurer;
        private final Equalator<PersistenceTypeDescriptionMember> memberValidator = (m1, m2) -> {
            if (m1 == null || m2 == null) {
                return false;
            }
            return m1.equalsStructure(m2);
        };

        public Default(PersistenceTypeHandlerManager<Binary> typeHandlerManager, PersistenceTypeHandlerEnsurer<Binary> typeHandlerEnsurer) {
            this.typeHandlerManager = typeHandlerManager;
            this.typeHandlerEnsurer = typeHandlerEnsurer;
        }

        @Override
        public void importTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            if (typeDefinition.type() != null) {
                PersistenceTypeHandler handler = this.typeHandlerManager.lookupTypeHandler(typeDefinition.type());
                if (handler != null) {
                    if (PersistenceTypeDescriptionMember.equalMembers((XGettingSequence)typeDefinition.allMembers(), (XGettingSequence)handler.allMembers(), this.memberValidator)) {
                        logger.trace("Handler for type {}, typeId {} already registered.", (Object)typeDefinition.type(), (Object)typeDefinition.typeId());
                    } else {
                        logger.trace("Trying to create legacy type handler for type {}, typeId {}.", (Object)typeDefinition.type(), (Object)typeDefinition.typeId());
                        this.typeHandlerManager.updateCurrentHighestTypeId(typeDefinition.typeId());
                        this.typeHandlerManager.ensureLegacyTypeHandler(typeDefinition, handler);
                    }
                } else {
                    PersistenceTypeHandler th = this.typeHandlerEnsurer.ensureTypeHandler(typeDefinition.type());
                    if (PersistenceTypeDescriptionMember.equalMembers((XGettingSequence)typeDefinition.allMembers(), (XGettingSequence)th.allMembers(), this.memberValidator)) {
                        logger.trace("Trying to create type handler for new type {}, typeId {}.", (Object)typeDefinition.type(), (Object)typeDefinition.typeId());
                        this.typeHandlerManager.ensureTypeHandler(typeDefinition.type());
                    } else {
                        logger.trace("Trying to create legacy type handler for new type {}, typeId {}.", (Object)typeDefinition.type(), (Object)typeDefinition.typeId());
                        this.typeHandlerManager.updateCurrentHighestTypeId(typeDefinition.typeId());
                        this.typeHandlerManager.ensureLegacyTypeHandler(typeDefinition, th);
                    }
                }
            } else {
                logger.error("Failed to resolve new type {}.", (Object)typeDefinition.typeName());
                throw new BinaryPersistenceExceptionTypeImportTypeNotFound(typeDefinition.typeName());
            }
        }

        @Override
        public void importTypeDefinitions(XGettingSequence<PersistenceTypeDefinition> typeDefinitions) {
            for (PersistenceTypeDefinition typeDefinition : typeDefinitions) {
                this.importTypeDefinition(typeDefinition);
            }
        }
    }
}

