/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import java.util.Scanner;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingSet;
import one.microstream.math.XMath;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.internal.PrintingLegacyTypeMappingResultor;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResult;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResultor;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.util.similarity.MultiMatch;
import one.microstream.util.similarity.Similarity;

public class InquiringLegacyTypeMappingResultor<D>
implements PersistenceLegacyTypeMappingResultor<D> {
    private final PersistenceLegacyTypeMappingResultor<D> delegate;
    private final double inquirySimilarityThreshold;

    public static <D> InquiringLegacyTypeMappingResultor<D> New(PersistenceLegacyTypeMappingResultor<D> delegate) {
        return InquiringLegacyTypeMappingResultor.New(delegate, 1.0);
    }

    public static <D> InquiringLegacyTypeMappingResultor<D> New(PersistenceLegacyTypeMappingResultor<D> delegate, double minimumSimilarityThreshold) {
        return new InquiringLegacyTypeMappingResultor<D>((PersistenceLegacyTypeMappingResultor)X.notNull(delegate), XMath.notNegativeMax1((double)minimumSimilarityThreshold));
    }

    public static char approvalToken() {
        return 'y';
    }

    InquiringLegacyTypeMappingResultor(PersistenceLegacyTypeMappingResultor<D> delegate, double inquirySimilarityThreshold) {
        this.delegate = delegate;
        this.inquirySimilarityThreshold = inquirySimilarityThreshold;
    }

    private boolean inquiryRequired(PersistenceLegacyTypeMappingResult<D, ?> result, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings) {
        double lowestSimilarity = XMath.min_double((Iterable)result.currentToLegacyMembers().values(), Similarity::_similarity);
        boolean hasUnmappedDiscardedMembers = false;
        for (PersistenceTypeDefinitionMember discarded : result.discardedLegacyMembers()) {
            if (explicitMappings.keys().contains((Object)discarded)) continue;
            hasUnmappedDiscardedMembers = true;
            break;
        }
        return lowestSimilarity < this.inquirySimilarityThreshold || hasUnmappedDiscardedMembers;
    }

    @Override
    public <T> PersistenceLegacyTypeMappingResult<D, T> createMappingResult(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, XGettingSet<PersistenceTypeDefinitionMember> explicitNewMembers, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers) {
        PersistenceLegacyTypeMappingResult<D, T> result = this.delegate.createMappingResult(legacyTypeDefinition, currentTypeHandler, explicitMappings, explicitNewMembers, matchedMembers);
        boolean inquiryRequired = this.inquiryRequired(result, explicitMappings);
        if (!inquiryRequired) {
            String output = PrintingLegacyTypeMappingResultor.assembleMappingWithHeader(explicitMappings, matchedMembers, result);
            System.out.println(output);
            return result;
        }
        boolean approved = this.inquireApproval(explicitMappings, matchedMembers, result);
        if (approved) {
            return result;
        }
        throw new PersistenceException("User-aborted legacy type mapping for type " + legacyTypeDefinition.toTypeIdentifier());
    }

    protected boolean inquireApproval(XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers, PersistenceLegacyTypeMappingResult<D, ?> result) {
        System.out.println(this.buildInquiry(explicitMappings, matchedMembers, result));
        Scanner scanner = new Scanner(System.in);
        String input = XChars.trimEmptyToNull((String)scanner.nextLine());
        return input != null && Character.toLowerCase(input.charAt(0)) == InquiringLegacyTypeMappingResultor.approvalToken();
    }

    protected String buildInquiry(XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers, PersistenceLegacyTypeMappingResult<D, ?> result) {
        VarString vs = VarString.New((int)1000);
        PrintingLegacyTypeMappingResultor.assembleMappingHeader(vs, result);
        PrintingLegacyTypeMappingResultor.assembleMapping(vs, explicitMappings, matchedMembers, result);
        this.assembleInquiryEnd(vs, result);
        String inquiry = vs.toString();
        return inquiry;
    }

    protected VarString assembleInquiryEnd(VarString vs, PersistenceLegacyTypeMappingResult<D, ?> result) {
        vs.add("---").lf().add("Write '").add(InquiringLegacyTypeMappingResultor.approvalToken()).add("' to accept the mapping.");
        return vs;
    }
}

