/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.XChars;
import one.microstream.io.XIO;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionSource;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceTypeDictionaryIoHandler;
import one.microstream.persistence.types.PersistenceTypeDictionaryStorer;

public class PersistenceTypeDictionaryFileHandler
implements PersistenceTypeDictionaryIoHandler {
    private final AFile file;
    private final PersistenceTypeDictionaryStorer writeListener;

    public static final String readTypeDictionary(AFile file) {
        return PersistenceTypeDictionaryFileHandler.readTypeDictionary(file, null);
    }

    public static final String readTypeDictionary(AFile file, String defaultString) {
        String string;
        if (!file.exists()) {
            return defaultString;
        }
        AReadableFile rFile = file.useReading();
        try {
            ByteBuffer bb = rFile.readBytes();
            string = XChars.String((ByteBuffer)bb, (Charset)Persistence.standardCharset());
        }
        catch (Throwable throwable) {
            try {
                rFile.release();
                throw throwable;
            }
            catch (Exception e) {
                throw new PersistenceExceptionSource(e);
            }
        }
        rFile.release();
        return string;
    }

    public static final void writeTypeDictionary(AFile file, String typeDictionaryString) {
        try {
            AWritableFile wFile = file.useWriting();
            if (wFile.exists()) {
                wFile.truncate(0L);
            } else {
                wFile.create();
            }
            try {
                byte[] bytes = typeDictionaryString.getBytes(Persistence.standardCharset());
                ByteBuffer dbb = XIO.wrapInDirectByteBuffer((byte[])bytes);
                wFile.writeBytes((Iterable)X.List((Object[])new ByteBuffer[]{dbb}));
            }
            finally {
                wFile.release();
            }
        }
        catch (Exception t) {
            throw new PersistenceException(t);
        }
    }

    @Deprecated
    public static PersistenceTypeDictionaryFileHandler NewInDirectory(ADirectory directory) {
        return PersistenceTypeDictionaryFileHandler.New(directory);
    }

    public static PersistenceTypeDictionaryFileHandler New(ADirectory directory) {
        return PersistenceTypeDictionaryFileHandler.New(directory, null);
    }

    public static PersistenceTypeDictionaryFileHandler New(AFile file) {
        return PersistenceTypeDictionaryFileHandler.New(file, null);
    }

    @Deprecated
    public static PersistenceTypeDictionaryFileHandler NewInDirectory(ADirectory directory, PersistenceTypeDictionaryStorer writeListener) {
        return PersistenceTypeDictionaryFileHandler.New(directory, writeListener);
    }

    public static PersistenceTypeDictionaryFileHandler New(ADirectory directory, PersistenceTypeDictionaryStorer writeListener) {
        return new PersistenceTypeDictionaryFileHandler(directory.ensureFile(Persistence.defaultFilenameTypeDictionary()), (PersistenceTypeDictionaryStorer)X.mayNull((Object)writeListener));
    }

    public static PersistenceTypeDictionaryFileHandler New(AFile file, PersistenceTypeDictionaryStorer writeListener) {
        return new PersistenceTypeDictionaryFileHandler((AFile)X.notNull((Object)file), (PersistenceTypeDictionaryStorer)X.mayNull((Object)writeListener));
    }

    PersistenceTypeDictionaryFileHandler(AFile file, PersistenceTypeDictionaryStorer writeListener) {
        this.file = file;
        this.writeListener = writeListener;
    }

    protected AFile file() {
        return this.file;
    }

    @Override
    public final synchronized String loadTypeDictionary() {
        return PersistenceTypeDictionaryFileHandler.readTypeDictionary(this.file);
    }

    protected synchronized void writeTypeDictionary(String typeDictionaryString) {
        PersistenceTypeDictionaryFileHandler.writeTypeDictionary(this.file, typeDictionaryString);
    }

    @Override
    public final synchronized void storeTypeDictionary(String typeDictionaryString) {
        this.writeTypeDictionary(typeDictionaryString);
        if (this.writeListener != null) {
            this.writeListener.storeTypeDictionary(typeDictionaryString);
        }
    }

    public static Provider ProviderInDirectory(ADirectory directory) {
        return new Provider(directory.ensureFile(Persistence.defaultFilenameTypeDictionary()));
    }

    public static Provider Provider(AFile file) {
        return new Provider((AFile)X.notNull((Object)file));
    }

    @FunctionalInterface
    public static interface Creator {
        public PersistenceTypeDictionaryIoHandler createTypeDictionaryIoHandler(AFile var1, PersistenceTypeDictionaryStorer var2);
    }

    public static final class Provider
    implements PersistenceTypeDictionaryIoHandler.Provider {
        private final AFile file;

        Provider(AFile file) {
            this.file = file;
        }

        @Override
        public PersistenceTypeDictionaryFileHandler provideTypeDictionaryIoHandler(PersistenceTypeDictionaryStorer writeListener) {
            return PersistenceTypeDictionaryFileHandler.New(this.file);
        }
    }
}

