/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import one.microstream.chars.VarString;
import one.microstream.functional.Aggregator;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberAppender;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldReflective;

public final class TypeDictionaryAppenderBuilder
implements Aggregator<PersistenceTypeDescriptionMember, PersistenceTypeDescriptionMemberAppender> {
    private final VarString vc;
    private final int level;
    int maxFieldTypeNameLength;
    int maxDeclaringTypeNameLength;
    int maxFieldNameLength;

    public TypeDictionaryAppenderBuilder(VarString vc, int level) {
        this.vc = vc;
        this.level = level;
    }

    private void measureTypeName(String typeName) {
        if (typeName.length() > this.maxFieldTypeNameLength) {
            this.maxFieldTypeNameLength = typeName.length();
        }
    }

    private void measureDeclaringTypeName(String declaringTypeName) {
        if (declaringTypeName.length() > this.maxDeclaringTypeNameLength) {
            this.maxDeclaringTypeNameLength = declaringTypeName.length();
        }
    }

    private void measureFieldName(String fieldName) {
        if (fieldName.length() > this.maxFieldNameLength) {
            this.maxFieldNameLength = fieldName.length();
        }
    }

    private void measureFieldStrings(PersistenceTypeDescriptionMemberFieldReflective member) {
        this.measureTypeName(member.typeName());
        this.measureDeclaringTypeName(member.declaringTypeName());
        this.measureFieldName(member.name());
    }

    private void measureGenericFieldStrings(PersistenceTypeDescriptionMemberFieldGeneric member) {
        this.measureTypeName(member.typeName());
        this.measureFieldName(member.name());
    }

    public final void accept(PersistenceTypeDescriptionMember member) {
        if (member instanceof PersistenceTypeDescriptionMemberFieldReflective) {
            this.measureFieldStrings((PersistenceTypeDescriptionMemberFieldReflective)member);
        } else if (member instanceof PersistenceTypeDescriptionMemberFieldGeneric) {
            this.measureGenericFieldStrings((PersistenceTypeDescriptionMemberFieldGeneric)member);
        }
    }

    public final PersistenceTypeDescriptionMemberAppender yield() {
        return new PersistenceTypeDescriptionMemberAppender.Default(this.vc, this.level, this.maxFieldTypeNameLength, this.maxDeclaringTypeNameLength, this.maxFieldNameLength);
    }
}

