/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.collections.types.XGettingEnum;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.reflect.XReflect;

public interface PersistenceLegacyTypeHandler<D, T>
extends PersistenceTypeHandler<D, T> {
    @Override
    default public PersistenceLegacyTypeHandler<D, T> initialize(long typeId) {
        if (typeId == this.typeId()) {
            return this;
        }
        throw new PersistenceException("Specified type ID " + typeId + " conflicts with already initalized type ID " + this.typeId());
    }

    @Override
    default public void store(D data, T instance, long objectId, PersistenceStoreHandler<D> handler) {
        throw new UnsupportedOperationException(String.valueOf(PersistenceLegacyTypeHandler.class.getSimpleName()) + " for type " + this.toTypeIdentifier() + " may never store anything.");
    }

    @Override
    default public Object[] collectEnumConstants() {
        return null;
    }

    public static <T, D> T resolveEnumConstant(PersistenceLegacyTypeHandler<D, T> typeHandler, D data, Integer[] ordinalMap) {
        int persistedEnumOrdinal = typeHandler.getPersistedEnumOrdinal(data);
        Integer mappedOrdinal = ordinalMap[persistedEnumOrdinal];
        if (mappedOrdinal == null) {
            return null;
        }
        return (T)XReflect.resolveEnumConstantInstanceTyped(typeHandler.type(), (int)mappedOrdinal);
    }

    public static abstract class Abstract<D, T>
    implements PersistenceLegacyTypeHandler<D, T> {
        private final PersistenceTypeDefinition typeDefinition;

        protected Abstract(PersistenceTypeDefinition typeDefinition) {
            this.typeDefinition = typeDefinition;
        }

        @Override
        public final long typeId() {
            return this.typeDefinition.typeId();
        }

        @Override
        public final String runtimeTypeName() {
            return this.typeDefinition.runtimeTypeName();
        }

        @Override
        public final String typeName() {
            return this.typeDefinition.typeName();
        }

        @Override
        public final boolean isPrimitiveType() {
            return this.typeDefinition.isPrimitiveType();
        }

        public PersistenceTypeDefinition legacyTypeDefinition() {
            return this.typeDefinition;
        }

        @Override
        public final XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
            return this.typeDefinition.allMembers();
        }

        @Override
        public final XGettingEnum<? extends PersistenceTypeDefinitionMember> instanceMembers() {
            return this.typeDefinition.instanceMembers();
        }

        @Override
        public final long membersPersistedLengthMinimum() {
            return this.typeDefinition.membersPersistedLengthMinimum();
        }

        @Override
        public final long membersPersistedLengthMaximum() {
            return this.typeDefinition.membersPersistedLengthMaximum();
        }

        @Override
        public final boolean hasPersistedReferences() {
            return this.typeDefinition.hasPersistedReferences();
        }

        @Override
        public final boolean hasPersistedVariableLength() {
            return this.typeDefinition.hasPersistedVariableLength();
        }

        @Override
        public final boolean hasVaryingPersistedLengthInstances() {
            return this.typeDefinition.hasVaryingPersistedLengthInstances();
        }
    }
}

