/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.Iterator;
import java.util.Objects;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.equality.Equalator;
import one.microstream.hashing.HashEqualator;
import one.microstream.math.XMath;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberCreator;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberAppender;

public interface PersistenceTypeDescriptionMember {
    public String typeName();

    public String qualifier();

    public String identifier();

    public String name();

    public boolean isInstanceMember();

    default public boolean equalsDescription(PersistenceTypeDescriptionMember other) {
        return this.equalsStructure(other) && other != null && Objects.equals(this.qualifier(), other.qualifier());
    }

    default public boolean equalsStructure(PersistenceTypeDescriptionMember other) {
        return PersistenceTypeDescriptionMember.equalTypeAndName(this, other);
    }

    public static boolean equalTypeAndName(PersistenceTypeDescriptionMember m1, PersistenceTypeDescriptionMember m2) {
        return m1 == m2 || m2 != null && Objects.equals(m1.typeName(), m2.typeName()) && Objects.equals(m1.name(), m2.name());
    }

    public static boolean equalTypeAndNameAndQualifier(PersistenceTypeDescriptionMember m1, PersistenceTypeDescriptionMember m2) {
        return PersistenceTypeDescriptionMember.equalTypeAndName(m1, m2) && m2 != null && Objects.equals(m1.qualifier(), m2.qualifier());
    }

    public static boolean equalStructure(PersistenceTypeDescriptionMember m1, PersistenceTypeDescriptionMember m2) {
        return m1 == m2 || m1 != null && m1.equalsStructure(m2);
    }

    public static boolean equalDescription(PersistenceTypeDescriptionMember m1, PersistenceTypeDescriptionMember m2) {
        return m1 == m2 || m1 != null && m1.equalsDescription(m2);
    }

    public static long calculatePersistentMinimumLength(long startValue, Iterable<? extends PersistenceTypeDescriptionMember> members) {
        long length = startValue;
        for (PersistenceTypeDescriptionMember persistenceTypeDescriptionMember : members) {
            length = XMath.addCapped((long)length, (long)persistenceTypeDescriptionMember.persistentMinimumLength());
        }
        return length;
    }

    public static long calculatePersistentMaximumLength(long startValue, Iterable<? extends PersistenceTypeDescriptionMember> members) {
        long length = startValue;
        for (PersistenceTypeDescriptionMember persistenceTypeDescriptionMember : members) {
            length = XMath.addCapped((long)length, (long)persistenceTypeDescriptionMember.persistentMaximumLength());
        }
        return length;
    }

    public void assembleTypeDescription(PersistenceTypeDescriptionMemberAppender var1);

    public boolean isReference();

    public boolean isPrimitive();

    public boolean isPrimitiveDefinition();

    public boolean isEnumConstant();

    public boolean hasReferences();

    default public boolean isVariableLength() {
        return this.persistentMinimumLength() != this.persistentMaximumLength();
    }

    default public boolean isFixedLength() {
        return this.persistentMinimumLength() == this.persistentMaximumLength();
    }

    public long persistentMinimumLength();

    public long persistentMaximumLength();

    public boolean isValidPersistentLength(long var1);

    public void validatePersistentLength(long var1);

    default public boolean isIdentical(PersistenceTypeDescriptionMember other) {
        return PersistenceTypeDescriptionMember.isIdentical(this, other);
    }

    public static boolean isIdentical(PersistenceTypeDescriptionMember m1, PersistenceTypeDescriptionMember m2) {
        return m1 == m2 || m1 != null && m2 != null && m1.identifier().equals(m2.identifier());
    }

    public static int identityHash(PersistenceTypeDescriptionMember member) {
        return member == null ? 0 : member.identifier().hashCode();
    }

    public static IdentityHashEqualator identityHashEqualator() {
        return IdentityHashEqualator.SINGLETON;
    }

    public static boolean determineHasReferences(Iterable<? extends PersistenceTypeDescriptionMember> members) {
        for (PersistenceTypeDescriptionMember persistenceTypeDescriptionMember : members) {
            if (!persistenceTypeDescriptionMember.hasReferences()) continue;
            return true;
        }
        return false;
    }

    public static boolean determineIsPrimitive(XGettingSequence<? extends PersistenceTypeDescriptionMember> members) {
        return members.size() == 1L && ((PersistenceTypeDescriptionMember)members.get()).isPrimitiveDefinition();
    }

    public static boolean equalDescriptions(XGettingSequence<? extends PersistenceTypeDescriptionMember> members1, XGettingSequence<? extends PersistenceTypeDescriptionMember> members2) {
        return PersistenceTypeDescriptionMember.equalMembers(members1, members2, (Equalator<PersistenceTypeDescriptionMember>)((Equalator)PersistenceTypeDescriptionMember::equalDescription));
    }

    public static boolean equalStructures(XGettingSequence<? extends PersistenceTypeDescriptionMember> members1, XGettingSequence<? extends PersistenceTypeDescriptionMember> members2) {
        return PersistenceTypeDescriptionMember.equalMembers(members1, members2, (Equalator<PersistenceTypeDescriptionMember>)((Equalator)PersistenceTypeDescriptionMember::equalStructure));
    }

    public static boolean equalMembers(XGettingSequence<? extends PersistenceTypeDescriptionMember> members1, XGettingSequence<? extends PersistenceTypeDescriptionMember> members2, Equalator<PersistenceTypeDescriptionMember> equalator) {
        Iterator it1 = members1.iterator();
        Iterator it2 = members2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            PersistenceTypeDescriptionMember member2;
            PersistenceTypeDescriptionMember member1 = it1.hasNext() ? (PersistenceTypeDescriptionMember)it1.next() : null;
            PersistenceTypeDescriptionMember persistenceTypeDescriptionMember = member2 = it2.hasNext() ? (PersistenceTypeDescriptionMember)it2.next() : null;
            if (equalator.equal((Object)member1, (Object)member2)) continue;
            return false;
        }
        return true;
    }

    public PersistenceTypeDefinitionMember createDefinitionMember(PersistenceTypeDefinitionMemberCreator var1);

    public static final class IdentityHashEqualator
    implements HashEqualator<PersistenceTypeDescriptionMember> {
        static final IdentityHashEqualator SINGLETON = new IdentityHashEqualator();

        public final int hash(PersistenceTypeDescriptionMember member) {
            return PersistenceTypeDescriptionMember.identityHash(member);
        }

        public final boolean equal(PersistenceTypeDescriptionMember m1, PersistenceTypeDescriptionMember m2) {
            return PersistenceTypeDescriptionMember.isIdentical(m1, m2);
        }
    }
}

