/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.entity.Entity;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceAbstractTypeHandlerSearcher;
import one.microstream.persistence.types.PersistenceCustomTypeHandlerRegistry;
import one.microstream.persistence.types.PersistenceDataTypeHolder;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceTypeAnalyzer;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerCreator;
import one.microstream.persistence.types.PersistenceTypeHandlerIterable;
import one.microstream.reflect.XReflect;
import one.microstream.typing.LambdaTypeRecognizer;

public interface PersistenceTypeHandlerEnsurer<D>
extends PersistenceTypeHandlerIterable<D>,
PersistenceDataTypeHolder<D> {
    public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public static <D> Default<D> New(Class<D> dataType, PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry, PersistenceTypeAnalyzer typeAnalyzer, LambdaTypeRecognizer lambdaTypeRecognizer, PersistenceAbstractTypeHandlerSearcher<D> abstractTypeHandlerSearcher, PersistenceTypeHandlerCreator<D> typeHandlerCreator) {
        return new Default((Class)X.notNull(dataType), (PersistenceCustomTypeHandlerRegistry)X.notNull(customTypeHandlerRegistry), (PersistenceTypeAnalyzer)X.notNull((Object)typeAnalyzer), (LambdaTypeRecognizer)X.notNull((Object)lambdaTypeRecognizer), (PersistenceAbstractTypeHandlerSearcher)X.notNull(abstractTypeHandlerSearcher), (PersistenceTypeHandlerCreator)X.notNull(typeHandlerCreator));
    }

    public static class Default<D>
    extends PersistenceDataTypeHolder.Default<D>
    implements PersistenceTypeHandlerEnsurer<D> {
        final PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry;
        final PersistenceTypeAnalyzer typeAnalyzer;
        final LambdaTypeRecognizer lambdaTypeRecognizer;
        final PersistenceAbstractTypeHandlerSearcher<D> abstractTypeHandlerSearcher;
        final PersistenceTypeHandlerCreator<D> typeHandlerCreator;

        Default(Class<D> dataType, PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry, PersistenceTypeAnalyzer typeAnalyzer, LambdaTypeRecognizer lambdaTypeRecognizer, PersistenceAbstractTypeHandlerSearcher<D> abstractTypeHandlerSearcher, PersistenceTypeHandlerCreator<D> typeHandlerCreator) {
            super(dataType);
            this.customTypeHandlerRegistry = customTypeHandlerRegistry;
            this.typeAnalyzer = typeAnalyzer;
            this.lambdaTypeRecognizer = lambdaTypeRecognizer;
            this.abstractTypeHandlerSearcher = abstractTypeHandlerSearcher;
            this.typeHandlerCreator = typeHandlerCreator;
        }

        @Override
        public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            PersistenceTypeHandler<D, T> providedHandler = this.searchProvidedTypeHandler(type);
            if (providedHandler != null) {
                return providedHandler;
            }
            PersistenceTypeHandler<D, T> customHandler = this.customTypeHandlerRegistry.lookupTypeHandler(type);
            if (customHandler != null) {
                return customHandler;
            }
            if (type.isPrimitive()) {
                throw new PersistenceException("Primitive types must be handled by default (dummy) handler implementations.");
            }
            if (type == Class.class) {
                throw new PersistenceException("Persisting " + Class.class.getSimpleName() + " instances requires a special-tailored " + PersistenceTypeHandler.class.getSimpleName() + " and cannot be done in a generic way.");
            }
            if (XReflect.isProxyClass(type)) {
                return this.typeHandlerCreator.createTypeHandlerProxy(type);
            }
            if (type.isArray()) {
                return this.typeHandlerCreator.createTypeHandlerArray(type);
            }
            if (this.lambdaTypeRecognizer.isLambdaType(type)) {
                return this.typeHandlerCreator.createTypeHandlerLambda(type);
            }
            if (this.typeAnalyzer.isUnpersistable(type)) {
                return this.typeHandlerCreator.createTypeHandlerUnpersistable(type);
            }
            if (XReflect.isEnum(type)) {
                return this.typeHandlerCreator.createTypeHandlerEnum(type);
            }
            if (XReflect.isAbstract(type)) {
                return this.typeHandlerCreator.createTypeHandlerAbstract(type);
            }
            if (Entity.class.isAssignableFrom(type)) {
                return this.typeHandlerCreator.createTypeHandlerEntity(type);
            }
            PersistenceTypeHandler<D, T> abstractHandler = this.lookupAbstractTypeHandler(type);
            if (abstractHandler != null) {
                return abstractHandler;
            }
            return this.typeHandlerCreator.createTypeHandlerGeneric(type);
        }

        protected <T> PersistenceTypeHandler<D, ? super T> lookupAbstractTypeHandler(Class<T> type) {
            return this.abstractTypeHandlerSearcher.searchAbstractTypeHandler(type, this.customTypeHandlerRegistry);
        }

        protected <T> PersistenceTypeHandler<D, ? super T> searchProvidedTypeHandler(Class<T> type) {
            try {
                return Persistence.searchProvidedTypeHandler(this.dataType(), type, null);
            }
            catch (ReflectiveOperationException e) {
                throw new PersistenceException(e);
            }
        }

        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateTypeHandlers(C iterator) {
            return this.customTypeHandlerRegistry.iterateTypeHandlers(iterator);
        }

        @Override
        public <C extends Consumer<? super PersistenceLegacyTypeHandler<D, ?>>> C iterateLegacyTypeHandlers(C iterator) {
            return this.customTypeHandlerRegistry.iterateLegacyTypeHandlers(iterator);
        }

        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateAllTypeHandlers(C iterator) {
            return this.customTypeHandlerRegistry.iterateAllTypeHandlers(iterator);
        }
    }
}

