/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistency;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistencyUnknownTid;
import one.microstream.persistence.types.PersistenceTypeIdProvider;
import one.microstream.persistence.types.PersistenceTypeLink;
import one.microstream.persistence.types.PersistenceTypeRegistry;
import one.microstream.reference.Swizzling;

public interface PersistenceTypeManager
extends PersistenceTypeRegistry {
    public long ensureTypeId(Class<?> var1);

    public Class<?> ensureType(long var1);

    public long currentTypeId();

    public void updateCurrentHighestTypeId(long var1);

    public static Default New(PersistenceTypeRegistry registry, PersistenceTypeIdProvider tidProvider) {
        return new Default((PersistenceTypeRegistry)X.notNull((Object)registry), (PersistenceTypeIdProvider)X.notNull((Object)tidProvider));
    }

    public static final class Default
    implements PersistenceTypeManager {
        final PersistenceTypeRegistry typeRegistry;
        final PersistenceTypeIdProvider tidProvider;

        Default(PersistenceTypeRegistry registry, PersistenceTypeIdProvider tidProvider) {
            this.typeRegistry = (PersistenceTypeRegistry)X.notNull((Object)registry);
            this.tidProvider = (PersistenceTypeIdProvider)X.notNull((Object)tidProvider);
        }

        protected long createNewTypeId() {
            return this.tidProvider.provideNextTypeId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long internalEnsureTypeId(Class<?> type) {
            long typeId;
            PersistenceTypeRegistry persistenceTypeRegistry = this.typeRegistry;
            synchronized (persistenceTypeRegistry) {
                typeId = this.typeRegistry.lookupTypeId(type);
                if (Swizzling.isFoundId((long)typeId)) {
                    return typeId;
                }
                typeId = this.createNewTypeId();
                this.typeRegistry.registerType(typeId, type);
                if (type.getSuperclass() != null) {
                    this.ensureTypeId(type.getSuperclass());
                }
            }
            return typeId;
        }

        @Override
        public long lookupTypeId(Class<?> type) {
            return this.typeRegistry.lookupTypeId(type);
        }

        @Override
        public <T> Class<T> lookupType(long tid) {
            return this.typeRegistry.lookupType(tid);
        }

        @Override
        public boolean validateTypeMapping(long typeId, Class<?> type) throws PersistenceExceptionConsistency {
            return this.typeRegistry.validateTypeMapping(typeId, type);
        }

        @Override
        public boolean validateTypeMappings(Iterable<? extends PersistenceTypeLink> mappings) throws PersistenceExceptionConsistency {
            return this.typeRegistry.validateTypeMappings(mappings);
        }

        @Override
        public boolean registerTypes(Iterable<? extends PersistenceTypeLink> types) throws PersistenceExceptionConsistency {
            return this.typeRegistry.registerTypes(types);
        }

        @Override
        public boolean registerType(long tid, Class<?> type) {
            return this.typeRegistry.registerType(tid, type);
        }

        @Override
        public long ensureTypeId(Class<?> type) {
            long typeId = this.typeRegistry.lookupTypeId(type);
            if (Swizzling.isFoundId((long)typeId)) {
                return typeId;
            }
            return this.internalEnsureTypeId(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long currentTypeId() {
            PersistenceTypeRegistry persistenceTypeRegistry = this.typeRegistry;
            synchronized (persistenceTypeRegistry) {
                return this.tidProvider.currentTypeId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateCurrentHighestTypeId(long highestTypeId) {
            PersistenceTypeRegistry persistenceTypeRegistry = this.typeRegistry;
            synchronized (persistenceTypeRegistry) {
                long currentTypeId = this.tidProvider.currentTypeId();
                if (currentTypeId > highestTypeId) {
                    throw new IllegalArgumentException("Current highest type id already passed desired new highest type id: " + currentTypeId + " > " + highestTypeId);
                }
                this.tidProvider.updateCurrentTypeId(highestTypeId);
            }
        }

        @Override
        public Class<?> ensureType(long typeId) {
            Class type = this.typeRegistry.lookupType(typeId);
            if (type == null) {
                throw new PersistenceExceptionConsistencyUnknownTid(typeId);
            }
            return type;
        }
    }
}

