/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.persistence.internal.FileObjectIdProvider;
import one.microstream.persistence.types.PersistenceObjectIdProvider;
import one.microstream.persistence.types.PersistenceObjectIdStrategy;

public final class FileObjectIdStrategy
implements PersistenceObjectIdStrategy {
    private static final long DEFAULT_INCREASE = 1000L;
    private final AFile objectIdFile;

    public static String strategyTypeName() {
        return "FilePersistence";
    }

    public static String defaultFilename() {
        return "ObjectId.oid";
    }

    public static FileObjectIdStrategy NewInDirectory(ADirectory directory) {
        return FileObjectIdStrategy.New(directory, FileObjectIdStrategy.defaultFilename());
    }

    public static FileObjectIdStrategy New(ADirectory directory, String objectIdFilename) {
        return FileObjectIdStrategy.New(directory.ensureFile(objectIdFilename));
    }

    public static FileObjectIdStrategy New(AFile objectIdFile) {
        return new FileObjectIdStrategy((AFile)X.notNull((Object)objectIdFile));
    }

    FileObjectIdStrategy(AFile objectIdFile) {
        this.objectIdFile = objectIdFile;
    }

    @Override
    public final String strategyTypeNameObjectId() {
        return FileObjectIdStrategy.strategyTypeName();
    }

    @Override
    public final PersistenceObjectIdProvider createObjectIdProvider() {
        return FileObjectIdProvider.New(this.objectIdFile, 1000L);
    }
}

