/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.persistence.internal.FileTypeIdProvider;
import one.microstream.persistence.types.PersistenceTypeIdProvider;
import one.microstream.persistence.types.PersistenceTypeIdStrategy;

public class FileTypeIdStrategy
implements PersistenceTypeIdStrategy {
    private static final long DEFAULT_INCREASE = 1000L;
    private final AFile typeIdFile;

    public static String strategyTypeName() {
        return "FilePersistence";
    }

    public static String defaultFilename() {
        return "TypeId.tid";
    }

    public static FileTypeIdStrategy NewInDirectory(ADirectory directory) {
        return FileTypeIdStrategy.New(directory, FileTypeIdStrategy.defaultFilename());
    }

    public static FileTypeIdStrategy New(ADirectory directory, String typeIdFilename) {
        return FileTypeIdStrategy.New(directory.ensureFile(typeIdFilename));
    }

    public static FileTypeIdStrategy New(AFile typeIdFile) {
        return new FileTypeIdStrategy((AFile)X.notNull((Object)typeIdFile));
    }

    FileTypeIdStrategy(AFile typeIdFile) {
        this.typeIdFile = typeIdFile;
    }

    @Override
    public final String strategyTypeNameTypeId() {
        return FileTypeIdStrategy.strategyTypeName();
    }

    @Override
    public final PersistenceTypeIdProvider createTypeIdProvider() {
        return FileTypeIdProvider.New(this.typeIdFile, 1000L);
    }
}

