/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.persistence.internal.FileObjectIdStrategy;
import one.microstream.persistence.internal.FileTypeIdStrategy;
import one.microstream.persistence.types.PersistenceObjectIdProvider;
import one.microstream.persistence.types.PersistenceObjectIdStrategy;
import one.microstream.persistence.types.PersistenceTypeIdProvider;
import one.microstream.persistence.types.PersistenceTypeIdStrategy;

public interface PersistenceIdStrategy
extends PersistenceObjectIdStrategy,
PersistenceTypeIdStrategy {
    public PersistenceObjectIdStrategy objectIdStragegy();

    public PersistenceTypeIdStrategy typeIdStragegy();

    @Override
    default public String strategyTypeNameObjectId() {
        return this.objectIdStragegy().strategyTypeNameObjectId();
    }

    @Override
    default public String strategyTypeNameTypeId() {
        return this.typeIdStragegy().strategyTypeNameTypeId();
    }

    @Override
    default public PersistenceObjectIdProvider createObjectIdProvider() {
        return this.objectIdStragegy().createObjectIdProvider();
    }

    @Override
    default public PersistenceTypeIdProvider createTypeIdProvider() {
        return this.typeIdStragegy().createTypeIdProvider();
    }

    public static PersistenceIdStrategy NewInDirectory(ADirectory directory) {
        return PersistenceIdStrategy.NewFromFiles(directory, FileObjectIdStrategy.defaultFilename(), FileTypeIdStrategy.defaultFilename());
    }

    public static PersistenceIdStrategy NewFromFiles(ADirectory directory, String objectIdFilename, String typeIdFilename) {
        return PersistenceIdStrategy.NewFromFiles(directory.ensureFile(objectIdFilename), directory.ensureFile(typeIdFilename));
    }

    public static PersistenceIdStrategy NewFromFiles(AFile objectIdFile, AFile typeIdFile) {
        return new Default(FileObjectIdStrategy.New(objectIdFile), FileTypeIdStrategy.New(typeIdFile));
    }

    public static PersistenceIdStrategy New(PersistenceObjectIdStrategy objectIdStrategy, PersistenceTypeIdStrategy typeIdStrategy) {
        return new Default((PersistenceObjectIdStrategy)X.notNull((Object)objectIdStrategy), (PersistenceTypeIdStrategy)X.notNull((Object)typeIdStrategy));
    }

    public static class Default
    implements PersistenceIdStrategy {
        private final PersistenceObjectIdStrategy objectIdStrategy;
        private final PersistenceTypeIdStrategy typeIdStrategy;

        Default(PersistenceObjectIdStrategy objectIdStrategy, PersistenceTypeIdStrategy typeIdStrategy) {
            this.objectIdStrategy = objectIdStrategy;
            this.typeIdStrategy = typeIdStrategy;
        }

        @Override
        public PersistenceObjectIdStrategy objectIdStragegy() {
            return this.objectIdStrategy;
        }

        @Override
        public PersistenceTypeIdStrategy typeIdStragegy() {
            return this.typeIdStrategy;
        }
    }
}

