/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Consumer;
import one.microstream.collections.BulkList;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlerWrapper;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlerWrapperEnum;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResult;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerReflective;
import one.microstream.reflect.XReflect;
import one.microstream.util.similarity.Similarity;

public interface PersistenceLegacyTypeHandlerCreator<D> {
    public <T> PersistenceLegacyTypeHandler<D, T> createLegacyTypeHandler(PersistenceLegacyTypeMappingResult<D, T> var1);

    public static abstract class Abstract<D>
    implements PersistenceLegacyTypeHandlerCreator<D> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Integer[] deriveEnumOrdinalMapping(PersistenceLegacyTypeMappingResult<?, ?> result) {
            PersistenceTypeDefinition legacyTypeDef = result.legacyTypeDefinition();
            BulkList legacyConstantMembers = (BulkList)legacyTypeDef.allMembers().filterTo((Consumer)BulkList.New(), PersistenceTypeDescriptionMember::isEnumConstant);
            PersistenceTypeHandler<?, ?> currentTypeDef = result.currentTypeHandler();
            BulkList currentConstantMembers = (BulkList)currentTypeDef.allMembers().filterTo((Consumer)BulkList.New(), PersistenceTypeDescriptionMember::isEnumConstant);
            Integer[] ordinalMap = new Integer[legacyConstantMembers.intSize()];
            int ordinal = 0;
            for (PersistenceTypeDefinitionMember legacyMember : legacyConstantMembers) {
                Similarity match = (Similarity)result.legacyToCurrentMembers().get((Object)legacyMember);
                if (match == null) {
                    if (!result.discardedLegacyMembers().contains((Object)legacyMember)) throw new PersistenceException("Unmapped legacy enum constant: " + legacyTypeDef + "#" + legacyMember.name());
                    ordinalMap[ordinal] = null;
                } else {
                    PersistenceTypeDefinitionMember targetCurrentConstant = (PersistenceTypeDefinitionMember)match.targetElement();
                    long targetOrdinal = currentConstantMembers.indexOf((Object)targetCurrentConstant);
                    if (targetOrdinal < 0L) throw new PersistenceException("Inconsistent target enum constant: " + currentTypeDef + "#" + targetCurrentConstant.name());
                    ordinalMap[ordinal] = (int)targetOrdinal;
                }
                ++ordinal;
            }
            return ordinalMap;
        }

        @Override
        public <T> PersistenceLegacyTypeHandler<D, T> createLegacyTypeHandler(PersistenceLegacyTypeMappingResult<D, T> result) {
            if (PersistenceLegacyTypeMappingResult.isUnchangedInstanceStructure(result)) {
                return this.createTypeHandlerUnchangedInstanceStructure(result);
            }
            if (result.currentTypeHandler() instanceof PersistenceTypeHandlerReflective) {
                return this.deriveReflectiveHandler(result, (PersistenceTypeHandlerReflective)result.currentTypeHandler());
            }
            return this.deriveCustomWrappingHandler(result);
        }

        protected <T> PersistenceLegacyTypeHandler<D, T> createTypeHandlerUnchangedInstanceStructure(PersistenceLegacyTypeMappingResult<D, T> result) {
            if (XReflect.isEnum(result.currentTypeHandler().type())) {
                return this.createTypeHandlerUnchangedInstanceStructureGenericEnum(result);
            }
            return this.createTypeHandlerUnchangedInstanceStructureGenericType(result);
        }

        protected <T> PersistenceLegacyTypeHandler<D, T> createTypeHandlerUnchangedInstanceStructureGenericEnum(PersistenceLegacyTypeMappingResult<D, T> result) {
            return this.createTypeHandlerEnumWrapping(result, result.currentTypeHandler());
        }

        protected <T> PersistenceLegacyTypeHandler<D, T> createTypeHandlerEnumWrapping(PersistenceLegacyTypeMappingResult<D, T> result, PersistenceTypeHandler<D, T> typeHandler) {
            if (PersistenceLegacyTypeMappingResult.isUnchangedStaticStructure(result)) {
                return PersistenceLegacyTypeHandlerWrapper.New(result.legacyTypeDefinition(), typeHandler);
            }
            Integer[] ordinalMapping = Abstract.deriveEnumOrdinalMapping(result);
            return PersistenceLegacyTypeHandlerWrapperEnum.New(result.legacyTypeDefinition(), typeHandler, ordinalMapping);
        }

        protected <T> PersistenceLegacyTypeHandler<D, T> createTypeHandlerUnchangedInstanceStructureGenericType(PersistenceLegacyTypeMappingResult<D, T> result) {
            return PersistenceLegacyTypeHandlerWrapper.New(result.legacyTypeDefinition(), result.currentTypeHandler());
        }

        protected abstract <T> PersistenceLegacyTypeHandler<D, T> deriveCustomWrappingHandler(PersistenceLegacyTypeMappingResult<D, T> var1);

        protected abstract <T> PersistenceLegacyTypeHandler<D, T> deriveReflectiveHandler(PersistenceLegacyTypeMappingResult<D, T> var1, PersistenceTypeHandlerReflective<D, T> var2);
    }
}

