/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.Objects;
import one.microstream.X;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberCreator;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberEnumConstant;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberAppender;
import one.microstream.persistence.types.PersistenceTypeDictionary;

public interface PersistenceTypeDescriptionMemberEnumConstant
extends PersistenceTypeDescriptionMember {
    @Override
    default public boolean isInstanceMember() {
        return false;
    }

    @Override
    default public boolean equalsStructure(PersistenceTypeDescriptionMember other) {
        return other instanceof PersistenceTypeDescriptionMemberEnumConstant && PersistenceTypeDescriptionMemberEnumConstant.equalName(this, (PersistenceTypeDescriptionMemberEnumConstant)other);
    }

    @Override
    default public boolean equalsDescription(PersistenceTypeDescriptionMember member) {
        return this.equalsStructure(member);
    }

    public static boolean equalName(PersistenceTypeDescriptionMemberEnumConstant m1, PersistenceTypeDescriptionMemberEnumConstant m2) {
        return m1 == m2 || m2 != null && Objects.equals(m1.name(), m2.name());
    }

    @Override
    default public PersistenceTypeDefinitionMemberEnumConstant createDefinitionMember(PersistenceTypeDefinitionMemberCreator creator) {
        return creator.createDefinitionMember(this);
    }

    public static PersistenceTypeDescriptionMemberEnumConstant New(String enumPersistentName) {
        return new Default((String)X.notNull((Object)enumPersistentName));
    }

    public static class Default
    implements PersistenceTypeDescriptionMemberEnumConstant {
        private final String enumName;

        protected Default(String enumName) {
            this.enumName = (String)X.notNull((Object)enumName);
        }

        @Override
        public String name() {
            return this.enumName;
        }

        @Override
        public void assembleTypeDescription(PersistenceTypeDescriptionMemberAppender assembler) {
            assembler.appendTypeMemberDescription(this);
        }

        @Override
        public long persistentMinimumLength() {
            return 0L;
        }

        @Override
        public long persistentMaximumLength() {
            return 0L;
        }

        @Override
        public boolean isValidPersistentLength(long persistentLength) {
            return persistentLength == this.persistentMinimumLength();
        }

        @Override
        public final boolean isInstanceMember() {
            return false;
        }

        @Override
        public String typeName() {
            return PersistenceTypeDictionary.Symbols.KEYWORD_ENUM;
        }

        @Override
        public String qualifier() {
            return null;
        }

        @Override
        public String identifier() {
            return this.name();
        }

        @Override
        public final boolean isReference() {
            return false;
        }

        @Override
        public final boolean isPrimitive() {
            return false;
        }

        @Override
        public final boolean isPrimitiveDefinition() {
            return false;
        }

        @Override
        public final boolean isEnumConstant() {
            return true;
        }

        @Override
        public final boolean hasReferences() {
            return false;
        }

        @Override
        public void validatePersistentLength(long persistentLength) {
            if (this.isValidPersistentLength(persistentLength)) {
                return;
            }
            throw new PersistenceException("Invalid persistent length: " + persistentLength + " != " + this.persistentMinimumLength() + ".");
        }

        public String toString() {
            return "enum " + this.name();
        }
    }
}

