/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryCompiler;
import one.microstream.persistence.types.PersistenceTypeDictionaryLoader;

public interface PersistenceTypeDictionaryProvider {
    public PersistenceTypeDictionary provideTypeDictionary();

    public static Default New(PersistenceTypeDictionaryLoader loader, PersistenceTypeDictionaryCompiler compiler) {
        return new Default((PersistenceTypeDictionaryLoader)X.notNull((Object)loader), (PersistenceTypeDictionaryCompiler)X.notNull((Object)compiler));
    }

    public static Caching Caching(PersistenceTypeDictionaryProvider typeDictionaryImporter) {
        return new Caching((PersistenceTypeDictionaryProvider)X.notNull((Object)typeDictionaryImporter));
    }

    public static final class Caching
    implements PersistenceTypeDictionaryProvider {
        private final PersistenceTypeDictionaryProvider delegate;
        private transient PersistenceTypeDictionary cachedDictionary;

        Caching(PersistenceTypeDictionaryProvider delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final PersistenceTypeDictionary provideTypeDictionary() {
            PersistenceTypeDictionaryProvider persistenceTypeDictionaryProvider = this.delegate;
            synchronized (persistenceTypeDictionaryProvider) {
                if (this.cachedDictionary == null) {
                    this.cachedDictionary = this.delegate.provideTypeDictionary();
                }
                return this.cachedDictionary;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            PersistenceTypeDictionaryProvider persistenceTypeDictionaryProvider = this.delegate;
            synchronized (persistenceTypeDictionaryProvider) {
                this.cachedDictionary = null;
            }
        }
    }

    public static final class Default
    implements PersistenceTypeDictionaryProvider {
        private final PersistenceTypeDictionaryLoader loader;
        private final PersistenceTypeDictionaryCompiler compiler;

        Default(PersistenceTypeDictionaryLoader loader, PersistenceTypeDictionaryCompiler compiler) {
            this.loader = loader;
            this.compiler = compiler;
        }

        @Override
        public PersistenceTypeDictionary provideTypeDictionary() {
            String typeDictionaryString = this.loader.loadTypeDictionary();
            PersistenceTypeDictionary typeDictionary = this.compiler.compileTypeDictionary(typeDictionaryString);
            return typeDictionary;
        }
    }
}

