/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import one.microstream.X;
import one.microstream.persistence.types.PersistenceObjectIdProvider;
import one.microstream.persistence.types.PersistenceTypeIdProvider;

public final class CompositeIdProvider
implements PersistenceObjectIdProvider,
PersistenceTypeIdProvider {
    private final PersistenceTypeIdProvider typeIdProvider;
    private final PersistenceObjectIdProvider objectIdProvider;
    private transient boolean initialized;

    public static CompositeIdProvider New(PersistenceTypeIdProvider typeIdProvider, PersistenceObjectIdProvider objectIdProvider) {
        return new CompositeIdProvider((PersistenceTypeIdProvider)X.notNull((Object)typeIdProvider), (PersistenceObjectIdProvider)X.notNull((Object)objectIdProvider));
    }

    CompositeIdProvider(PersistenceTypeIdProvider typeIdProvider, PersistenceObjectIdProvider objectIdProvider) {
        this.typeIdProvider = typeIdProvider;
        this.objectIdProvider = objectIdProvider;
    }

    private void markInitialized() {
        this.initialized = true;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public final synchronized CompositeIdProvider initialize() {
        if (!this.isInitialized()) {
            this.typeIdProvider.initializeTypeId();
            this.objectIdProvider.initializeObjectId();
            this.markInitialized();
        }
        return this;
    }

    @Override
    public final CompositeIdProvider initializeTypeId() {
        return this.initialize();
    }

    @Override
    public final CompositeIdProvider initializeObjectId() {
        return this.initialize();
    }

    @Override
    public final long currentObjectId() {
        return this.objectIdProvider.currentObjectId();
    }

    @Override
    public final long currentTypeId() {
        return this.typeIdProvider.currentTypeId();
    }

    @Override
    public final long provideNextTypeId() {
        return this.typeIdProvider.provideNextTypeId();
    }

    @Override
    public final long provideNextObjectId() {
        return this.objectIdProvider.provideNextObjectId();
    }

    @Override
    public final CompositeIdProvider updateCurrentObjectId(long currentObjectId) {
        this.objectIdProvider.updateCurrentObjectId(currentObjectId);
        return this;
    }

    @Override
    public final CompositeIdProvider updateCurrentTypeId(long currentTypeId) {
        this.typeIdProvider.updateCurrentTypeId(currentTypeId);
        return this;
    }
}

