/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import java.lang.ref.WeakReference;
import one.microstream.X;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.XSort;
import one.microstream.collections.types.XGettingTable;
import one.microstream.hashing.HashStatisticsBucketBased;
import one.microstream.hashing.XHashing;
import one.microstream.math.XMath;
import one.microstream.meta.XDebug;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistency;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistencyObject;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistencyObjectId;
import one.microstream.persistence.exceptions.PersistenceExceptionImproperObjectId;
import one.microstream.persistence.exceptions.PersistenceExceptionInvalidObjectRegistryCapacity;
import one.microstream.persistence.types.PersistenceAcceptor;
import one.microstream.persistence.types.PersistenceObjectRegistry;
import one.microstream.reference.Swizzling;
import one.microstream.typing.KeyValue;

public final class DefaultObjectRegistry
implements PersistenceObjectRegistry {
    private Entry[] oidHashTable;
    private Entry[] refHashTable;
    private int hashRange;
    private float hashDensity;
    private long capacity;
    private long minCapacity;
    private long size;
    private EqHashTable<Long, Object> constantsHotRegistry = EqHashTable.New();
    private Object[] constantsColdStorageObjects;
    private long[] constantsColdStorageObjectIds;

    public static final float defaultHashDensity() {
        return 1.0f;
    }

    public static final boolean isValidHashDensity(float desiredHashDensity) {
        return XHashing.isValidHashDensity((float)desiredHashDensity);
    }

    public static final float validateHashDensity(float desiredHashDensity) {
        return XHashing.validateHashDensity((float)desiredHashDensity);
    }

    public static final boolean isValidCapacity(long desiredCapacity) {
        return desiredCapacity > 0L;
    }

    public static final long validateCapacity(long desiredCapacity) {
        if (!DefaultObjectRegistry.isValidCapacity(desiredCapacity)) {
            throw new PersistenceExceptionInvalidObjectRegistryCapacity(desiredCapacity);
        }
        return desiredCapacity;
    }

    static final int hash(Object object) {
        return System.identityHashCode(object);
    }

    public static DefaultObjectRegistry New() {
        return DefaultObjectRegistry.New(DefaultObjectRegistry.defaultHashDensity());
    }

    public static DefaultObjectRegistry New(long minimumCapacity) {
        return DefaultObjectRegistry.New(DefaultObjectRegistry.defaultHashDensity(), minimumCapacity);
    }

    public static DefaultObjectRegistry New(float hashDensity) {
        return DefaultObjectRegistry.New(hashDensity, 1L);
    }

    public static DefaultObjectRegistry New(float hashDensity, long minimumCapacity) {
        return new DefaultObjectRegistry().internalSetConfiguration(DefaultObjectRegistry.validateHashDensity(hashDensity), DefaultObjectRegistry.validateCapacity(minimumCapacity)).internalReset();
    }

    DefaultObjectRegistry() {
    }

    private int internalHashLength() {
        return this.hashRange + 1;
    }

    private void internalSetHashDensity(float validHashDensity) {
        this.hashDensity = validHashDensity;
    }

    private void internalSetMinimumCapacity(long validMinimumCapacity) {
        this.minCapacity = validMinimumCapacity;
    }

    final DefaultObjectRegistry internalSetConfiguration(float hashDensity, long minimumCapacity) {
        this.internalSetHashDensity(hashDensity);
        this.internalSetMinimumCapacity(minimumCapacity);
        return this;
    }

    final DefaultObjectRegistry internalReset() {
        return this.internalReset(this.minCapacity);
    }

    final DefaultObjectRegistry internalReset(long minimumCapacity) {
        this.size = 0L;
        int hashLength = this.calculateRequiredHashLength(minimumCapacity);
        this.setHashTables(this.createHashTable(hashLength), this.createHashTable(hashLength));
        return this;
    }

    private int calculateRequiredHashLength(long minimumCapacity) {
        return XHashing.padHashLength((long)((long)((float)minimumCapacity / this.hashDensity)));
    }

    private void setHashTables(Entry[] oidHashTable, Entry[] refHashTable) {
        this.oidHashTable = oidHashTable;
        this.refHashTable = refHashTable;
        this.hashRange = oidHashTable.length - 1;
        this.internalUpdateCapacity();
    }

    private Entry[] createHashTable(int hashLength) {
        return new Entry[hashLength];
    }

    private void internalUpdateCapacity() {
        this.capacity = this.internalHashLength() >= XMath.highestPowerOf2_int() ? Long.MAX_VALUE : (long)((float)this.internalHashLength() * this.hashDensity);
    }

    @Override
    public final synchronized DefaultObjectRegistry Clone() {
        return DefaultObjectRegistry.New(this.hashDensity, this.minCapacity);
    }

    @Override
    public final synchronized int hashRange() {
        return this.oidHashTable.length;
    }

    @Override
    public final synchronized float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final synchronized long minimumCapacity() {
        return this.minCapacity;
    }

    @Override
    public final synchronized long capacity() {
        return this.capacity;
    }

    @Override
    public final synchronized long size() {
        return this.size;
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public final synchronized boolean setHashDensity(float hashDensity) {
        this.internalSetHashDensity(DefaultObjectRegistry.validateHashDensity(hashDensity));
        this.internalUpdateCapacity();
        return this.ensureCapacity(this.minCapacity);
    }

    @Override
    public final synchronized boolean setConfiguration(float hashDensity, long minimumCapacity) {
        DefaultObjectRegistry.validateHashDensity(hashDensity);
        DefaultObjectRegistry.validateCapacity(minimumCapacity);
        this.internalSetHashDensity(hashDensity);
        this.internalSetMinimumCapacity(minimumCapacity);
        this.internalUpdateCapacity();
        return this.ensureCapacity(minimumCapacity);
    }

    @Override
    public final synchronized boolean setMinimumCapacity(long minimumCapacity) {
        this.internalSetMinimumCapacity(DefaultObjectRegistry.validateCapacity(minimumCapacity));
        this.internalUpdateCapacity();
        return this.ensureCapacity(minimumCapacity);
    }

    @Override
    public final synchronized boolean ensureCapacity(long desiredCapacity) {
        DefaultObjectRegistry.validateCapacity(desiredCapacity);
        int requiredHashLength = this.calculateRequiredHashLength(desiredCapacity);
        if (requiredHashLength > this.internalHashLength()) {
            this.internalRebuild(requiredHashLength);
            return true;
        }
        return false;
    }

    @Override
    public final synchronized boolean containsObjectId(long objectId) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                return true;
            }
            e = e.oidNext;
        }
        return false;
    }

    @Override
    public final synchronized long lookupObjectId(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.internalLookupObjectId(object);
    }

    private long internalLookupObjectId(Object object) {
        Entry e = this.refHashTable[DefaultObjectRegistry.hash(object) & this.hashRange];
        while (e != null) {
            if (e.get() == object) {
                return e.objectId;
            }
            e = e.refNext;
        }
        return Swizzling.notFoundId();
    }

    @Override
    public final synchronized Object lookupObject(long objectId) {
        return this.internalLookupObject(objectId);
    }

    private Object internalLookupObject(long objectId) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                return e.get();
            }
            e = e.oidNext;
        }
        return null;
    }

    @Override
    public final boolean isValid(long objectId, Object object) {
        return this.synchInternalValidate(objectId, object, false);
    }

    @Override
    public final synchronized void validate(long objectId, Object object) {
        this.synchInternalValidate(objectId, object, true);
    }

    private boolean synchInternalValidate(long objectId, Object object, boolean throwException) {
        if (object == null) {
            throw new NullPointerException();
        }
        long registeredObjectId = this.internalLookupObjectId(object);
        if (registeredObjectId == objectId) {
            return true;
        }
        if (Swizzling.isNotFoundId((long)registeredObjectId)) {
            Object registeredObject = this.internalLookupObject(objectId);
            if (registeredObject == null) {
                return true;
            }
            if (!throwException) {
                return false;
            }
            if (registeredObject == object) {
                throw new PersistenceExceptionConsistency("Inconsistent object registry for objectId " + objectId);
            }
            throw new PersistenceExceptionConsistencyObject(objectId, registeredObject, object);
        }
        if (!throwException) {
            return false;
        }
        throw new PersistenceExceptionConsistencyObjectId(object, registeredObjectId, objectId);
    }

    @Override
    public final synchronized boolean registerObject(long objectId, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (Swizzling.isNotProperId((long)objectId)) {
            throw new PersistenceExceptionImproperObjectId();
        }
        return this.internalAdd(objectId, object);
    }

    @Override
    public final synchronized Object optionalRegisterObject(long objectId, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (Swizzling.isNotProperId((long)objectId)) {
            throw new PersistenceExceptionImproperObjectId();
        }
        return this.internalAddGet(objectId, object);
    }

    @Override
    public final synchronized boolean registerConstant(long objectId, Object constant) {
        if (!this.registerObject(objectId, constant)) {
            return false;
        }
        this.ensureConstantsHotRegistry().add((Object)objectId, constant);
        return true;
    }

    @Override
    public final synchronized <A extends PersistenceAcceptor> A iterateEntries(A acceptor) {
        DefaultObjectRegistry.iterateEntries(this.oidHashTable, acceptor);
        return acceptor;
    }

    private boolean internalAdd(long objectId, Object object) {
        if (this.internalAddCheck(objectId, object)) {
            return false;
        }
        this.internalPutNewEntry(objectId, object);
        return true;
    }

    private void internalPutNewEntry(long objectId, Object object) {
        Entry entry = new Entry(objectId, object, this.oidHashTable[(int)objectId & this.hashRange], this.refHashTable[DefaultObjectRegistry.hash(object) & this.hashRange]);
        this.refHashTable[DefaultObjectRegistry.hash((Object)object) & this.hashRange] = entry;
        this.oidHashTable[(int)objectId & this.hashRange] = entry;
        if (++this.size > this.capacity) {
            this.internalIncreaseStorage();
        }
    }

    private boolean internalAddCheck(long objectId, Object object) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                return this.internalHandleExisting(object, e);
            }
            e = e.oidNext;
        }
        this.internalValidateObjectNotYetRegistered(objectId, object);
        return false;
    }

    private Object internalAddGetCheck(long objectId, Object object) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                Object registered = e.get();
                if (registered != null) {
                    return registered;
                }
                this.internalRemoveEntry(e);
                break;
            }
            e = e.oidNext;
        }
        this.internalValidateObjectNotYetRegistered(objectId, object);
        return null;
    }

    private boolean internalHandleExisting(Object object, Entry entry) {
        if (entry.get() == object) {
            return true;
        }
        if (entry.get() != null) {
            throw new PersistenceExceptionConsistencyObject(entry.objectId, entry.get(), object);
        }
        this.internalValidateObjectNotYetRegistered(entry.objectId, object);
        this.internalRemoveEntry(entry);
        return false;
    }

    private void internalRemoveEntry(Entry entry) {
        DefaultObjectRegistry.removeFromOidTable(this.oidHashTable, (int)entry.objectId & this.hashRange, entry);
        DefaultObjectRegistry.removeFromRefTable(this.refHashTable, entry.refHash & this.hashRange, entry);
        --this.size;
    }

    private static void removeFromOidTable(Entry[] table, int index, Entry entry) {
        Entry e = table[index];
        Entry last = null;
        while (e != null) {
            if (e == entry) {
                if (last == null) {
                    table[index] = e.oidNext;
                } else {
                    last.oidNext = e.oidNext;
                }
            }
            last = e;
            e = last.oidNext;
        }
    }

    private static void removeFromRefTable(Entry[] table, int index, Entry entry) {
        Entry e = table[index];
        Entry last = null;
        while (e != null) {
            if (e == entry) {
                if (last == null) {
                    table[index] = e.refNext;
                } else {
                    last.refNext = e.refNext;
                }
            }
            last = e;
            e = last.refNext;
        }
    }

    private void internalValidateObjectNotYetRegistered(long objectId, Object object) {
        int refHash = DefaultObjectRegistry.hash(object);
        Entry e = this.refHashTable[refHash & this.hashRange];
        while (e != null) {
            if (e.get() == object) {
                throw new PersistenceExceptionConsistencyObjectId(object, e.objectId, objectId);
            }
            e = e.refNext;
        }
    }

    private Object internalAddGet(long objectId, Object object) {
        Object alreadyRegistered = this.internalAddGetCheck(objectId, object);
        if (alreadyRegistered != null) {
            return alreadyRegistered;
        }
        this.internalPutNewEntry(objectId, object);
        return object;
    }

    @Override
    public final synchronized boolean consolidate() {
        Entry[] oidHashTable = this.oidHashTable;
        Entry[] refHashTable = this.refHashTable;
        int orphanCount = 0;
        int h = 0;
        while (h < oidHashTable.length) {
            orphanCount += DefaultObjectRegistry.consolidateOidHashChain(oidHashTable, h);
            DefaultObjectRegistry.consolidateRefHashChain(refHashTable, h);
            ++h;
        }
        this.size -= (long)orphanCount;
        return this.checkForDecrease();
    }

    private static int consolidateOidHashChain(Entry[] oidHashTable, int h) {
        int orphanCount = 0;
        Entry e = oidHashTable[h];
        Entry lastProper = null;
        while (e != null) {
            if (e.get() != null) {
                lastProper = e;
            } else {
                if (lastProper == null) {
                    oidHashTable[h] = e.oidNext;
                } else {
                    lastProper.oidNext = e.oidNext;
                }
                ++orphanCount;
            }
            e = e.oidNext;
        }
        return orphanCount;
    }

    private static void consolidateRefHashChain(Entry[] refHashTable, int h) {
        Entry e = refHashTable[h];
        Entry lastProper = null;
        while (e != null) {
            if (e.get() != null) {
                lastProper = e;
            } else if (lastProper == null) {
                refHashTable[h] = e.refNext;
            } else {
                lastProper.refNext = e.refNext;
            }
            e = e.refNext;
        }
    }

    private boolean checkForDecrease() {
        int requiredHashLength = this.calculateRequiredHashLength(this.size);
        if (requiredHashLength != this.internalHashLength()) {
            this.internalRebuild(requiredHashLength);
            return true;
        }
        return false;
    }

    private void internalIncreaseStorage() {
        this.internalRebuild(this.oidHashTable.length << 1);
    }

    private void internalRebuild(int hashLength) {
        Entry[] newOidHashTable = this.createHashTable(hashLength);
        Entry[] newRefHashTable = this.createHashTable(hashLength);
        this.size -= DefaultObjectRegistry.rebuildTables(this.oidHashTable, newOidHashTable, newRefHashTable);
        this.setHashTables(newOidHashTable, newRefHashTable);
        this.checkForDecrease();
        this.internalEnsureConstantsColdStorage();
    }

    private static long rebuildTables(Entry[] oldOidHashTable, Entry[] newOidHashTable, Entry[] newRefHashTable) {
        int hashRange = newOidHashTable.length - 1;
        long orphanCount = 0L;
        int i = 0;
        while (i < oldOidHashTable.length) {
            if (oldOidHashTable[i] != null) {
                orphanCount += (long)DefaultObjectRegistry.rebuildEntryChain(oldOidHashTable[i], hashRange, newOidHashTable, newRefHashTable);
            }
            ++i;
        }
        return orphanCount;
    }

    private static int rebuildEntryChain(Entry firstOidHashEntry, int hashRange, Entry[] newOidHashTable, Entry[] newRefHashTable) {
        Entry next;
        int orphanCount = 0;
        Entry e = firstOidHashEntry;
        do {
            next = e.oidNext;
            if (e.get() != null) {
                e.oidNext = newOidHashTable[(int)e.objectId & hashRange];
                e.refNext = newRefHashTable[e.refHash & hashRange];
                newOidHashTable[(int)e.objectId & hashRange] = e;
                newRefHashTable[e.refHash & hashRange] = e;
                continue;
            }
            ++orphanCount;
        } while ((e = next) != null);
        return orphanCount;
    }

    private static void iterateEntries(Entry[] oidHashTable, PersistenceAcceptor acceptor) {
        int s = 0;
        while (s < oidHashTable.length) {
            Entry e = oidHashTable[s];
            while (e != null) {
                acceptor.accept(e.objectId, e.get());
                e = e.oidNext;
            }
            ++s;
        }
    }

    @Override
    public final synchronized void clear() {
        this.internalEnsureConstantsColdStorage();
        this.internalClear();
        this.internalReregisterConstants();
    }

    @Override
    public final synchronized void clearAll() {
        this.internalClear();
    }

    private void internalClear() {
        Entry[] oidBuckets = this.oidHashTable;
        Entry[] refBuckets = this.refHashTable;
        int i = 0;
        while (i < oidBuckets.length) {
            refBuckets[i] = null;
            oidBuckets[i] = null;
            ++i;
        }
        this.size = 0L;
    }

    @Override
    public final synchronized void truncate() {
        this.internalEnsureConstantsColdStorage();
        this.internalReset(Math.max((long)this.constantsColdStorageObjects.length, this.minCapacity));
        this.internalReregisterConstants();
    }

    @Override
    public final synchronized void truncateAll() {
        this.internalReset();
    }

    private void internalReregisterConstants() {
        Object[] constantsObjects = this.constantsColdStorageObjects;
        long[] constantsObjectIds = this.constantsColdStorageObjectIds;
        int i = 0;
        while (i < constantsObjects.length) {
            this.registerObject(constantsObjectIds[i], constantsObjects[i]);
            ++i;
        }
    }

    private EqHashTable<Long, Object> ensureConstantsHotRegistry() {
        if (this.constantsHotRegistry == null) {
            this.internalBuildConstantsHotRegistry();
        }
        return this.constantsHotRegistry;
    }

    private void internalBuildConstantsHotRegistry() {
        EqHashTable constantsHotRegistry = EqHashTable.New();
        Object[] constantsObjects = this.constantsColdStorageObjects;
        long[] constantsObjectIds = this.constantsColdStorageObjectIds;
        int constantsLength = constantsObjects.length;
        int i = 0;
        while (i < constantsLength) {
            constantsHotRegistry.add((Object)constantsObjectIds[i], constantsObjects[i]);
            ++i;
        }
        this.constantsHotRegistry = constantsHotRegistry;
        this.constantsColdStorageObjects = null;
        this.constantsColdStorageObjectIds = null;
    }

    private void internalEnsureConstantsColdStorage() {
        if (this.constantsColdStorageObjects != null) {
            return;
        }
        this.internalBuildConstantsColdStorage();
    }

    private void internalBuildConstantsColdStorage() {
        EqHashTable<Long, Object> constantsHotRegistry = this.constantsHotRegistry;
        int constantCount = X.checkArrayRange((long)constantsHotRegistry.size());
        Object[] constantsObjects = new Object[constantCount];
        long[] constantsObjectIds = new long[constantCount];
        int i = 0;
        for (KeyValue e : constantsHotRegistry) {
            constantsObjects[i] = e.value();
            constantsObjectIds[i] = (Long)e.key();
            ++i;
        }
        this.constantsHotRegistry = null;
        this.constantsColdStorageObjects = constantsObjects;
        this.constantsColdStorageObjectIds = constantsObjectIds;
    }

    public final synchronized XGettingTable<String, HashStatisticsBucketBased> createHashStatistics() {
        return EqHashTable.New((KeyValue[])new KeyValue[]{X.KeyValue((Object)"PerObjectIds", (Object)this.internalCreateHashStatisticsOids()), X.KeyValue((Object)"PerObjects", (Object)this.internalCreateHashStatisticsRefs())});
    }

    private HashStatisticsBucketBased internalCreateHashStatisticsOids() {
        EqHashTable distributionTable = EqHashTable.New();
        Entry[] oidHashTable = this.oidHashTable;
        int h = 0;
        while (h < oidHashTable.length) {
            Long bucketLength = DefaultObjectRegistry.countOidChainLength(oidHashTable[h]);
            DefaultObjectRegistry.registerDistribution((EqHashTable<Long, Long>)distributionTable, bucketLength);
            ++h;
        }
        DefaultObjectRegistry.complete((EqHashTable<Long, Long>)distributionTable);
        return HashStatisticsBucketBased.New((long)oidHashTable.length, (long)this.size, (float)this.hashDensity, (long)((Long)distributionTable.keys().last()), (XGettingTable)distributionTable);
    }

    private HashStatisticsBucketBased internalCreateHashStatisticsRefs() {
        EqHashTable distributionTable = EqHashTable.New();
        Entry[] refHashTable = this.refHashTable;
        int h = 0;
        while (h < refHashTable.length) {
            Long bucketLength = DefaultObjectRegistry.countRefChainLength(refHashTable[h]);
            DefaultObjectRegistry.registerDistribution((EqHashTable<Long, Long>)distributionTable, bucketLength);
            ++h;
        }
        DefaultObjectRegistry.complete((EqHashTable<Long, Long>)distributionTable);
        return HashStatisticsBucketBased.New((long)refHashTable.length, (long)this.size, (float)this.hashDensity, (long)((Long)distributionTable.keys().last()), (XGettingTable)distributionTable);
    }

    private static Long countOidChainLength(Entry firstEntry) {
        long count = 0L;
        Entry e = firstEntry;
        while (e != null) {
            if (e.get() != null) {
                ++count;
            }
            e = e.oidNext;
        }
        return count;
    }

    private static Long countRefChainLength(Entry firstEntry) {
        long count = 0L;
        Entry e = firstEntry;
        while (e != null) {
            if (e.get() != null) {
                ++count;
            }
            e = e.refNext;
        }
        return count;
    }

    private static void registerDistribution(EqHashTable<Long, Long> distributionTable, Long bucketLength) {
        Long count = (Long)distributionTable.get((Object)bucketLength);
        if (count == null) {
            distributionTable.put((Object)bucketLength, (Object)1L);
        } else {
            distributionTable.put((Object)bucketLength, (Object)(count + 1L));
        }
    }

    private static void complete(EqHashTable<Long, Long> distributionTable) {
        distributionTable.keys().sort(XSort::compare);
        Long highest = (Long)distributionTable.last().key();
        Long zero = 0L;
        long l = 0L;
        while (l < highest) {
            distributionTable.add((Object)l, (Object)zero);
            ++l;
        }
        distributionTable.keys().sort(XSort::compare);
    }

    public static final void printEntryInstanceSizeInfo() {
        XDebug.printInstanceSizeInfo(Entry.class);
    }

    static final class Entry
    extends WeakReference<Object> {
        final long objectId;
        int refHash;
        Entry oidNext;
        Entry refNext;

        Entry(long objectId, Object referent, Entry oidNext, Entry refnext) {
            super(referent);
            this.objectId = objectId;
            this.refHash = DefaultObjectRegistry.hash(referent);
            this.oidNext = oidNext;
            this.refNext = refnext;
        }
    }
}

