/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import java.text.SimpleDateFormat;
import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.concurrency.XThreads;
import one.microstream.persistence.internal.PersistenceTypeDictionaryFileHandler;
import one.microstream.persistence.types.PersistenceTypeDictionaryStorer;

public class PersistenceTypeDictionaryFileHandlerArchiving
extends PersistenceTypeDictionaryFileHandler {
    private final ADirectory directory;
    private final ADirectory tdArchive;
    private final String filePrefix;
    private final String fileSuffix;

    public static PersistenceTypeDictionaryFileHandlerArchiving New(AFile file, PersistenceTypeDictionaryStorer writeListener) {
        return new PersistenceTypeDictionaryFileHandlerArchiving((AFile)X.notNull((Object)file), (PersistenceTypeDictionaryStorer)X.mayNull((Object)writeListener));
    }

    PersistenceTypeDictionaryFileHandlerArchiving(AFile file, PersistenceTypeDictionaryStorer writeListener) {
        super(file, writeListener);
        this.directory = file.parent();
        this.tdArchive = this.directory.ensureDirectory("TypeDictionaryArchive");
        this.filePrefix = file.name();
        this.fileSuffix = file.type();
    }

    private AFile buildArchiveFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("_yyyy-MM-dd_HH-mm-ss_SSS");
        String fileName = String.valueOf(this.filePrefix) + sdf.format(System.currentTimeMillis()) + this.fileSuffix;
        AFile file = this.tdArchive.ensureFile(fileName);
        if (file.exists()) {
            XThreads.sleep((long)1L);
            return this.buildArchiveFile();
        }
        return file;
    }

    private void moveCurrentFileToArchive() {
        this.tdArchive.ensureExists();
        AFile targetFile = this.buildArchiveFile();
        AWritableFile wSourceFile = this.file().useWriting();
        try {
            AWritableFile wTargetFile = targetFile.useWriting();
            try {
                wSourceFile.moveTo(wTargetFile);
            }
            finally {
                wTargetFile.release();
            }
        }
        finally {
            wSourceFile.release();
        }
    }

    @Override
    protected synchronized void writeTypeDictionary(String typeDictionaryString) {
        if (this.file().exists()) {
            this.moveCurrentFileToArchive();
        }
        super.writeTypeDictionary(typeDictionaryString);
    }
}

