/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.HashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingSet;
import one.microstream.equality.Equalator;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeConsistency;
import one.microstream.persistence.types.PersistenceCustomTypeHandlerRegistry;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlerCreator;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResult;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResultor;
import one.microstream.persistence.types.PersistenceMemberMatchingProvider;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDescriptionResolver;
import one.microstream.persistence.types.PersistenceTypeDescriptionResolverProvider;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.typing.KeyValue;
import one.microstream.typing.TypeMappingLookup;
import one.microstream.util.similarity.MatchValidator;
import one.microstream.util.similarity.MultiMatch;
import one.microstream.util.similarity.MultiMatchAssembler;
import one.microstream.util.similarity.MultiMatcher;
import one.microstream.util.similarity.Similarity;
import one.microstream.util.similarity.Similator;

public interface PersistenceLegacyTypeMapper<D> {
    public <T> PersistenceLegacyTypeHandler<D, T> ensureLegacyTypeHandler(PersistenceTypeDefinition var1, PersistenceTypeHandler<D, T> var2);

    public static String similarityToString(Similarity<PersistenceTypeDefinitionMember> match) {
        return match.similarity() == Defaults.defaultExplicitMappingSimilarity() ? Defaults.defaultExplicitMappingString() : MultiMatchAssembler.Defaults.defaultSimilarityFormatter().format(match.similarity());
    }

    public static Similarity<PersistenceTypeDefinitionMember> ExplicitMatch(PersistenceTypeDefinitionMember sourceMember, PersistenceTypeDefinitionMember targetMember) {
        return Similarity.New((Object)((PersistenceTypeDefinitionMember)X.notNull((Object)sourceMember)), (double)Defaults.defaultExplicitMappingSimilarity(), (Object)((PersistenceTypeDefinitionMember)X.notNull((Object)targetMember)));
    }

    public static <D> PersistenceLegacyTypeMapper<D> New(PersistenceTypeDescriptionResolverProvider typeDescriptionResolverProvider, TypeMappingLookup<Float> typeSimilarity, PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry, PersistenceMemberMatchingProvider memberMatchingProvider, PersistenceLegacyTypeMappingResultor<D> resultor, PersistenceLegacyTypeHandlerCreator<D> legacyTypeHandlerCreator) {
        return new Default((PersistenceTypeDescriptionResolverProvider)X.notNull((Object)typeDescriptionResolverProvider), (TypeMappingLookup<Float>)((TypeMappingLookup)X.notNull(typeSimilarity)), (PersistenceCustomTypeHandlerRegistry)X.notNull(customTypeHandlerRegistry), (PersistenceMemberMatchingProvider)X.notNull((Object)memberMatchingProvider), (PersistenceLegacyTypeMappingResultor)X.notNull(resultor), (PersistenceLegacyTypeHandlerCreator)X.notNull(legacyTypeHandlerCreator));
    }

    public static class Default<D>
    implements PersistenceLegacyTypeMapper<D> {
        private final PersistenceTypeDescriptionResolverProvider typeDescriptionResolverProvider;
        private final TypeMappingLookup<Float> typeSimilarity;
        private final PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry;
        private final PersistenceMemberMatchingProvider memberMatchingProvider;
        private final PersistenceLegacyTypeMappingResultor<D> resultor;
        private final PersistenceLegacyTypeHandlerCreator<D> legacyTypeHandlerCreator;

        protected Default(PersistenceTypeDescriptionResolverProvider typeDescriptionResolverProvider, TypeMappingLookup<Float> typeSimilarity, PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry, PersistenceMemberMatchingProvider memberMatchingProvider, PersistenceLegacyTypeMappingResultor<D> resultor, PersistenceLegacyTypeHandlerCreator<D> legacyTypeHandlerCreator) {
            this.typeDescriptionResolverProvider = typeDescriptionResolverProvider;
            this.typeSimilarity = typeSimilarity;
            this.customTypeHandlerRegistry = customTypeHandlerRegistry;
            this.memberMatchingProvider = memberMatchingProvider;
            this.resultor = resultor;
            this.legacyTypeHandlerCreator = legacyTypeHandlerCreator;
        }

        private <T> PersistenceLegacyTypeHandler<D, T> createLegacyTypeHandler(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler) {
            HashTable explicitMappings = HashTable.New();
            HashEnum explicitNewMembers = HashEnum.New();
            this.createExplicitMappings((HashTable<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember>)explicitMappings, (HashEnum<PersistenceTypeDefinitionMember>)explicitNewMembers, legacyTypeDefinition, currentTypeHandler);
            MultiMatch<PersistenceTypeDefinitionMember> match = this.match(legacyTypeDefinition, currentTypeHandler, (HashTable<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember>)explicitMappings, (HashEnum<PersistenceTypeDefinitionMember>)explicitNewMembers);
            PersistenceLegacyTypeMappingResult<D, T> validResult = this.resultor.createMappingResult(legacyTypeDefinition, currentTypeHandler, (XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember>)explicitMappings, (XGettingSet<PersistenceTypeDefinitionMember>)explicitNewMembers, match);
            return this.legacyTypeHandlerCreator.createLegacyTypeHandler(validResult);
        }

        private void createExplicitMappings(HashTable<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, HashEnum<PersistenceTypeDefinitionMember> explicitNewMembers, PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, ?> currentTypeHandler) {
            PersistenceTypeDescriptionResolver resolver = this.typeDescriptionResolverProvider.provideTypeDescriptionResolver();
            for (PersistenceTypeDefinitionMember currentMember : currentTypeHandler.allMembers()) {
                if (!resolver.isNewCurrentTypeMember(currentTypeHandler, currentMember)) continue;
                explicitNewMembers.add((Object)currentMember);
            }
            for (PersistenceTypeDefinitionMember sourceMember : legacyTypeDefinition.allMembers()) {
                KeyValue<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> resolved = resolver.resolveMember(legacyTypeDefinition, sourceMember, currentTypeHandler);
                if (resolved == null) continue;
                if (explicitNewMembers.contains((Object)((PersistenceTypeDefinitionMember)resolved.value()))) {
                    throw new PersistenceException("Duplicate target entry " + ((PersistenceTypeDefinitionMember)resolved.value()).identifier() + " for type " + currentTypeHandler.toTypeIdentifier() + ".");
                }
                if (explicitMappings.add(resolved)) continue;
                throw new PersistenceExceptionTypeConsistency("Duplicate member mapping for legacy/source member \"" + sourceMember.identifier() + "\"" + " in legacy type " + legacyTypeDefinition.toTypeIdentifier());
            }
        }

        private static boolean hasNoElements(BulkList<?> list) {
            return list.applies(e -> e == null);
        }

        private MultiMatch<PersistenceTypeDefinitionMember> match(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, ?> currentTypeHandler, HashTable<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, HashEnum<PersistenceTypeDefinitionMember> explicitNewMembers) {
            BulkList sourceMembers = BulkList.New(legacyTypeDefinition.allMembers());
            BulkList targetMembers = BulkList.New(currentTypeHandler.allMembers());
            sourceMembers.replace(m -> explicitMappings.keys().contains(m), null);
            targetMembers.replace(m -> explicitNewMembers.contains(m) || explicitMappings.values().contains(m), null);
            if (Default.hasNoElements(sourceMembers) || Default.hasNoElements(targetMembers)) {
                return null;
            }
            MultiMatch<PersistenceTypeDefinitionMember> match = this.match((BulkList<PersistenceTypeDefinitionMember>)sourceMembers, (BulkList<PersistenceTypeDefinitionMember>)targetMembers);
            return match;
        }

        private MultiMatch<PersistenceTypeDefinitionMember> match(BulkList<? extends PersistenceTypeDefinitionMember> sourceMembers, BulkList<? extends PersistenceTypeDefinitionMember> targetMembers) {
            PersistenceMemberMatchingProvider provider = this.memberMatchingProvider;
            TypeMappingLookup<Float> typeSimis = this.typeSimilarity;
            Equalator<PersistenceTypeDefinitionMember> equalator = provider.provideMemberMatchingEqualator();
            Similator<PersistenceTypeDefinitionMember> similator = provider.provideMemberMatchingSimilator(typeSimis);
            MatchValidator<PersistenceTypeDefinitionMember> validator = provider.provideMemberMatchValidator();
            MultiMatcher matcher = MultiMatcher.New().setEqualator(equalator).setSimilator(similator).setValidator(validator);
            MultiMatch match = matcher.match(sourceMembers, targetMembers);
            return match;
        }

        private <T> PersistenceLegacyTypeHandler<D, T> lookupCustomHandler(PersistenceTypeDefinition legacyTypeDefinition) {
            PersistenceLegacyTypeHandler<D, T> matchingHandler = this.lookupCustomHandlerByTypeId(legacyTypeDefinition);
            if (matchingHandler == null) {
                matchingHandler = this.lookupCustomHandlerByStructure(legacyTypeDefinition);
            }
            return matchingHandler;
        }

        private <T> PersistenceLegacyTypeHandler<D, T> lookupCustomHandlerByTypeId(PersistenceTypeDefinition legacyTypeDefinition) {
            Class<?> type = legacyTypeDefinition.type();
            long typeId = legacyTypeDefinition.typeId();
            PersistenceLegacyTypeHandler legacyTypeHandlerbyId = (PersistenceLegacyTypeHandler)this.customTypeHandlerRegistry.legacyTypeHandlers().search(h -> h.typeId() == typeId);
            if (legacyTypeHandlerbyId == null) {
                return null;
            }
            if (type != null && type != legacyTypeDefinition.type() || !PersistenceTypeDescription.equalStructure(legacyTypeHandlerbyId, legacyTypeDefinition)) {
                throw new PersistenceExceptionTypeConsistency("Type handler structure mismatch for " + legacyTypeDefinition.toTypeIdentifier());
            }
            return legacyTypeHandlerbyId;
        }

        private <T> PersistenceLegacyTypeHandler<D, T> lookupCustomHandlerByStructure(PersistenceTypeDefinition legacyTypeDefinition) {
            Class<?> type = legacyTypeDefinition.type();
            PersistenceLegacyTypeHandler matchingLegacyTypeHandler = (PersistenceLegacyTypeHandler)this.customTypeHandlerRegistry.legacyTypeHandlers().search(h -> (type == null || h.type() == type) && PersistenceTypeDescription.equalStructure(h, legacyTypeDefinition));
            return matchingLegacyTypeHandler;
        }

        @Override
        public <T> PersistenceLegacyTypeHandler<D, T> ensureLegacyTypeHandler(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler) {
            PersistenceLegacyTypeHandler<D, T> customHandler = this.lookupCustomHandler(legacyTypeDefinition);
            if (customHandler != null) {
                return customHandler.initialize(legacyTypeDefinition.typeId());
            }
            return this.createLegacyTypeHandler(legacyTypeDefinition, currentTypeHandler);
        }
    }

    public static interface Defaults {
        public static double defaultExplicitMappingSimilarity() {
            return 2.0;
        }

        public static int defaultMappingTokenBaseLength() {
            return 6;
        }

        public static String defaultExplicitMappingString() {
            return "mapped";
        }

        public static String defaultNewMemberString() {
            return " NEW    >";
        }

        public static String defaultDiscardedMemberString() {
            return " REMOVED ";
        }
    }
}

