/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.Iterator;
import one.microstream.X;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.XUtilsCollection;
import one.microstream.collections.types.XCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingTable;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.util.similarity.Similarity;

public interface PersistenceLegacyTypeMappingResult<D, T> {
    public PersistenceTypeDefinition legacyTypeDefinition();

    public PersistenceTypeHandler<D, T> currentTypeHandler();

    public XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToCurrentMembers();

    public XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers();

    public XGettingEnum<PersistenceTypeDefinitionMember> discardedLegacyMembers();

    public XGettingEnum<PersistenceTypeDefinitionMember> newCurrentMembers();

    public static boolean isUnchangedInstanceStructure(PersistenceLegacyTypeMappingResult<?, ?> mappingResult) {
        return PersistenceLegacyTypeMappingResult.isUnchangedStructure(mappingResult.legacyTypeDefinition().instanceMembers(), mappingResult.currentTypeHandler().instanceMembers(), mappingResult);
    }

    public static boolean isUnchangedFullStructure(PersistenceLegacyTypeMappingResult<?, ?> mappingResult) {
        return PersistenceLegacyTypeMappingResult.isUnchangedStructure(mappingResult.legacyTypeDefinition().allMembers(), mappingResult.currentTypeHandler().allMembers(), mappingResult);
    }

    public static boolean isUnchangedStaticStructure(PersistenceLegacyTypeMappingResult<?, ?> mappingResult) {
        EqHashEnum legacyEnumMembers = (EqHashEnum)XUtilsCollection.subtract((XCollection)EqHashEnum.New(mappingResult.legacyTypeDefinition().allMembers()), mappingResult.legacyTypeDefinition().instanceMembers());
        EqHashEnum currentEnumMembers = (EqHashEnum)XUtilsCollection.subtract((XCollection)EqHashEnum.New(mappingResult.currentTypeHandler().allMembers()), mappingResult.currentTypeHandler().instanceMembers());
        return PersistenceLegacyTypeMappingResult.isUnchangedStructure((XGettingEnum<? extends PersistenceTypeDefinitionMember>)legacyEnumMembers, (XGettingEnum<? extends PersistenceTypeDefinitionMember>)currentEnumMembers, mappingResult);
    }

    public static boolean isUnchangedStructure(XGettingEnum<? extends PersistenceTypeDefinitionMember> legacyMembers, XGettingEnum<? extends PersistenceTypeDefinitionMember> currentMembers, PersistenceLegacyTypeMappingResult<?, ?> mappingResult) {
        if (legacyMembers.size() != currentMembers.size()) {
            return false;
        }
        Iterator legacy = legacyMembers.iterator();
        Iterator current = currentMembers.iterator();
        XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> mapping = mappingResult.legacyToCurrentMembers();
        while (legacy.hasNext()) {
            PersistenceTypeDefinitionMember legacyMember = (PersistenceTypeDefinitionMember)legacy.next();
            PersistenceTypeDefinitionMember currentMember = (PersistenceTypeDefinitionMember)current.next();
            if (mapping.get((Object)legacyMember) != currentMember) {
                return false;
            }
            if (legacyMember.typeName().equals(currentMember.typeName())) continue;
            return false;
        }
        return true;
    }

    public static <D, T> PersistenceLegacyTypeMappingResult<D, T> New(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler, XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToCurrentMembers, XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers, XGettingEnum<PersistenceTypeDefinitionMember> discardedLegacyMembers, XGettingEnum<PersistenceTypeDefinitionMember> newCurrentMembers) {
        return new Default((PersistenceTypeDefinition)X.notNull((Object)legacyTypeDefinition), (PersistenceTypeHandler)X.notNull(currentTypeHandler), (XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)((XGettingTable)X.notNull(legacyToCurrentMembers)), (XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)((XGettingTable)X.notNull(currentToLegacyMembers)), (XGettingEnum<PersistenceTypeDefinitionMember>)((XGettingEnum)X.notNull(discardedLegacyMembers)), (XGettingEnum<PersistenceTypeDefinitionMember>)((XGettingEnum)X.notNull(newCurrentMembers)));
    }

    public static final class Default<D, T>
    implements PersistenceLegacyTypeMappingResult<D, T> {
        final PersistenceTypeDefinition legacyTypeDefinition;
        final PersistenceTypeHandler<D, T> currentTypeHandler;
        final XGettingEnum<PersistenceTypeDefinitionMember> discardedLegacyMembers;
        final XGettingEnum<PersistenceTypeDefinitionMember> newCurrentMembers;
        final XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToCurrentMembers;
        final XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers;

        Default(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler, XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToCurrentMembers, XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers, XGettingEnum<PersistenceTypeDefinitionMember> discardedLegacyMembers, XGettingEnum<PersistenceTypeDefinitionMember> newCurrentMembers) {
            this.legacyTypeDefinition = legacyTypeDefinition;
            this.currentTypeHandler = currentTypeHandler;
            this.legacyToCurrentMembers = legacyToCurrentMembers;
            this.currentToLegacyMembers = currentToLegacyMembers;
            this.discardedLegacyMembers = discardedLegacyMembers;
            this.newCurrentMembers = newCurrentMembers;
        }

        @Override
        public PersistenceTypeDefinition legacyTypeDefinition() {
            return this.legacyTypeDefinition;
        }

        @Override
        public PersistenceTypeHandler<D, T> currentTypeHandler() {
            return this.currentTypeHandler;
        }

        @Override
        public XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToCurrentMembers() {
            return this.legacyToCurrentMembers;
        }

        @Override
        public XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers() {
            return this.currentToLegacyMembers;
        }

        @Override
        public XGettingEnum<PersistenceTypeDefinitionMember> discardedLegacyMembers() {
            return this.discardedLegacyMembers;
        }

        @Override
        public XGettingEnum<PersistenceTypeDefinitionMember> newCurrentMembers() {
            return this.newCurrentMembers;
        }
    }
}

