/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XImmutableEnum;
import one.microstream.collections.types.XImmutableTable;
import one.microstream.persistence.types.PersistenceRefactoringMapping;
import one.microstream.typing.KeyValue;

public interface PersistenceRefactoringMappingProvider {
    public PersistenceRefactoringMapping provideRefactoringMapping();

    public static PersistenceRefactoringMappingProvider NewEmpty() {
        return new Default((XGettingTable<String, String>)X.emptyTable(), (XGettingEnum<String>)X.empty());
    }

    public static PersistenceRefactoringMappingProvider New(Iterable<? extends KeyValue<String, String>> entries) {
        EqHashTable table = EqHashTable.New();
        EqHashEnum newElements = EqHashEnum.New();
        for (KeyValue<String, String> keyValue : entries) {
            if (keyValue.key() == null) {
                newElements.add((Object)((String)keyValue.value()));
                continue;
            }
            table.add(keyValue);
        }
        return new Default((XGettingTable<String, String>)table, (XGettingEnum<String>)newElements);
    }

    public static PersistenceRefactoringMappingProvider New(XGettingSequence<KeyValue<String, String>> entries) {
        return PersistenceRefactoringMappingProvider.New(entries);
    }

    public static final class Default
    implements PersistenceRefactoringMappingProvider {
        private final XGettingTable<String, String> entries;
        private final XGettingEnum<String> newElements;

        Default(XGettingTable<String, String> entries, XGettingEnum<String> newElements) {
            this.entries = entries;
            this.newElements = newElements;
        }

        @Override
        public PersistenceRefactoringMapping provideRefactoringMapping() {
            return new PersistenceRefactoringMapping.Default((XImmutableTable<String, String>)this.entries.immure(), (XImmutableEnum<String>)this.newElements.immure());
        }
    }
}

