/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Supplier;
import one.microstream.X;
import one.microstream.chars.XChars;

public interface PersistenceRootEntry {
    public String identifier();

    public Object instance();

    public boolean isRemoved();

    public static PersistenceRootEntry New(String identifier, Supplier<?> instanceSupplier) {
        return new Default((String)X.notNull((Object)identifier), (Supplier)X.mayNull(instanceSupplier));
    }

    public static final class Default
    implements PersistenceRootEntry {
        private final String identifier;
        private final Supplier<?> instanceSupplier;

        Default(String identifier, Supplier<?> instanceSupplier) {
            this.identifier = identifier;
            this.instanceSupplier = instanceSupplier;
        }

        @Override
        public final String identifier() {
            return this.identifier;
        }

        @Override
        public boolean isRemoved() {
            return this.instanceSupplier == null;
        }

        @Override
        public final Object instance() {
            return this.instanceSupplier != null ? this.instanceSupplier.get() : null;
        }

        public String toString() {
            return String.valueOf(this.identifier) + ": " + XChars.systemString((Object)this.instance());
        }
    }

    @FunctionalInterface
    public static interface Provider {
        public PersistenceRootEntry provideRootEntry(String var1, Supplier<?> var2);
    }
}

