/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.collections.EqConstHashTable;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingTable;
import one.microstream.persistence.types.PersistenceRootReference;
import one.microstream.persistence.types.PersistenceRootResolver;
import one.microstream.persistence.types.PersistenceRootsView;
import one.microstream.util.cql.CQL;

public interface PersistenceRoots
extends PersistenceRootsView {
    @Override
    public PersistenceRootReference rootReference();

    public XGettingTable<String, Object> entries();

    public boolean hasChanged();

    public void reinitializeEntries(XGettingTable<String, Object> var1);

    public void updateEntries(XGettingTable<String, Object> var1);

    @Override
    default public <C extends BiConsumer<String, Object>> C iterateEntries(C iterator) {
        this.entries().iterate(e -> iterator.accept((String)e.key(), e.value()));
        return iterator;
    }

    public static PersistenceRoots New(PersistenceRootResolver rootResolver) {
        return Default.New(rootResolver, null);
    }

    public static final class Default
    implements PersistenceRoots {
        private final transient PersistenceRootResolver rootResolver;
        private transient EqHashTable<String, Long> rootIdMapping;
        private transient EqConstHashTable<String, Object> resolvedEntries;
        private transient boolean hasChanged;

        public static Default New(PersistenceRootResolver rootResolver, EqHashTable<String, Long> rootIdMapping) {
            return new Default((PersistenceRootResolver)X.notNull((Object)rootResolver), (EqHashTable<String, Long>)((EqHashTable)X.mayNull(rootIdMapping)), null, false);
        }

        Default(PersistenceRootResolver rootResolver, EqHashTable<String, Long> rootIdMapping, EqConstHashTable<String, Object> resolvedEntries, boolean hasChanged) {
            this.rootResolver = rootResolver;
            this.rootIdMapping = rootIdMapping;
            this.resolvedEntries = resolvedEntries;
            this.hasChanged = hasChanged;
        }

        @Override
        public final synchronized boolean hasChanged() {
            return this.hasChanged;
        }

        @Override
        public final synchronized PersistenceRootReference rootReference() {
            return this.rootResolver.root();
        }

        @Override
        public final synchronized XGettingTable<String, Object> entries() {
            if (this.resolvedEntries == null) {
                XGettingTable<String, Object> effectiveRoots = this.rootResolver.resolveDefinedRootInstances();
                this.resolvedEntries = EqConstHashTable.New(effectiveRoots);
                this.hasChanged = false;
            }
            return this.resolvedEntries;
        }

        @Override
        public final synchronized void reinitializeEntries(XGettingTable<String, Object> newEntries) {
            this.resolvedEntries = EqConstHashTable.New(newEntries);
        }

        @Override
        public final synchronized void updateEntries(XGettingTable<String, Object> newEntries) {
            this.reinitializeEntries(newEntries);
            this.hasChanged = true;
        }

        public final synchronized void loadingUpdateEntries(XGettingTable<String, Object> resolvedRoots) {
            XGettingTable effectiveRoots = (XGettingTable)CQL.from(resolvedRoots).select(kv -> kv.value() != null).executeInto((Consumer)EqHashTable.New());
            this.resolvedEntries = EqConstHashTable.New((XGettingCollection)effectiveRoots);
            this.hasChanged = effectiveRoots.size() != resolvedRoots.size();
        }

        public final PersistenceRootResolver $rootResolver() {
            return this.rootResolver;
        }

        public final EqHashTable<String, Long> $rootIdMapping() {
            return this.rootIdMapping;
        }

        public final void $discardRootIdMapping() {
            this.rootIdMapping = null;
        }
    }
}

