/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.math.XMath;
import one.microstream.persistence.exceptions.PersistenceExceptionParser;
import one.microstream.persistence.exceptions.PersistenceExceptionParserIncompleteInput;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingComplexTypeDefinition;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingEnumName;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingMemberName;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingMemberTerminator;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingMemberType;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingPrimitiveDefinition;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingType;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingTypeBody;
import one.microstream.persistence.exceptions.PersistenceExceptionParserMissingTypeId;
import one.microstream.persistence.types.PersistenceFieldLengthResolver;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberPrimitiveDefinition;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberEnumConstant;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberField;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGenericSimple;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGenericVariableLength;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldReflective;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberPrimitiveDefinition;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryEntry;
import one.microstream.persistence.types.PersistenceTypeNameMapper;
import one.microstream.persistence.types.PersistenceTypeResolver;
import one.microstream.reflect.XReflect;
import one.microstream.util.Substituter;
import one.microstream.util.UtilStackTrace;

public interface PersistenceTypeDictionaryParser {
    public XGettingSequence<? extends PersistenceTypeDictionaryEntry> parseTypeDictionaryEntries(String var1) throws PersistenceExceptionParser;

    public static Default New(PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, PersistenceTypeNameMapper typeNameMapper) {
        return PersistenceTypeDictionaryParser.New(typeResolver, fieldLengthResolver, (Substituter<String>)Substituter.New(), typeNameMapper);
    }

    public static Default New(PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, Substituter<String> stringSubstitutor, PersistenceTypeNameMapper typeNameMapper) {
        return new Default((PersistenceTypeResolver)X.notNull((Object)typeResolver), (PersistenceFieldLengthResolver)X.notNull((Object)fieldLengthResolver), (Substituter<String>)((Substituter)X.notNull(stringSubstitutor)), (PersistenceTypeNameMapper)X.notNull((Object)typeNameMapper));
    }

    public static abstract class AbstractMemberBuilder {
        final PersistenceTypeResolver typeResolver;
        final PersistenceFieldLengthResolver fieldLengthResolver;
        final Substituter<String> stringSubstitutor;
        final PersistenceTypeNameMapper typeNameMapper;
        final BulkList<PersistenceTypeDescriptionMemberFieldGeneric> nestedMembers = new BulkList();
        boolean isVariableLength;
        boolean isComplex;
        String qualifier;
        String originalTypeName;
        String typeName;
        String fieldName;

        public AbstractMemberBuilder(PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, Substituter<String> stringSubstitutor, PersistenceTypeNameMapper typeNameMapper) {
            this.typeResolver = typeResolver;
            this.fieldLengthResolver = fieldLengthResolver;
            this.stringSubstitutor = stringSubstitutor;
            this.typeNameMapper = typeNameMapper;
        }

        final void setQualifier(String qualifier) {
            this.qualifier = (String)this.stringSubstitutor.substitute((Object)qualifier);
        }

        final void setTypeName(String typeName) {
            this.originalTypeName = (String)this.stringSubstitutor.substitute((Object)typeName);
        }

        final void setFieldName(String fieldName) {
            this.fieldName = (String)this.stringSubstitutor.substitute((Object)fieldName);
        }

        final String qualifier() {
            return this.qualifier;
        }

        final synchronized String typeName() {
            if (this.typeName == null) {
                String mappedTypeName = this.typeNameMapper.mapInterfaceName(this.originalTypeName);
                if (mappedTypeName == null) {
                    mappedTypeName = this.typeNameMapper.mapClassName(this.originalTypeName);
                }
                if (mappedTypeName == null) {
                    mappedTypeName = this.originalTypeName;
                }
                this.typeName = (String)this.stringSubstitutor.substitute((Object)mappedTypeName);
            }
            return this.typeName;
        }

        final String fieldName() {
            return this.fieldName;
        }

        AbstractMemberBuilder reset() {
            this.qualifier = null;
            this.isVariableLength = false;
            this.isComplex = false;
            this.originalTypeName = null;
            this.typeName = null;
            this.fieldName = null;
            this.nestedMembers.clear();
            return this;
        }

        final NestedMemberBuilder createNestedMemberBuilder() {
            return new NestedMemberBuilder(this.typeResolver, this.fieldLengthResolver, this.stringSubstitutor, this.typeNameMapper);
        }

        final PersistenceTypeDescriptionMemberFieldGeneric buildGenericFieldMember() {
            PersistenceFieldLengthResolver lengthResolver = this.fieldLengthResolver;
            String typeName = this.typeName();
            String fieldName = this.fieldName();
            if (this.isVariableLength) {
                return this.isComplex ? PersistenceTypeDescriptionMemberFieldGenericComplex.New(this.qualifier, fieldName, this.nestedMembers, lengthResolver.resolveComplexMemberMinimumLength(fieldName, typeName, (XGettingSequence<? extends PersistenceTypeDescriptionMemberFieldGeneric>)this.nestedMembers), lengthResolver.resolveComplexMemberMaximumLength(fieldName, typeName, (XGettingSequence<? extends PersistenceTypeDescriptionMemberFieldGeneric>)this.nestedMembers)) : PersistenceTypeDescriptionMemberFieldGenericVariableLength.New(typeName, this.qualifier, fieldName, lengthResolver.resolveMinimumLengthFromDictionary(null, fieldName, typeName), lengthResolver.resolveMaximumLengthFromDictionary(null, fieldName, typeName));
            }
            return PersistenceTypeDescriptionMemberFieldGenericSimple.New(typeName, this.qualifier, fieldName, !XReflect.isPrimitiveTypeName((String)typeName), lengthResolver.resolveMinimumLengthFromDictionary(null, fieldName, typeName), lengthResolver.resolveMaximumLengthFromDictionary(null, fieldName, typeName));
        }

        abstract long resolveMemberMinimumLength();

        abstract long resolveMemberMaximumLength();
    }

    public static final class Default
    extends PersistenceTypeDictionary.Symbols
    implements PersistenceTypeDictionaryParser {
        final PersistenceTypeResolver typeResolver;
        final PersistenceFieldLengthResolver fieldLengthResolver;
        final Substituter<String> stringSubstitutor;
        final PersistenceTypeNameMapper typeNameMapper;

        private static void checkForIncompleteInput(int i, int iBound) {
            if (i < iBound) {
                return;
            }
            throw (PersistenceExceptionParserIncompleteInput)((Object)UtilStackTrace.cutStacktraceByOne((Throwable)((Object)new PersistenceExceptionParserIncompleteInput(i))));
        }

        private static int skipWhitespaces(char[] input, int i, int iBound) {
            while (i < iBound && input[i] <= ' ') {
                ++i;
            }
            return i;
        }

        private static int skipTerminated(char[] input, int i, int iBound, char terminator) {
            while (i < iBound && input[i] > ' ' && input[i] != terminator) {
                ++i;
            }
            return i;
        }

        private static int skipTerminated(char[] input, int i, int iBound, char t1, char t2, char t3) {
            while (i < iBound && input[i] > ' ' && input[i] != t1 && input[i] != t2 && input[i] != t3) {
                ++i;
            }
            return i;
        }

        private static boolean equalsCharSequence(char[] input, int iStart, int iBound, char[] sample) {
            int sampleLength = sample.length;
            if (iStart + sampleLength > iBound) {
                return false;
            }
            int i = 0;
            while (i < sampleLength) {
                if (input[iStart + i] != sample[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean isNonComplexVariableLengthType(char[] input, int iStart, int iBound) {
            return Default.equalsCharSequence(input, iStart, iBound, ARRAY_TYPE_BYTES) || Default.equalsCharSequence(input, iStart, iBound, ARRAY_TYPE_CHARS);
        }

        private static void parseTypes(char[] input, int iStart, int iBound, PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, Substituter<String> stringSubstitutor, PersistenceTypeNameMapper typeNameMapper, BulkList<PersistenceTypeDictionaryEntry> entries) {
            int i = iStart;
            while (i < iBound) {
                TypeEntry typeEntry = new TypeEntry(typeResolver, fieldLengthResolver, stringSubstitutor, typeNameMapper);
                i = Default.parseType(input, i, iBound, typeEntry);
                entries.add((Object)typeEntry);
                i = Default.skipWhitespaces(input, i, iBound);
            }
        }

        private static int parseType(char[] input, int iStart, int iBound, TypeEntry typeEntry) {
            int i = iStart;
            i = Default.skipWhitespaces(input, i, iBound);
            i = Default.parseTypeId(input, i, iBound, typeEntry);
            i = Default.skipWhitespaces(input, i, iBound);
            i = Default.parseTypeName(input, i, iBound, typeEntry);
            i = Default.skipWhitespaces(input, i, iBound);
            i = Default.parseTypeMembers(input, i, iBound, typeEntry);
            return i;
        }

        private static int parseTypeId(char[] input, int iStart, int iBound, TypeEntry typeEntry) {
            int i = iStart;
            if ((i = Default.skipTerminated(input, i, iBound, '{')) == iStart) {
                throw new PersistenceExceptionParserMissingTypeId(iStart);
            }
            long typeId = Long.parseLong(new String(input, iStart, i - iStart));
            typeEntry.setTid(typeId);
            return i;
        }

        private static int parseTypeName(char[] input, int iStart, int iBound, TypeEntry typeEntry) {
            int i = iStart;
            if ((i = Default.skipTerminated(input, i, iBound, '{')) == iStart) {
                throw new PersistenceExceptionParserMissingType(iStart);
            }
            typeEntry.setTypeName(new String(input, iStart, i - iStart));
            return i;
        }

        private static int parseTypeMembers(char[] input, int iStart, int iBound, TypeEntry typeEntry) {
            TypeMemberBuilder member = typeEntry.createTypeMemberBuilder();
            int i = iStart;
            if (i >= iBound || input[i] != '{') {
                throw new PersistenceExceptionParserMissingTypeBody(i);
            }
            ++i;
            while (i < iBound) {
                if (input[i] == '}') break;
                member.reset();
                i = Default.skipWhitespaces(input, i, iBound);
                i = Default.parseTypeMember(input, i, iBound, member);
                typeEntry.addMember(member.buildTypeMember());
                i = Default.skipWhitespaces(input, i, iBound);
            }
            Default.checkForIncompleteInput(i, iBound);
            return i + 1;
        }

        private static int parseTypeMember(char[] input, int iStart, int iBound, TypeMemberBuilder member) {
            int i = Default.parsePrimitiveDefinition(input, iStart, iBound, member);
            if (i != iStart) {
                return i;
            }
            i = Default.parseEnumDefinition(input, iStart, iBound, member);
            if (i != iStart) {
                return i;
            }
            return Default.parseFieldDefinition(input, iStart, iBound, member);
        }

        private static int parseFieldTypeName(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.skipTerminated(input, iStart, iBound, ',', '}', MEMBER_FIELD_QUALIFIER_SEPERATOR);
            if (i == iStart) {
                return iStart;
            }
            int a = Default.skipWhitespaces(input, i, iBound);
            Default.checkForIncompleteInput(a, iBound);
            if (input[a] == MEMBER_FIELD_QUALIFIER_SEPERATOR) {
                throw new PersistenceExceptionParserMissingMemberType(i);
            }
            member.setTypeName(new String(input, iStart, i - iStart));
            return a;
        }

        private static int parsePrimitiveDefinition(char[] input, int iStart, int iBound, TypeMemberBuilder member) {
            if (!Default.equalsCharSequence(input, iStart, iBound, ARRAY_KEYWORD_PRIMITIVE)) {
                return iStart;
            }
            member.setTypeName("primitive");
            int i = Default.skipWhitespaces(input, iStart + ARRAY_KEYWORD_PRIMITIVE.length, iBound);
            return Default.parsePrimitiveDefinitionDetails(input, i, iBound, member);
        }

        private static int parsePrimitiveDefinitionDetails(char[] input, int iStart, int iBound, TypeMemberBuilder member) {
            int i = iStart;
            while (i < iBound && input[i] != ',' && input[i] != '}') {
                ++i;
            }
            if (i == iStart) {
                throw new PersistenceExceptionParserMissingPrimitiveDefinition(i);
            }
            Default.checkForIncompleteInput(i, iBound);
            member.primitiveDefinition = new String(input, iStart, i - iStart).trim();
            return Default.parseMemberTermination(input, i, iBound);
        }

        private static int parseEnumDefinition(char[] input, int iStart, int iBound, TypeMemberBuilder member) {
            if (!Default.equalsCharSequence(input, iStart, iBound, ARRAY_KEYWORD_ENUM)) {
                return iStart;
            }
            member.setTypeName(KEYWORD_ENUM);
            int i = Default.skipWhitespaces(input, iStart + ARRAY_KEYWORD_ENUM.length, iBound);
            return Default.parseEnumConstantName(input, i, iBound, member);
        }

        private static int parseEnumConstantName(char[] input, int iStart, int iBound, TypeMemberBuilder member) {
            int i = Default.skipTerminated(input, iStart, iBound, ',', '}', MEMBER_FIELD_QUALIFIER_SEPERATOR);
            if (i == iStart) {
                throw new PersistenceExceptionParserMissingEnumName(i);
            }
            int a = Default.skipWhitespaces(input, i, iBound);
            Default.checkForIncompleteInput(a, iBound);
            Default.setFieldName(input, iStart, i, member);
            return Default.parseMemberTermination(input, a, iBound);
        }

        private static int parseMemberName(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.skipTerminated(input, iStart, iBound, ',', '}', ')');
            if (i == iStart) {
                throw new PersistenceExceptionParserMissingMemberName(i);
            }
            Default.setFieldName(input, iStart, i, member);
            return Default.parseMemberTermination(input, i, iBound);
        }

        private static int parseFieldDefinition(char[] input, int iStart, int iBound, TypeMemberBuilder member) {
            int i = Default.parseFieldVariableLength(input, iStart, iBound, member);
            if (i != iStart) {
                return i;
            }
            return Default.parseFieldSimple(input, iStart, iBound, member);
        }

        private static int parseFieldSimple(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.parseFieldTypeName(input, iStart, iBound, member);
            return Default.parseFieldName(input, i, iBound, member);
        }

        private static int parseFieldName(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.skipTerminated(input, iStart, iBound, ',', '}', MEMBER_FIELD_QUALIFIER_SEPERATOR);
            if (i == iStart) {
                throw new PersistenceExceptionParserMissingMemberName(i);
            }
            int a = Default.skipWhitespaces(input, i, iBound);
            Default.checkForIncompleteInput(a, iBound);
            if (input[a] == MEMBER_FIELD_QUALIFIER_SEPERATOR) {
                member.setQualifier(new String(input, iStart, i - iStart));
                a = Default.skipWhitespaces(input, a + 1, iBound);
                return Default.parseMemberName(input, a, iBound, member);
            }
            Default.setFieldName(input, iStart, i, member);
            return Default.parseMemberTermination(input, i, iBound);
        }

        private static void setFieldName(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            member.setFieldName(new String(input, iStart, iBound - iStart));
        }

        private static int parseFieldVariableLength(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.parseMemberComplexType(input, iStart, iBound, member);
            if (i != iStart) {
                return i;
            }
            if (!Default.isNonComplexVariableLengthType(input, iStart, iBound)) {
                return iStart;
            }
            member.isVariableLength = true;
            return Default.parseFieldSimple(input, iStart, iBound, member);
        }

        private static int parseMemberComplexType(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            if (!Default.equalsCharSequence(input, iStart, iBound, ARRAY_TYPE_COMPLEX)) {
                return iStart;
            }
            int i = Default.skipWhitespaces(input, iStart + ARRAY_TYPE_COMPLEX.length, iBound);
            member.setTypeName("[list]");
            member.isVariableLength = true;
            member.isComplex = true;
            i = Default.parseComplexMemberName(input, i, iBound, member);
            NestedMemberBuilder nestedMemberBuilder = member.createNestedMemberBuilder();
            while (i < iBound) {
                if (input[i] == ')') break;
                i = Default.parseNestedMember(input, i, iBound, nestedMemberBuilder);
                member.nestedMembers.add((Object)nestedMemberBuilder.buildGenericFieldMember());
                nestedMemberBuilder.reset();
                i = Default.skipWhitespaces(input, i, iBound);
            }
            Default.checkForIncompleteInput(i, iBound);
            return Default.parseMemberTermination(input, i + 1, iBound);
        }

        private static int parseComplexMemberName(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.skipTerminated(input, iStart, iBound, ',', '}', '(');
            if (i == iStart) {
                throw new PersistenceExceptionParserMissingMemberName(i);
            }
            int a = Default.skipWhitespaces(input, i, iBound);
            if (a == iBound) {
                throw new PersistenceExceptionParserMissingMemberName(i);
            }
            if (input[a] != '(') {
                throw new PersistenceExceptionParserMissingComplexTypeDefinition(i);
            }
            Default.setFieldName(input, iStart, i, member);
            return Default.skipWhitespaces(input, a + 1, iBound);
        }

        private static int parseNestedMember(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.parseFieldVariableLength(input, iStart, iBound, member);
            if (i != iStart) {
                return i;
            }
            return Default.parseNestedSimpleType(input, iStart, iBound, member);
        }

        private static int parseNestedSimpleType(char[] input, int iStart, int iBound, AbstractMemberBuilder member) {
            int i = Default.parseFieldTypeName(input, iStart, iBound, member);
            return Default.parseMemberName(input, i, iBound, member);
        }

        private static int parseMemberTermination(char[] input, int iStart, int iBound) {
            int i = Default.skipWhitespaces(input, iStart, iBound);
            if (i == iBound || input[i] != ',') {
                throw new PersistenceExceptionParserMissingMemberTerminator(i);
            }
            return i + 1;
        }

        Default(PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, Substituter<String> stringSubstitutor, PersistenceTypeNameMapper typeNameMapper) {
            this.typeResolver = typeResolver;
            this.fieldLengthResolver = fieldLengthResolver;
            this.stringSubstitutor = stringSubstitutor;
            this.typeNameMapper = typeNameMapper;
        }

        @Override
        public XGettingSequence<? extends PersistenceTypeDictionaryEntry> parseTypeDictionaryEntries(String inputString) throws PersistenceExceptionParser {
            if (inputString == null) {
                return null;
            }
            BulkList entries = BulkList.New();
            try {
                char[] input = XChars.readChars((String)inputString);
                Default.parseTypes(input, 0, input.length, this.typeResolver, this.fieldLengthResolver, this.stringSubstitutor, this.typeNameMapper, (BulkList<PersistenceTypeDictionaryEntry>)entries);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new PersistenceExceptionParserIncompleteInput(inputString.length(), (Throwable)e);
            }
            catch (PersistenceExceptionParser e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new PersistenceExceptionParser(-1, (Throwable)e);
            }
            return entries;
        }
    }

    public static final class NestedMemberBuilder
    extends AbstractMemberBuilder {
        public NestedMemberBuilder(PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, Substituter<String> stringSubstitutor, PersistenceTypeNameMapper typeNameMapper) {
            super(typeResolver, fieldLengthResolver, stringSubstitutor, typeNameMapper);
        }

        @Override
        final NestedMemberBuilder reset() {
            super.reset();
            return this;
        }

        @Override
        final long resolveMemberMinimumLength() {
            return this.fieldLengthResolver.resolveMinimumLengthFromDictionary(null, this.fieldName(), this.typeName());
        }

        @Override
        final long resolveMemberMaximumLength() {
            return this.fieldLengthResolver.resolveMaximumLengthFromDictionary(null, this.fieldName(), this.typeName());
        }
    }

    public static final class TypeEntry
    extends PersistenceTypeDictionaryEntry.Abstract {
        private long tid;
        private String originalTypeName;
        private String typeName;
        private final BulkList<PersistenceTypeDescriptionMember> allMembers = new BulkList();
        private final BulkList<PersistenceTypeDescriptionMember> instanceMembers = new BulkList();
        final PersistenceTypeResolver typeResolver;
        final PersistenceFieldLengthResolver fieldLengthResolver;
        final Substituter<String> stringSubstitutor;
        final PersistenceTypeNameMapper typeNameMapper;

        TypeEntry(PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, Substituter<String> stringSubstitutor, PersistenceTypeNameMapper typeNameMapper) {
            this.typeResolver = typeResolver;
            this.fieldLengthResolver = fieldLengthResolver;
            this.stringSubstitutor = stringSubstitutor;
            this.typeNameMapper = typeNameMapper;
        }

        @Override
        public synchronized String typeName() {
            if (this.typeName == null) {
                String mappedTypeName = this.instanceMembers.isEmpty() ? this.typeNameMapper.mapInterfaceName(this.originalTypeName) : this.typeNameMapper.mapClassName(this.originalTypeName);
                this.typeName = mappedTypeName == null ? this.originalTypeName : (String)this.stringSubstitutor.substitute((Object)mappedTypeName);
            }
            return this.typeName;
        }

        @Override
        public long typeId() {
            return this.tid;
        }

        @Override
        public final XGettingSequence<? extends PersistenceTypeDescriptionMember> instanceMembers() {
            return this.instanceMembers;
        }

        @Override
        public final XGettingSequence<? extends PersistenceTypeDescriptionMember> allMembers() {
            return this.allMembers;
        }

        final void addMember(PersistenceTypeDescriptionMember member) {
            this.allMembers.add((Object)member);
            if (member.isInstanceMember()) {
                this.instanceMembers.add((Object)member);
            }
        }

        void setTypeName(String typeName) {
            this.originalTypeName = (String)this.stringSubstitutor.substitute((Object)typeName);
        }

        void setTid(long tid) {
            this.tid = tid;
        }

        final TypeMemberBuilder createTypeMemberBuilder() {
            return new TypeMemberBuilder(this.typeResolver, this.fieldLengthResolver, this.stringSubstitutor, this.typeNameMapper);
        }
    }

    public static final class TypeMemberBuilder
    extends AbstractMemberBuilder {
        String primitiveDefinition;

        public TypeMemberBuilder(PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver fieldLengthResolver, Substituter<String> stringSubstitutor, PersistenceTypeNameMapper typeNameMapper) {
            super(typeResolver, fieldLengthResolver, stringSubstitutor, typeNameMapper);
        }

        final long resolveMinimumPrimitiveLength() {
            return this.fieldLengthResolver.resolveMinimumLengthFromPrimitiveType(PersistenceTypeDefinitionMemberPrimitiveDefinition.Default.resolvePrimitiveDefinition(this.primitiveDefinition));
        }

        final long resolveMaximumPrimitiveLength() {
            return this.fieldLengthResolver.resolveMaximumLengthFromPrimitiveType(PersistenceTypeDefinitionMemberPrimitiveDefinition.Default.resolvePrimitiveDefinition(this.primitiveDefinition));
        }

        final PersistenceTypeDescriptionMember buildTypeMember() {
            if (this.primitiveDefinition != null) {
                return this.buildMemberPrimitiveDefinition();
            }
            if (PersistenceTypeDictionary.Symbols.KEYWORD_ENUM.equals(this.typeName())) {
                return this.buildMemberEnumConstant();
            }
            if (!this.isVariableLength) {
                return this.buildMemberField();
            }
            return this.buildGenericFieldMember();
        }

        final PersistenceTypeDescriptionMemberPrimitiveDefinition buildMemberPrimitiveDefinition() {
            long persistentLength = XMath.equal((long)this.resolveMinimumPrimitiveLength(), (long)this.resolveMaximumPrimitiveLength());
            return PersistenceTypeDescriptionMemberPrimitiveDefinition.New(this.primitiveDefinition, persistentLength);
        }

        final PersistenceTypeDescriptionMemberEnumConstant buildMemberEnumConstant() {
            return PersistenceTypeDescriptionMemberEnumConstant.New(this.fieldName());
        }

        final PersistenceTypeDescriptionMemberField buildMemberField() {
            String qualifier = this.qualifier();
            Class<?> resolvableDeclaringType = qualifier == null ? null : this.typeResolver.tryResolveType(qualifier);
            String tName = this.typeName();
            boolean isPrim = XReflect.isPrimitiveTypeName((String)tName);
            String fName = this.fieldName();
            long minLen = this.resolveMemberMinimumLength();
            long maxLen = this.resolveMemberMaximumLength();
            return resolvableDeclaringType != null && !resolvableDeclaringType.isInterface() ? PersistenceTypeDescriptionMemberFieldReflective.New(tName, qualifier, fName, !isPrim, minLen, maxLen) : PersistenceTypeDescriptionMemberFieldGenericSimple.New(tName, qualifier, fName, !isPrim, minLen, maxLen);
        }

        @Override
        final TypeMemberBuilder reset() {
            super.reset();
            this.primitiveDefinition = null;
            return this;
        }

        @Override
        final long resolveMemberMinimumLength() {
            if (this.primitiveDefinition != null) {
                return this.resolveMinimumPrimitiveLength();
            }
            return this.fieldLengthResolver.resolveMinimumLengthFromDictionary(this.qualifier(), this.fieldName(), this.typeName());
        }

        @Override
        final long resolveMemberMaximumLength() {
            if (this.primitiveDefinition != null) {
                return this.resolveMaximumPrimitiveLength();
            }
            return this.fieldLengthResolver.resolveMaximumLengthFromDictionary(this.qualifier(), this.fieldName(), this.typeName());
        }
    }
}

