/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.collections.ConstHashTable;
import one.microstream.collections.types.XGettingMap;
import one.microstream.persistence.types.PersistenceInstantiator;
import one.microstream.persistence.types.PersistenceTypeInstantiator;

public interface PersistenceTypeInstantiatorProvider<D> {
    public <T> PersistenceTypeInstantiator<D, T> provideTypeInstantiator(Class<T> var1);

    public static <D> PersistenceTypeInstantiatorProvider<D> Provider() {
        return new PersistenceInstantiator.Default();
    }

    public static <D> PersistenceTypeInstantiatorProvider<D> New(PersistenceInstantiator<D> instantiator) {
        return new Default((PersistenceInstantiator)X.notNull(instantiator));
    }

    public static <D> PersistenceTypeInstantiatorProvider<D> New(XGettingMap<Class<?>, PersistenceTypeInstantiator<D, ?>> instantiatorMapping, PersistenceInstantiator<D> instantiator) {
        return instantiatorMapping.isEmpty() ? PersistenceTypeInstantiatorProvider.New(instantiator) : new Mapped(ConstHashTable.New(instantiatorMapping), (PersistenceInstantiator)X.notNull(instantiator));
    }

    public static class Default<D>
    implements PersistenceTypeInstantiatorProvider<D> {
        private final PersistenceInstantiator<D> instantiator;

        Default(PersistenceInstantiator<D> instantiator) {
            this.instantiator = instantiator;
        }

        @Override
        public <T> PersistenceTypeInstantiator<D, T> provideTypeInstantiator(Class<T> type) {
            return PersistenceTypeInstantiator.New(type, this.instantiator);
        }
    }

    public static final class Mapped<D>
    extends Default<D> {
        private final ConstHashTable<Class<?>, PersistenceTypeInstantiator<D, ?>> instantiatorMapping;

        Mapped(ConstHashTable<Class<?>, PersistenceTypeInstantiator<D, ?>> instantiatorMapping, PersistenceInstantiator<D> universalInstantiator) {
            super(universalInstantiator);
            this.instantiatorMapping = instantiatorMapping;
        }

        @Override
        public final <T> PersistenceTypeInstantiator<D, T> provideTypeInstantiator(Class<T> type) {
            PersistenceTypeInstantiator mappedInstatiator = (PersistenceTypeInstantiator)this.instantiatorMapping.get(type);
            PersistenceTypeInstantiator casted = mappedInstatiator != null ? mappedInstatiator : super.provideTypeInstantiator(type);
            return casted;
        }
    }
}

