/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingTable;
import one.microstream.typing.KeyValue;

public interface PersistenceTypeNameMapper {
    public String mapClassName(String var1);

    public String mapInterfaceName(String var1);

    public static PersistenceTypeNameMapper New() {
        return PersistenceTypeNameMapper.New(Defaults.defaultClassNameMappings(), Defaults.defaultInterfaceNameMappings());
    }

    public static PersistenceTypeNameMapper New(XGettingTable<String, String> classNameMapping, XGettingTable<String, String> interfaceNameMapping) {
        return new Default((XGettingTable<String, String>)((XGettingTable)X.notNull(classNameMapping)), (XGettingTable<String, String>)((XGettingTable)X.notNull(interfaceNameMapping)));
    }

    public static final class Default
    implements PersistenceTypeNameMapper {
        private final XGettingTable<String, String> classNameMapping;
        private final XGettingTable<String, String> interfaceNameMapping;

        Default(XGettingTable<String, String> classNameMapping, XGettingTable<String, String> interfaceNameMapping) {
            this.classNameMapping = classNameMapping;
            this.interfaceNameMapping = interfaceNameMapping;
        }

        @Override
        public final String mapClassName(String oldClassName) {
            return (String)this.classNameMapping.get((Object)oldClassName);
        }

        @Override
        public final String mapInterfaceName(String oldInterfaceName) {
            return (String)this.interfaceNameMapping.get((Object)oldInterfaceName);
        }
    }

    public static interface Defaults {
        public static XGettingTable<String, String> defaultClassNameMappings() {
            return EqHashTable.New((KeyValue[])new KeyValue[]{Defaults.microstreamMapping("persistence.lazy.Lazy", "reference.Lazy$Default"), Defaults.microstreamMapping("persistence.lazy.Lazy$Default", "reference.Lazy$Default")});
        }

        public static XGettingTable<String, String> defaultInterfaceNameMappings() {
            return EqHashTable.New((KeyValue[])new KeyValue[]{Defaults.microstreamMapping("persistence.lazy.Lazy", "reference.Lazy")});
        }

        public static KeyValue<String, String> microstreamMapping(String s1, String s2) {
            return X.KeyValue((Object)("one.microstream." + s1), (Object)("one.microstream." + s2));
        }
    }
}

