/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.math.XMath;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceObjectManager;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.reference.Swizzling;

public class DebugGraphPrinter
implements PersistenceFunction {
    private static final int MAX_LITERAL_LENGTH_LONG = 19;
    private final PersistenceObjectManager<?> objectManager;
    private final PersistenceTypeHandlerManager<?> typeHandlerManager;
    private final Entry[] objectIdsSlots;
    private final int objectIdsModulo;
    private int level;
    private final VarString vc = VarString.New();

    public DebugGraphPrinter(PersistenceObjectManager<?> objectManager, PersistenceTypeHandlerManager<?> typeManager) {
        this.objectManager = (PersistenceObjectManager)X.notNull(objectManager);
        this.typeHandlerManager = (PersistenceTypeHandlerManager)X.notNull(typeManager);
        this.objectIdsSlots = new Entry[1];
        this.objectIdsModulo = 0;
    }

    public DebugGraphPrinter(PersistenceObjectManager<?> objectManager, PersistenceTypeHandlerManager<?> typeManager, int hashRange) {
        this.objectManager = (PersistenceObjectManager)X.notNull(objectManager);
        this.typeHandlerManager = (PersistenceTypeHandlerManager)X.notNull(typeManager);
        this.objectIdsSlots = new Entry[XMath.pow2BoundCapped((int)hashRange)];
        this.objectIdsModulo = this.objectIdsSlots.length - 1;
    }

    @Override
    public <T> long apply(T instance) {
        this.vc.clear();
        int i = this.level;
        while (i-- > 0) {
            this.vc.add('|').tab();
        }
        this.vc.add(" + ---");
        if (instance == null) {
            System.out.println(this.vc.add(instance));
            return Swizzling.nullId();
        }
        long objectId = this.objectManager.ensureObjectId(instance);
        this.vc.padLeft(Long.toString(objectId), 19, '0').blank().add(XChars.systemString(instance));
        if (!instance.getClass().isArray()) {
            this.vc.tab(2).add(instance);
        }
        System.out.println(this.vc);
        if (this.isRegisteredLocal(instance)) {
            return Swizzling.nullId();
        }
        PersistenceTypeHandler<?, ?> handler = this.typeHandlerManager.ensureTypeHandler(instance.getClass());
        this.registerLocal(instance);
        ++this.level;
        handler.iterateInstanceReferences(instance, this);
        --this.level;
        return Swizzling.nullId();
    }

    private boolean isRegisteredLocal(Object instance) {
        Entry e = this.objectIdsSlots[System.identityHashCode(instance) & this.objectIdsModulo];
        while (e != null) {
            if (e.ref == instance) {
                return true;
            }
            e = e.link;
        }
        return false;
    }

    private void registerLocal(Object instance) {
        int index = System.identityHashCode(instance) & this.objectIdsModulo;
        Entry e = this.objectIdsSlots[index];
        if (e == null) {
            this.objectIdsSlots[index] = new Entry(instance);
            return;
        }
        do {
            if (e.ref != instance) continue;
            return;
        } while ((e = e.link) != null);
        this.objectIdsSlots[index] = new Entry(instance, this.objectIdsSlots[index]);
    }

    public long register(Object instance) {
        return this.apply(instance);
    }

    private static final class Entry {
        final Object ref;
        Entry link;

        Entry(Object instance) {
            this.ref = instance;
            this.link = null;
        }

        Entry(Object instance, Entry link) {
            this.ref = instance;
            this.link = link;
        }
    }
}

