/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistency;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import one.microstream.persistence.types.PersistenceDataTypeHolder;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerEnsurer;
import one.microstream.persistence.types.PersistenceTypeHandlerProvider;
import one.microstream.persistence.types.PersistenceTypeLink;
import one.microstream.persistence.types.PersistenceTypeManager;

public final class PersistenceTypeHandlerProviderCreating<D>
extends PersistenceDataTypeHolder.Default<D>
implements PersistenceTypeHandlerProvider<D> {
    private final PersistenceTypeManager typeManager;
    private final PersistenceTypeHandlerEnsurer<D> typeHandlerEnsurer;

    public static <D> PersistenceTypeHandlerProviderCreating<D> New(Class<D> dataType, PersistenceTypeManager typeManager, PersistenceTypeHandlerEnsurer<D> typeHandlerEnsurer) {
        return new PersistenceTypeHandlerProviderCreating<D>((Class)X.notNull(dataType), (PersistenceTypeManager)X.notNull((Object)typeManager), (PersistenceTypeHandlerEnsurer)X.notNull(typeHandlerEnsurer));
    }

    PersistenceTypeHandlerProviderCreating(Class<D> dataType, PersistenceTypeManager typeManager, PersistenceTypeHandlerEnsurer<D> typeHandlerEnsurer) {
        super(dataType);
        this.typeManager = typeManager;
        this.typeHandlerEnsurer = typeHandlerEnsurer;
    }

    @Override
    public final <T> PersistenceTypeHandler<D, ? super T> provideTypeHandler(Class<T> type) {
        PersistenceTypeHandler<D, T> typeHandler;
        PersistenceTypeHandler<D, T> lookedUpTypeHandler = this.ensureTypeHandler(type);
        if (type == lookedUpTypeHandler.type()) {
            long typeId = this.typeManager.ensureTypeId(type);
            typeHandler = lookedUpTypeHandler.initialize(typeId);
        } else {
            typeHandler = lookedUpTypeHandler;
        }
        return typeHandler;
    }

    @Override
    public final long ensureTypeId(Class<?> type) {
        return this.typeManager.ensureTypeId(type);
    }

    @Override
    public final Class<?> ensureType(long typeId) {
        return this.typeManager.ensureType(typeId);
    }

    @Override
    public final long currentTypeId() {
        return this.typeManager.currentTypeId();
    }

    @Override
    public final boolean registerType(long tid, Class<?> type) throws PersistenceExceptionConsistency {
        return this.typeManager.registerType(tid, type);
    }

    @Override
    public final long lookupTypeId(Class<?> type) {
        return this.typeManager.lookupTypeId(type);
    }

    @Override
    public final <T> Class<T> lookupType(long typeId) {
        return this.typeManager.lookupType(typeId);
    }

    @Override
    public boolean validateTypeMapping(long typeId, Class<?> type) throws PersistenceExceptionConsistency {
        return this.typeManager.validateTypeMapping(typeId, type);
    }

    @Override
    public boolean validateTypeMappings(Iterable<? extends PersistenceTypeLink> mappings) throws PersistenceExceptionConsistency {
        return this.typeManager.validateTypeMappings(mappings);
    }

    @Override
    public boolean registerTypes(Iterable<? extends PersistenceTypeLink> types) throws PersistenceExceptionConsistency {
        return this.typeManager.registerTypes(types);
    }

    @Override
    public final void updateCurrentHighestTypeId(long highestTypeId) {
        this.typeManager.updateCurrentHighestTypeId(highestTypeId);
    }

    @Override
    public final <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
        return this.typeHandlerEnsurer.ensureTypeHandler(type);
    }

    @Override
    public final <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateTypeHandlers(C iterator) {
        return this.typeHandlerEnsurer.iterateTypeHandlers(iterator);
    }

    @Override
    public <C extends Consumer<? super PersistenceLegacyTypeHandler<D, ?>>> C iterateLegacyTypeHandlers(C iterator) {
        return this.typeHandlerEnsurer.iterateLegacyTypeHandlers(iterator);
    }

    @Override
    public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateAllTypeHandlers(C iterator) {
        return this.typeHandlerEnsurer.iterateAllTypeHandlers(iterator);
    }

    @Override
    public void iteratePerIds(BiConsumer<Long, ? super Class<?>> consumer) {
        this.typeManager.iteratePerIds(consumer);
    }
}

