/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingSet;
import one.microstream.collections.types.XGettingTable;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceLegacyTypeMapper;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResult;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResultor;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.util.similarity.MultiMatch;
import one.microstream.util.similarity.Similarity;

public class PrintingLegacyTypeMappingResultor<D>
implements PersistenceLegacyTypeMappingResultor<D> {
    final PersistenceLegacyTypeMappingResultor<D> delegate;

    public static String assembleMappingWithHeader(XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers, PersistenceLegacyTypeMappingResult<?, ?> result) {
        VarString vs = VarString.New();
        PrintingLegacyTypeMappingResultor.assembleMappingHeader(vs, result);
        PrintingLegacyTypeMappingResultor.assembleMapping(vs, explicitMappings, matchedMembers, result);
        return vs.toString();
    }

    public static VarString assembleMappingHeader(VarString vs, PersistenceLegacyTypeMappingResult<?, ?> result) {
        vs.lf().add("----------").lf().add("Legacy type mapping required for legacy type ").lf().add(result.legacyTypeDefinition().toTypeIdentifier()).lf().add("to current type ").lf().add(result.currentTypeHandler().toTypeIdentifier()).lf().add("Fields:").lf();
        return vs;
    }

    public static VarString assembleMapping(VarString vs, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers, PersistenceLegacyTypeMappingResult<?, ?> result) {
        XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers = result.currentToLegacyMembers();
        XGettingEnum<PersistenceTypeDefinitionMember> newCurrentMembers = result.newCurrentMembers();
        for (PersistenceTypeDefinitionMember currentMember : result.currentTypeHandler().membersInDeclaredOrder()) {
            Similarity legacyMember = (Similarity)currentToLegacyMembers.get((Object)currentMember);
            if (legacyMember != null) {
                PrintingLegacyTypeMappingResultor.assembleMemberName(vs, (PersistenceTypeDefinitionMember)legacyMember.sourceElement()).tab();
                PrintingLegacyTypeMappingResultor.assembleTokenMappedMember(vs, (Similarity<PersistenceTypeDefinitionMember>)legacyMember).blank();
                PrintingLegacyTypeMappingResultor.assembleMemberName(vs, currentMember).lf();
                continue;
            }
            if (newCurrentMembers.contains((Object)currentMember)) {
                vs.tab();
                PrintingLegacyTypeMappingResultor.assembleTokenNewMember(vs).blank();
                PrintingLegacyTypeMappingResultor.assembleMemberName(vs, currentMember).lf();
                continue;
            }
            throw new PersistenceException("Inconsistent current type member mapping: " + currentMember.identifier());
        }
        for (PersistenceTypeDefinitionMember e : result.discardedLegacyMembers()) {
            PrintingLegacyTypeMappingResultor.assembleMemberName(vs, e).tab();
            PrintingLegacyTypeMappingResultor.assembleTokenDiscardedMember(vs);
            vs.lf();
        }
        return vs;
    }

    static final VarString assembleTokenMappedMember(VarString vs, Similarity<PersistenceTypeDefinitionMember> mappedLegacyMember) {
        return vs.add('-').padRight(PersistenceLegacyTypeMapper.similarityToString(mappedLegacyMember), PersistenceLegacyTypeMapper.Defaults.defaultMappingTokenBaseLength(), '-').add("->");
    }

    static final VarString assembleTokenNewMember(VarString vs) {
        return vs.add(PersistenceLegacyTypeMapper.Defaults.defaultNewMemberString());
    }

    static final VarString assembleTokenDiscardedMember(VarString vs) {
        return vs.add(PersistenceLegacyTypeMapper.Defaults.defaultDiscardedMemberString());
    }

    public static final VarString assembleMemberName(VarString vs, PersistenceTypeDefinitionMember member) {
        return vs.add(member.typeName()).blank().add(member.identifier());
    }

    public static <D> PrintingLegacyTypeMappingResultor<D> New(PersistenceLegacyTypeMappingResultor<D> delegate) {
        return new PrintingLegacyTypeMappingResultor<D>((PersistenceLegacyTypeMappingResultor)X.notNull(delegate));
    }

    PrintingLegacyTypeMappingResultor(PersistenceLegacyTypeMappingResultor<D> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> PersistenceLegacyTypeMappingResult<D, T> createMappingResult(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, XGettingSet<PersistenceTypeDefinitionMember> explicitNewMembers, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers) {
        PersistenceLegacyTypeMappingResult<D, T> result = this.delegate.createMappingResult(legacyTypeDefinition, currentTypeHandler, explicitMappings, explicitNewMembers, matchedMembers);
        String output = PrintingLegacyTypeMappingResultor.assembleMappingWithHeader(explicitMappings, matchedMembers, result);
        System.out.println(output);
        return result;
    }
}

