/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceObjectIdHolder;
import one.microstream.util.Cloneable;

public interface PersistenceObjectIdProvider
extends PersistenceObjectIdHolder,
Cloneable<PersistenceObjectIdProvider> {
    public long provideNextObjectId();

    public PersistenceObjectIdProvider initializeObjectId();

    @Override
    public long currentObjectId();

    @Override
    public PersistenceObjectIdProvider updateCurrentObjectId(long var1);

    default public PersistenceObjectIdProvider Clone() {
        return (PersistenceObjectIdProvider)super.Clone();
    }

    public static PersistenceObjectIdProvider Transient() {
        return new Transient(Persistence.defaultStartObjectId());
    }

    public static PersistenceObjectIdProvider Transient(long startingObjectId) {
        return new Transient(Persistence.validateObjectId(startingObjectId));
    }

    public static Failing Failing() {
        return new Failing();
    }

    public static final class Failing
    implements PersistenceObjectIdProvider {
        private long currentObjectId;

        Failing() {
        }

        @Override
        public Failing Clone() {
            return new Failing();
        }

        @Override
        public Failing initializeObjectId() {
            return this;
        }

        @Override
        public long currentObjectId() {
            return this.currentObjectId;
        }

        @Override
        public Failing updateCurrentObjectId(long currentObjectId) {
            this.currentObjectId = currentObjectId;
            return this;
        }

        @Override
        public long provideNextObjectId() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Transient
    implements PersistenceObjectIdProvider {
        private long currentObjectId;

        Transient(long startingObjectId) {
            this.currentObjectId = startingObjectId;
        }

        @Override
        public final synchronized Transient Clone() {
            return new Transient(this.currentObjectId);
        }

        @Override
        public final synchronized long provideNextObjectId() {
            return ++this.currentObjectId;
        }

        @Override
        public final synchronized long currentObjectId() {
            return this.currentObjectId;
        }

        @Override
        public final Transient initializeObjectId() {
            return this;
        }

        @Override
        public final synchronized PersistenceObjectIdProvider updateCurrentObjectId(long currentObjectId) {
            this.currentObjectId = currentObjectId;
            return this;
        }
    }
}

