/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.persistence.types.PersistenceObjectManager;
import one.microstream.persistence.types.PersistenceTarget;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.persistence.types.Storer;
import one.microstream.reference.ObjectSwizzling;
import one.microstream.util.BufferSizeProviderIncremental;

public interface PersistenceStorer
extends Storer {
    @Override
    public PersistenceStorer reinitialize();

    @Override
    public PersistenceStorer reinitialize(long var1);

    @Override
    public PersistenceStorer ensureCapacity(long var1);

    @FunctionalInterface
    public static interface CreationObserver {
        public static void noOp(PersistenceStorer storer) {
        }

        public void observeCreatedStorer(PersistenceStorer var1);

        public static CreationObserver Chain(CreationObserver first, CreationObserver second) {
            return new Chaining((CreationObserver)X.notNull((Object)first), (CreationObserver)X.notNull((Object)second));
        }

        public static final class Chaining
        implements CreationObserver {
            private final CreationObserver first;
            private final CreationObserver second;

            Chaining(CreationObserver first, CreationObserver second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public void observeCreatedStorer(PersistenceStorer storer) {
                this.first.observeCreatedStorer(storer);
                this.second.observeCreatedStorer(storer);
            }
        }
    }

    public static interface Creator<D> {
        public PersistenceStorer createLazyStorer(PersistenceTypeHandlerManager<D> var1, PersistenceObjectManager<D> var2, ObjectSwizzling var3, PersistenceTarget<D> var4, BufferSizeProviderIncremental var5);

        default public PersistenceStorer createStorer(PersistenceTypeHandlerManager<D> typeManager, PersistenceObjectManager<D> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<D> target, BufferSizeProviderIncremental bufferSizeProvider) {
            return this.createLazyStorer(typeManager, objectManager, objectRetriever, target, bufferSizeProvider);
        }

        public PersistenceStorer createEagerStorer(PersistenceTypeHandlerManager<D> var1, PersistenceObjectManager<D> var2, ObjectSwizzling var3, PersistenceTarget<D> var4, BufferSizeProviderIncremental var5);
    }
}

