/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.lang.reflect.Field;
import one.microstream.X;
import one.microstream.collections.types.XAddingEnum;
import one.microstream.collections.types.XAddingSequence;
import one.microstream.collections.types.XPrependingEnum;
import one.microstream.collections.types.XPrependingSequence;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFieldEvaluator;
import one.microstream.persistence.types.PersistenceTypeEvaluator;
import one.microstream.reflect.XReflect;

public interface PersistenceTypeAnalyzer {
    public boolean isUnpersistable(Class<?> var1);

    public <C extends XPrependingEnum<Field>> C collectPersistableFieldsEntity(Class<?> var1, C var2, XPrependingEnum<Field> var3, XAddingEnum<Field> var4);

    public <C extends XPrependingEnum<Field>> C collectPersistableFieldsCollection(Class<?> var1, C var2, XPrependingEnum<Field> var3, XAddingEnum<Field> var4);

    public <C extends XPrependingEnum<Field>> C collectPersistableFieldsEnum(Class<?> var1, C var2, XPrependingEnum<Field> var3, XAddingEnum<Field> var4);

    public static PersistenceTypeAnalyzer New(PersistenceTypeEvaluator isPersistable, PersistenceFieldEvaluator fieldSelectorPersistable, PersistenceFieldEvaluator fieldSelectorPersister, PersistenceFieldEvaluator fieldSelectorEnum, PersistenceFieldEvaluator fieldSelectorReflectiveCollection) {
        return new Default((PersistenceTypeEvaluator)X.notNull((Object)isPersistable), (PersistenceFieldEvaluator)X.notNull((Object)fieldSelectorPersistable), (PersistenceFieldEvaluator)X.notNull((Object)fieldSelectorPersister), (PersistenceFieldEvaluator)X.notNull((Object)fieldSelectorEnum), (PersistenceFieldEvaluator)X.notNull((Object)fieldSelectorReflectiveCollection));
    }

    public static final class Default
    implements PersistenceTypeAnalyzer {
        private final PersistenceTypeEvaluator isPersistable;
        private final PersistenceFieldEvaluator fieldSelectorPersistable;
        private final PersistenceFieldEvaluator fieldSelectorPersister;
        private final PersistenceFieldEvaluator fieldSelectorEnum;
        private final PersistenceFieldEvaluator fieldSelectorReflectiveCollection;

        public static final void iterateInstanceFields(Class<?> entityType, PersistenceFieldEvaluator isPersistable, PersistenceFieldEvaluator isPersisterField, XPrependingSequence<Field> persistableFields, XPrependingSequence<Field> persisterFields, PersistenceFieldEvaluator isProblematic, XAddingSequence<Field> problematicFields) {
            XReflect.iterateDeclaredFieldsUpwards(entityType, field -> {
                if (!XReflect.isInstanceField((Field)field)) {
                    return;
                }
                if (!isPersistable.applies(entityType, (Field)field)) {
                    if (isPersisterField != null && Persistence.isPersisterField(field) && isPersisterField.applies(entityType, (Field)field)) {
                        XReflect.setAccessible((Field)field);
                        persisterFields.prepend(field);
                    }
                    return;
                }
                if (isProblematic != null && isProblematic.applies(entityType, (Field)field)) {
                    problematicFields.add(field);
                    return;
                }
                persistableFields.prepend(field);
            });
        }

        Default(PersistenceTypeEvaluator isPersistable, PersistenceFieldEvaluator fieldSelectorPersistable, PersistenceFieldEvaluator fieldSelectorPersister, PersistenceFieldEvaluator fieldSelectorEnum, PersistenceFieldEvaluator fieldSelectorReflectiveCollection) {
            this.isPersistable = isPersistable;
            this.fieldSelectorPersistable = fieldSelectorPersistable;
            this.fieldSelectorPersister = fieldSelectorPersister;
            this.fieldSelectorEnum = fieldSelectorEnum;
            this.fieldSelectorReflectiveCollection = fieldSelectorReflectiveCollection;
        }

        @Override
        public boolean isUnpersistable(Class<?> type) {
            return !this.isPersistable.isPersistableType(type);
        }

        @Override
        public <C extends XPrependingEnum<Field>> C collectPersistableFieldsEntity(Class<?> type, C persistableFields, XPrependingEnum<Field> persisterFields, XAddingEnum<Field> problematicFields) {
            Default.iterateInstanceFields(type, this.fieldSelectorPersistable, this.fieldSelectorPersister, persistableFields, persisterFields, null, problematicFields);
            return persistableFields;
        }

        @Override
        public <C extends XPrependingEnum<Field>> C collectPersistableFieldsEnum(Class<?> type, C persistableFields, XPrependingEnum<Field> persisterFields, XAddingEnum<Field> problematicFields) {
            Default.iterateInstanceFields(type, this.fieldSelectorPersistable, this.fieldSelectorPersister, persistableFields, persisterFields, (t, f) -> !this.fieldSelectorEnum.applies(type, f), problematicFields);
            return persistableFields;
        }

        @Override
        public <C extends XPrependingEnum<Field>> C collectPersistableFieldsCollection(Class<?> type, C persistableFields, XPrependingEnum<Field> persisterFields, XAddingEnum<Field> problematicFields) {
            Default.iterateInstanceFields(type, this.fieldSelectorPersistable, this.fieldSelectorPersister, persistableFields, persisterFields, (t, f) -> !this.fieldSelectorReflectiveCollection.applies(type, f), problematicFields);
            return persistableFields;
        }
    }
}

