/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XImmutableEnum;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeLink;

public interface PersistenceTypeDefinition
extends PersistenceTypeDescription,
PersistenceTypeLink {
    @Override
    public long typeId();

    @Override
    public String typeName();

    @Override
    public Class<?> type();

    default public String runtimeTypeName() {
        return this.type() == null ? null : this.type().getName();
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers();

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> instanceMembers();

    public boolean hasPersistedReferences();

    public long membersPersistedLengthMinimum();

    public long membersPersistedLengthMaximum();

    default public boolean hasPersistedVariableLength() {
        return this.membersPersistedLengthMinimum() != this.membersPersistedLengthMaximum();
    }

    public boolean isPrimitiveType();

    public boolean hasVaryingPersistedLengthInstances();

    default public String toRuntimeTypeIdentifier() {
        return PersistenceTypeDescription.buildTypeIdentifier(this.typeId(), (String)X.coalesce((Object)this.runtimeTypeName(), (Object)"[no runtime type]"));
    }

    public static boolean determineVariableLength(XGettingSequence<? extends PersistenceTypeDescriptionMember> members) {
        for (PersistenceTypeDescriptionMember member : members) {
            if (!member.isVariableLength()) continue;
            return true;
        }
        return false;
    }

    public static boolean determineIsPrimitive(XGettingSequence<? extends PersistenceTypeDescriptionMember> allMembers) {
        return allMembers.size() == 1L && ((PersistenceTypeDescriptionMember)allMembers.get()).isPrimitiveDefinition();
    }

    public static PersistenceTypeDefinition New(long typeId, String typeName, String runtimeTypeName, Class<?> type, XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers, XGettingEnum<? extends PersistenceTypeDefinitionMember> instanceMembers) {
        if (allMembers.equality() != PersistenceTypeDescriptionMember.identityHashEqualator() || instanceMembers.equality() != PersistenceTypeDescriptionMember.identityHashEqualator()) {
            throw new IllegalArgumentException();
        }
        XImmutableEnum immutAllMembers = allMembers.immure();
        XImmutableEnum immutInsMembers = instanceMembers.immure();
        return new Default(typeId, (String)X.notNull((Object)typeName), (String)X.mayNull((Object)runtimeTypeName), (Class)X.mayNull(type), (XImmutableEnum<? extends PersistenceTypeDefinitionMember>)immutAllMembers, (XImmutableEnum<? extends PersistenceTypeDefinitionMember>)immutInsMembers, PersistenceTypeDescriptionMember.determineHasReferences((Iterable<? extends PersistenceTypeDescriptionMember>)immutInsMembers), PersistenceTypeDefinition.determineIsPrimitive((XGettingSequence<? extends PersistenceTypeDescriptionMember>)immutAllMembers), PersistenceTypeDefinition.determineVariableLength((XGettingSequence<? extends PersistenceTypeDescriptionMember>)immutInsMembers));
    }

    public static final class Default
    implements PersistenceTypeDefinition {
        final long typeId;
        final String typeName;
        final String runtimeTypeName;
        final Class<?> runtimeType;
        final XImmutableEnum<? extends PersistenceTypeDefinitionMember> allMembers;
        final XImmutableEnum<? extends PersistenceTypeDefinitionMember> instanceMembers;
        final long membersMinLength;
        final long membersMaxLength;
        final boolean hasReferences;
        final boolean isPrimitive;
        final boolean variableLength;

        Default(long typeId, String typeName, String runtimeTypeName, Class<?> runtimeType, XImmutableEnum<? extends PersistenceTypeDefinitionMember> allMembers, XImmutableEnum<? extends PersistenceTypeDefinitionMember> instanceMembers, boolean hasReferences, boolean isPrimitive, boolean variableLength) {
            this.typeId = typeId;
            this.typeName = typeName;
            this.runtimeTypeName = runtimeTypeName;
            this.runtimeType = runtimeType;
            this.allMembers = allMembers;
            this.instanceMembers = instanceMembers;
            this.hasReferences = hasReferences;
            this.isPrimitive = isPrimitive;
            this.variableLength = variableLength;
            this.membersMinLength = PersistenceTypeDescriptionMember.calculatePersistentMinimumLength(0L, instanceMembers);
            this.membersMaxLength = PersistenceTypeDescriptionMember.calculatePersistentMaximumLength(0L, instanceMembers);
        }

        @Override
        public final long typeId() {
            return this.typeId;
        }

        @Override
        public final String typeName() {
            return this.typeName;
        }

        @Override
        public final String runtimeTypeName() {
            return this.runtimeTypeName;
        }

        @Override
        public final Class<?> type() {
            return this.runtimeType;
        }

        public final XImmutableEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
            return this.allMembers;
        }

        public final XImmutableEnum<? extends PersistenceTypeDefinitionMember> instanceMembers() {
            return this.instanceMembers;
        }

        @Override
        public final boolean hasPersistedReferences() {
            return this.hasReferences;
        }

        @Override
        public final boolean isPrimitiveType() {
            return this.isPrimitive;
        }

        @Override
        public final boolean hasPersistedVariableLength() {
            return this.variableLength;
        }

        @Override
        public final boolean hasVaryingPersistedLengthInstances() {
            return this.variableLength;
        }

        public final String toString() {
            return this.toRuntimeTypeIdentifier();
        }

        @Override
        public final long membersPersistedLengthMinimum() {
            return this.membersMinLength;
        }

        @Override
        public final long membersPersistedLengthMaximum() {
            return this.membersMaxLength;
        }
    }
}

