/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.math.XMath;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberPrimitiveDefinition;

public interface PersistenceTypeDefinitionMemberPrimitiveDefinition
extends PersistenceTypeDescriptionMemberPrimitiveDefinition,
PersistenceTypeDefinitionMember {
    @Override
    default public String identifier() {
        return this.primitiveDefinition();
    }

    public static PersistenceTypeDefinitionMemberPrimitiveDefinition New(PersistenceTypeDescriptionMemberPrimitiveDefinition description) {
        long persistentLength = XMath.equal((long)description.persistentMinimumLength(), (long)description.persistentMaximumLength());
        return new Default(description.primitiveDefinition(), persistentLength);
    }

    public static PersistenceTypeDefinitionMemberPrimitiveDefinition New(Class<?> primitiveType, long persistentLength) {
        return new Default(Default.assemblePrimitiveDefinition(primitiveType), persistentLength);
    }

    public static class Default
    extends PersistenceTypeDescriptionMemberPrimitiveDefinition.Default
    implements PersistenceTypeDefinitionMemberPrimitiveDefinition {
        private static final String _bit = " bit";
        private static final String _integer_signed = " integer signed";
        private static final String _integer_unicode = " integer unicode";
        private static final String _decimal_IEEE754 = " decimal IEEE754";
        private static final String _boolean = " boolean";
        private static final char[] DEFINITION_byte = "8 bit integer signed".toCharArray();
        private static final char[] DEFINITION_boolean = "8 bit boolean".toCharArray();
        private static final char[] DEFINITION_short = "16 bit integer signed".toCharArray();
        private static final char[] DEFINITION_char = "16 bit integer unicode".toCharArray();
        private static final char[] DEFINITION_int = "32 bit integer signed".toCharArray();
        private static final char[] DEFINITION_float = "32 bit decimal IEEE754".toCharArray();
        private static final char[] DEFINITION_long = "64 bit integer signed".toCharArray();
        private static final char[] DEFINITION_double = "64 bit decimal IEEE754".toCharArray();
        private static final char[] DEFINITION_void = Void.TYPE.getSimpleName().toCharArray();

        public static final VarString assemblePrimitiveDefinition(VarString vc, Class<?> primitiveType) {
            if (primitiveType == Byte.TYPE) {
                return vc.add(DEFINITION_byte);
            }
            if (primitiveType == Boolean.TYPE) {
                return vc.add(DEFINITION_boolean);
            }
            if (primitiveType == Short.TYPE) {
                return vc.add(DEFINITION_short);
            }
            if (primitiveType == Character.TYPE) {
                return vc.add(DEFINITION_char);
            }
            if (primitiveType == Integer.TYPE) {
                return vc.add(DEFINITION_int);
            }
            if (primitiveType == Float.TYPE) {
                return vc.add(DEFINITION_float);
            }
            if (primitiveType == Long.TYPE) {
                return vc.add(DEFINITION_long);
            }
            if (primitiveType == Double.TYPE) {
                return vc.add(DEFINITION_double);
            }
            if (primitiveType == Void.TYPE) {
                return vc.add(DEFINITION_void);
            }
            throw new IllegalArgumentException();
        }

        public static final String assemblePrimitiveDefinition(Class<?> primitiveType) {
            return Default.assemblePrimitiveDefinition(VarString.New(), primitiveType).toString();
        }

        public static final Class<?> resolvePrimitiveDefinition(String primitiveDefinition) {
            String trimmed = primitiveDefinition.trim();
            if (XChars.equals((String)trimmed, (char[])DEFINITION_byte, (int)0)) {
                return Byte.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_boolean, (int)0)) {
                return Boolean.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_short, (int)0)) {
                return Short.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_char, (int)0)) {
                return Character.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_int, (int)0)) {
                return Integer.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_float, (int)0)) {
                return Float.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_long, (int)0)) {
                return Long.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_double, (int)0)) {
                return Double.TYPE;
            }
            if (XChars.equals((String)trimmed, (char[])DEFINITION_void, (int)0)) {
                return Void.TYPE;
            }
            throw new PersistenceException("Unknown primitive definition: " + trimmed);
        }

        protected Default(String primitiveDefinition, long persistentLength) {
            super(primitiveDefinition, persistentLength);
        }

        @Override
        public final Class<?> type() {
            return null;
        }
    }
}

