/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.collections.HashEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeIdentity;
import one.microstream.util.cql.CQL;

public interface PersistenceTypeDescription
extends PersistenceTypeIdentity {
    @Override
    public String typeName();

    public XGettingSequence<? extends PersistenceTypeDescriptionMember> allMembers();

    public XGettingSequence<? extends PersistenceTypeDescriptionMember> instanceMembers();

    default public XGettingSequence<? extends PersistenceTypeDescriptionMember> instanceReferenceMembers() {
        return (XGettingSequence)CQL.from(this.instanceMembers()).select(m -> m.isReference()).executeInto((Consumer)HashEnum.New());
    }

    default public XGettingSequence<? extends PersistenceTypeDescriptionMember> instancePrimitiveMembers() {
        return (XGettingSequence)CQL.from(this.instanceMembers()).select(m -> m.isPrimitive()).executeInto((Consumer)HashEnum.New());
    }

    public static char typeIdentifierSeparator() {
        return ':';
    }

    public static String buildTypeIdentifier(long typeId, String typeName) {
        return VarString.New((int)100).add(typeId).add(PersistenceTypeDescription.typeIdentifierSeparator()).add(typeName).toString();
    }

    public static String buildTypeIdentifier(PersistenceTypeDescription typeDescription) {
        return PersistenceTypeDescription.buildTypeIdentifier(typeDescription.typeId(), typeDescription.typeName());
    }

    default public String toTypeIdentifier() {
        return PersistenceTypeDescription.buildTypeIdentifier(this);
    }

    public static boolean equalDescription(PersistenceTypeDescription td1, PersistenceTypeDescription td2) {
        return td1 == td2 || td1 != null && td2 != null && td1.typeName().equals(td1.typeName()) && PersistenceTypeDescriptionMember.equalDescriptions(td1.allMembers(), td2.allMembers());
    }

    public static boolean equalStructure(PersistenceTypeDescription td1, PersistenceTypeDescription td2) {
        return td1 == td2 || td1 != null && td2 != null && td1.typeName().equals(td1.typeName()) && PersistenceTypeDescriptionMember.equalStructures(td1.allMembers(), td2.allMembers());
    }

    public static PersistenceTypeDescription Identity(long typeId, String typeName) {
        return new Identity(typeId, typeName);
    }

    public static final class Identity
    implements PersistenceTypeDescription {
        private final long typeId;
        private final String typeName;

        Identity(long typeId, String typeName) {
            this.typeId = typeId;
            this.typeName = typeName;
        }

        @Override
        public final long typeId() {
            return this.typeId;
        }

        @Override
        public final String typeName() {
            return this.typeName;
        }

        @Override
        public final XGettingSequence<? extends PersistenceTypeDescriptionMember> allMembers() {
            return X.empty();
        }

        @Override
        public final XGettingSequence<? extends PersistenceTypeDescriptionMember> instanceMembers() {
            return X.empty();
        }
    }
}

