/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.entity.Entity;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceAbstractTypeHandlerSearcher;
import one.microstream.persistence.types.PersistenceCustomTypeHandlerRegistry;
import one.microstream.persistence.types.PersistenceDataTypeHolder;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceTypeAnalyzer;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerCreator;
import one.microstream.persistence.types.PersistenceTypeHandlerIterable;
import one.microstream.reflect.XReflect;
import one.microstream.typing.LambdaTypeRecognizer;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface PersistenceTypeHandlerEnsurer<D>
extends PersistenceTypeHandlerIterable<D>,
PersistenceDataTypeHolder<D> {
    public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public static <D> Default<D> New(Class<D> dataType, PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry, PersistenceTypeAnalyzer typeAnalyzer, LambdaTypeRecognizer lambdaTypeRecognizer, PersistenceAbstractTypeHandlerSearcher<D> abstractTypeHandlerSearcher, PersistenceTypeHandlerCreator<D> typeHandlerCreator) {
        return new Default((Class)X.notNull(dataType), (PersistenceCustomTypeHandlerRegistry)X.notNull(customTypeHandlerRegistry), (PersistenceTypeAnalyzer)X.notNull((Object)typeAnalyzer), (LambdaTypeRecognizer)X.notNull((Object)lambdaTypeRecognizer), (PersistenceAbstractTypeHandlerSearcher)X.notNull(abstractTypeHandlerSearcher), (PersistenceTypeHandlerCreator)X.notNull(typeHandlerCreator));
    }

    public static class Default<D>
    extends PersistenceDataTypeHolder.Default<D>
    implements PersistenceTypeHandlerEnsurer<D> {
        private static final Logger logger = Logging.getLogger(Default.class);
        final PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry;
        final PersistenceTypeAnalyzer typeAnalyzer;
        final LambdaTypeRecognizer lambdaTypeRecognizer;
        final PersistenceAbstractTypeHandlerSearcher<D> abstractTypeHandlerSearcher;
        final PersistenceTypeHandlerCreator<D> typeHandlerCreator;

        Default(Class<D> dataType, PersistenceCustomTypeHandlerRegistry<D> customTypeHandlerRegistry, PersistenceTypeAnalyzer typeAnalyzer, LambdaTypeRecognizer lambdaTypeRecognizer, PersistenceAbstractTypeHandlerSearcher<D> abstractTypeHandlerSearcher, PersistenceTypeHandlerCreator<D> typeHandlerCreator) {
            super(dataType);
            this.customTypeHandlerRegistry = customTypeHandlerRegistry;
            this.typeAnalyzer = typeAnalyzer;
            this.lambdaTypeRecognizer = lambdaTypeRecognizer;
            this.abstractTypeHandlerSearcher = abstractTypeHandlerSearcher;
            this.typeHandlerCreator = typeHandlerCreator;
        }

        @Override
        public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            PersistenceTypeHandler<D, T> providedHandler = this.searchProvidedTypeHandler(type);
            if (providedHandler != null) {
                this.logHandlerUsage("provided", providedHandler);
                return providedHandler;
            }
            PersistenceTypeHandler<D, T> customHandler = this.customTypeHandlerRegistry.lookupTypeHandler(type);
            if (customHandler != null) {
                this.logHandlerUsage("predefined", customHandler);
                return customHandler;
            }
            if (type.isPrimitive()) {
                throw new PersistenceException("Primitive types must be handled by default (dummy) handler implementations.");
            }
            if (type == Class.class) {
                throw new PersistenceException("Persisting " + Class.class.getSimpleName() + " instances requires a special-tailored " + PersistenceTypeHandler.class.getSimpleName() + " and cannot be done in a generic way.");
            }
            if (XReflect.isProxyClass(type)) {
                PersistenceTypeHandler<D, T> proxyHandler = this.typeHandlerCreator.createTypeHandlerProxy(type);
                this.logHandlerCreation("proxy", proxyHandler);
                return proxyHandler;
            }
            if (type.isArray()) {
                PersistenceTypeHandler<D, T> arrayHandler = this.typeHandlerCreator.createTypeHandlerArray(type);
                this.logHandlerCreation("array", arrayHandler);
                return arrayHandler;
            }
            if (this.lambdaTypeRecognizer.isLambdaType(type)) {
                PersistenceTypeHandler<D, T> lambdaHandler = this.typeHandlerCreator.createTypeHandlerLambda(type);
                this.logHandlerCreation("lambda", lambdaHandler);
                return lambdaHandler;
            }
            if (this.typeAnalyzer.isUnpersistable(type)) {
                PersistenceTypeHandler<D, T> handlerUnpersistable = this.typeHandlerCreator.createTypeHandlerUnpersistable(type);
                this.logHandlerCreation("non-persisting", handlerUnpersistable);
                return handlerUnpersistable;
            }
            if (XReflect.isEnum(type)) {
                PersistenceTypeHandler<D, T> enumHandler = this.typeHandlerCreator.createTypeHandlerEnum(type);
                this.logHandlerCreation("enum", enumHandler);
                return enumHandler;
            }
            if (XReflect.isAbstract(type)) {
                PersistenceTypeHandler<D, T> abstractHandler = this.typeHandlerCreator.createTypeHandlerAbstract(type);
                this.logHandlerCreation("abstract", abstractHandler);
                return abstractHandler;
            }
            if (Entity.class.isAssignableFrom(type)) {
                PersistenceTypeHandler<D, T> entityHandler = this.typeHandlerCreator.createTypeHandlerEntity(type);
                this.logHandlerCreation("entity", entityHandler);
                return entityHandler;
            }
            PersistenceTypeHandler<D, T> abstractHandler = this.lookupAbstractTypeHandler(type);
            if (abstractHandler != null) {
                this.logHandlerCreation("abstract", abstractHandler);
                return abstractHandler;
            }
            PersistenceTypeHandler<D, T> genericHandler = this.typeHandlerCreator.createTypeHandlerGeneric(type);
            this.logHandlerCreation("generic", genericHandler);
            return genericHandler;
        }

        private void logHandlerUsage(String handlerType, PersistenceTypeHandler<?, ?> handler) {
            logger.debug("Using {} type handler for {}: {}", new Object[]{handlerType, handler.type().getName(), XChars.systemString(handler)});
        }

        private void logHandlerCreation(String handlerType, PersistenceTypeHandler<?, ?> handler) {
            logger.debug("Created {} type handler for {}: {}", new Object[]{handlerType, handler.type().getName(), XChars.systemString(handler)});
        }

        protected <T> PersistenceTypeHandler<D, ? super T> lookupAbstractTypeHandler(Class<T> type) {
            return this.abstractTypeHandlerSearcher.searchAbstractTypeHandler(type, this.customTypeHandlerRegistry);
        }

        protected <T> PersistenceTypeHandler<D, ? super T> searchProvidedTypeHandler(Class<T> type) {
            try {
                return Persistence.searchProvidedTypeHandler(this.dataType(), type, null);
            }
            catch (ReflectiveOperationException e) {
                throw new PersistenceException(e);
            }
        }

        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateTypeHandlers(C iterator) {
            return this.customTypeHandlerRegistry.iterateTypeHandlers(iterator);
        }

        @Override
        public <C extends Consumer<? super PersistenceLegacyTypeHandler<D, ?>>> C iterateLegacyTypeHandlers(C iterator) {
            return this.customTypeHandlerRegistry.iterateLegacyTypeHandlers(iterator);
        }

        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateAllTypeHandlers(C iterator) {
            return this.customTypeHandlerRegistry.iterateAllTypeHandlers(iterator);
        }
    }
}

