/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import one.microstream.afs.types.AFile;
import one.microstream.math.XMath;
import one.microstream.persistence.internal.AbstractProviderByFile;

public abstract class AbstractIdProviderByFile
extends AbstractProviderByFile {
    private final long increase;
    private long id;
    private long threshold;

    public static final void writeId(AFile file, long value) {
        AbstractIdProviderByFile.write(file, Long.toString(value));
    }

    protected AbstractIdProviderByFile(AFile file, long increase, long id) {
        super(file);
        this.id = XMath.notNegative((long)id);
        this.increase = XMath.positive((long)increase);
        this.threshold = id + increase;
    }

    private void writeId(long value) {
        this.write(Long.toString(value));
    }

    protected void internalInitialize() {
        this.id = this.canRead() ? this.readId() : this.provideDefaultId();
        this.threshold = this.id;
    }

    protected long readId() {
        return Long.parseLong(this.read());
    }

    protected long provideDefaultId() {
        this.writeId(this.id);
        return this.id;
    }

    private void enlargeThreshold() {
        this.writeId(this.threshold += this.increase);
    }

    protected final long next() {
        if (++this.id >= this.threshold) {
            this.enlargeThreshold();
        }
        return this.id;
    }

    protected final long current() {
        return this.id;
    }

    protected final void internalUpdateId(long value) {
        if (value < this.id) {
            throw new IllegalArgumentException("Desired update id value of " + value + " has already been passed by current id value of " + this.id);
        }
        if (value == this.id) {
            return;
        }
        this.threshold = this.id = value;
        this.writeId(this.id);
    }
}

