/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.internal;

import java.lang.ref.WeakReference;
import one.microstream.X;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.Set_long;
import one.microstream.collections.XSort;
import one.microstream.collections.types.XGettingTable;
import one.microstream.hashing.HashStatisticsBucketBased;
import one.microstream.hashing.XHashing;
import one.microstream.math.XMath;
import one.microstream.meta.XDebug;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistency;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistencyObject;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistencyObjectId;
import one.microstream.persistence.exceptions.PersistenceExceptionImproperObjectId;
import one.microstream.persistence.exceptions.PersistenceExceptionInvalidObjectRegistryCapacity;
import one.microstream.persistence.types.ObjectIdsProcessor;
import one.microstream.persistence.types.PersistenceAcceptor;
import one.microstream.persistence.types.PersistenceObjectRegistry;
import one.microstream.reference.Swizzling;
import one.microstream.typing.KeyValue;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public final class DefaultObjectRegistry
implements PersistenceObjectRegistry {
    private static final Logger logger = Logging.getLogger(DefaultObjectRegistry.class);
    private final Object mutex = new Object();
    private Entry[] oidHashTable;
    private Entry[] refHashTable;
    private int hashRange;
    private float hashDensity;
    private long capacity;
    private long minCapacity;
    private long size;
    private EqHashTable<Long, Object> constantsHotRegistry = EqHashTable.New();
    private Object[] constantsColdStorageObjects;
    private long[] constantsColdStorageObjectIds;

    public static final float defaultHashDensity() {
        return 1.0f;
    }

    public static final boolean isValidHashDensity(float desiredHashDensity) {
        return XHashing.isValidHashDensity((float)desiredHashDensity);
    }

    public static final float validateHashDensity(float desiredHashDensity) {
        return XHashing.validateHashDensity((float)desiredHashDensity);
    }

    public static final boolean isValidCapacity(long desiredCapacity) {
        return desiredCapacity > 0L;
    }

    public static final long validateCapacity(long desiredCapacity) {
        if (!DefaultObjectRegistry.isValidCapacity(desiredCapacity)) {
            throw new PersistenceExceptionInvalidObjectRegistryCapacity(desiredCapacity);
        }
        return desiredCapacity;
    }

    static final int hash(Object object) {
        return System.identityHashCode(object);
    }

    private static Entry[] createHashTable(int hashLength) {
        return new Entry[hashLength];
    }

    private static int calculateRequiredHashLength(long minimumCapacity, float hashDensity) {
        return XHashing.padHashLength((long)((long)((float)minimumCapacity / hashDensity)));
    }

    public static DefaultObjectRegistry New() {
        return DefaultObjectRegistry.New(DefaultObjectRegistry.defaultHashDensity());
    }

    public static DefaultObjectRegistry New(long minimumCapacity) {
        return DefaultObjectRegistry.New(DefaultObjectRegistry.defaultHashDensity(), minimumCapacity);
    }

    public static DefaultObjectRegistry New(float hashDensity) {
        return DefaultObjectRegistry.New(hashDensity, 1L);
    }

    public static DefaultObjectRegistry New(float hashDensity, long minimumCapacity) {
        return new DefaultObjectRegistry().synchSetConfiguration(DefaultObjectRegistry.validateHashDensity(hashDensity), DefaultObjectRegistry.validateCapacity(minimumCapacity)).synchReset();
    }

    DefaultObjectRegistry() {
    }

    private int synchHashLength() {
        return this.hashRange + 1;
    }

    private void synchSetHashDensity(float validHashDensity) {
        this.hashDensity = validHashDensity;
    }

    private void synchSetMinimumCapacity(long validMinimumCapacity) {
        this.minCapacity = validMinimumCapacity;
    }

    final DefaultObjectRegistry synchSetConfiguration(float hashDensity, long minimumCapacity) {
        this.synchSetHashDensity(hashDensity);
        this.synchSetMinimumCapacity(minimumCapacity);
        return this;
    }

    final DefaultObjectRegistry synchReset() {
        return this.synchReset(this.minCapacity);
    }

    final DefaultObjectRegistry synchReset(long minimumCapacity) {
        this.size = 0L;
        int hashLength = DefaultObjectRegistry.calculateRequiredHashLength(minimumCapacity, this.hashDensity);
        this.synchSetHashTables(DefaultObjectRegistry.createHashTable(hashLength), DefaultObjectRegistry.createHashTable(hashLength));
        return this;
    }

    private void synchSetHashTables(Entry[] oidHashTable, Entry[] refHashTable) {
        this.oidHashTable = oidHashTable;
        this.refHashTable = refHashTable;
        this.hashRange = oidHashTable.length - 1;
        this.synchUpdateCapacity();
    }

    private void synchUpdateCapacity() {
        this.capacity = this.synchHashLength() >= XMath.highestPowerOf2_int() ? Long.MAX_VALUE : (long)((float)this.synchHashLength() * this.hashDensity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DefaultObjectRegistry Clone() {
        Object object = this.mutex;
        synchronized (object) {
            return DefaultObjectRegistry.New(this.hashDensity, this.minCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int hashRange() {
        Object object = this.mutex;
        synchronized (object) {
            return this.oidHashTable.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final float hashDensity() {
        Object object = this.mutex;
        synchronized (object) {
            return this.hashDensity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long minimumCapacity() {
        Object object = this.mutex;
        synchronized (object) {
            return this.minCapacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long capacity() {
        Object object = this.mutex;
        synchronized (object) {
            return this.capacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.size == 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setHashDensity(float hashDensity) {
        Object object = this.mutex;
        synchronized (object) {
            this.synchSetHashDensity(DefaultObjectRegistry.validateHashDensity(hashDensity));
            this.synchUpdateCapacity();
            return this.ensureCapacity(this.minCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setConfiguration(float hashDensity, long minimumCapacity) {
        Object object = this.mutex;
        synchronized (object) {
            DefaultObjectRegistry.validateHashDensity(hashDensity);
            DefaultObjectRegistry.validateCapacity(minimumCapacity);
            this.synchSetHashDensity(hashDensity);
            this.synchSetMinimumCapacity(minimumCapacity);
            this.synchUpdateCapacity();
            return this.ensureCapacity(minimumCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setMinimumCapacity(long minimumCapacity) {
        Object object = this.mutex;
        synchronized (object) {
            this.synchSetMinimumCapacity(DefaultObjectRegistry.validateCapacity(minimumCapacity));
            this.synchUpdateCapacity();
            return this.ensureCapacity(minimumCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean ensureCapacity(long desiredCapacity) {
        Object object = this.mutex;
        synchronized (object) {
            DefaultObjectRegistry.validateCapacity(desiredCapacity);
            int requiredHashLength = DefaultObjectRegistry.calculateRequiredHashLength(desiredCapacity, this.hashDensity);
            if (requiredHashLength > this.synchHashLength()) {
                this.synchRebuild(requiredHashLength);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsObjectId(long objectId) {
        Object object = this.mutex;
        synchronized (object) {
            return this.synchContainsObjectId(objectId);
        }
    }

    private boolean synchContainsObjectId(long objectId) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                return true;
            }
            e = e.oidNext;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long lookupObjectId(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.synchLookupObjectId(object);
        }
    }

    private long synchLookupObjectId(Object object) {
        Entry e = this.refHashTable[DefaultObjectRegistry.hash(object) & this.hashRange];
        while (e != null) {
            if (e.get() == object) {
                return e.objectId;
            }
            e = e.refNext;
        }
        return Swizzling.notFoundId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object lookupObject(long objectId) {
        Object object = this.mutex;
        synchronized (object) {
            return this.synchLookupObject(objectId);
        }
    }

    private Object synchLookupObject(long objectId) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                return e.get();
            }
            e = e.oidNext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isValid(long objectId, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.synchInternalValidate(objectId, object, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validate(long objectId, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.synchInternalValidate(objectId, object, true);
        }
    }

    private boolean synchInternalValidate(long objectId, Object object, boolean throwException) {
        if (object == null) {
            throw new NullPointerException();
        }
        long registeredObjectId = this.synchLookupObjectId(object);
        if (registeredObjectId == objectId) {
            return true;
        }
        if (Swizzling.isNotFoundId((long)registeredObjectId)) {
            Object registeredObject = this.synchLookupObject(objectId);
            if (registeredObject == null) {
                return true;
            }
            if (!throwException) {
                return false;
            }
            if (registeredObject == object) {
                throw new PersistenceExceptionConsistency("Inconsistent object registry for objectId " + objectId);
            }
            throw new PersistenceExceptionConsistencyObject(objectId, registeredObject, object);
        }
        if (!throwException) {
            return false;
        }
        throw new PersistenceExceptionConsistencyObjectId(object, registeredObjectId, objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean registerObject(long objectId, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.synchRegisterObject(objectId, object);
        }
    }

    private boolean synchRegisterObject(long objectId, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (Swizzling.isNotProperId((long)objectId)) {
            throw new PersistenceExceptionImproperObjectId();
        }
        return this.synchAdd(objectId, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object optionalRegisterObject(long objectId, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (Swizzling.isNotProperId((long)objectId)) {
                throw new PersistenceExceptionImproperObjectId();
            }
            return this.synchAddGet(objectId, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean registerConstant(long objectId, Object constant) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.synchRegisterObject(objectId, constant)) {
                return false;
            }
            this.synchEnsureConstantsHotRegistry().add((Object)objectId, constant);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <A extends PersistenceAcceptor> A iterateEntries(A acceptor) {
        Object object = this.mutex;
        synchronized (object) {
            DefaultObjectRegistry.iterateEntries(this.oidHashTable, acceptor);
            return acceptor;
        }
    }

    private boolean synchAdd(long objectId, Object object) {
        if (this.synchAddCheck(objectId, object)) {
            return false;
        }
        this.synchPutNewEntry(objectId, object);
        return true;
    }

    private void synchPutNewEntry(long objectId, Object object) {
        Entry entry = new Entry(objectId, object, this.oidHashTable[(int)objectId & this.hashRange], this.refHashTable[DefaultObjectRegistry.hash(object) & this.hashRange]);
        this.refHashTable[DefaultObjectRegistry.hash((Object)object) & this.hashRange] = entry;
        this.oidHashTable[(int)objectId & this.hashRange] = entry;
        if (++this.size > this.capacity) {
            this.synchIncreaseStorage();
        }
    }

    private boolean synchAddCheck(long objectId, Object object) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                return this.synchHandleExisting(object, e);
            }
            e = e.oidNext;
        }
        this.synchValidateObjectNotYetRegistered(objectId, object);
        return false;
    }

    private Object synchAddGetCheck(long objectId, Object object) {
        Entry e = this.oidHashTable[(int)objectId & this.hashRange];
        while (e != null) {
            if (e.objectId == objectId) {
                Object registered = e.get();
                if (registered != null) {
                    return registered;
                }
                this.synchRemoveEntry(e);
                break;
            }
            e = e.oidNext;
        }
        this.synchValidateObjectNotYetRegistered(objectId, object);
        return null;
    }

    private boolean synchHandleExisting(Object object, Entry entry) {
        if (entry.get() == object) {
            return true;
        }
        if (entry.get() != null) {
            throw new PersistenceExceptionConsistencyObject(entry.objectId, entry.get(), object);
        }
        this.synchValidateObjectNotYetRegistered(entry.objectId, object);
        this.synchRemoveEntry(entry);
        return false;
    }

    private void synchRemoveEntry(Entry entry) {
        DefaultObjectRegistry.removeFromOidTable(this.oidHashTable, (int)entry.objectId & this.hashRange, entry);
        DefaultObjectRegistry.removeFromRefTable(this.refHashTable, entry.refHash & this.hashRange, entry);
        --this.size;
    }

    private static void removeFromOidTable(Entry[] table, int index, Entry entry) {
        Entry e = table[index];
        Entry last = null;
        while (e != null) {
            if (e == entry) {
                if (last == null) {
                    table[index] = e.oidNext;
                } else {
                    last.oidNext = e.oidNext;
                }
            }
            last = e;
            e = last.oidNext;
        }
    }

    private static void removeFromRefTable(Entry[] table, int index, Entry entry) {
        Entry e = table[index];
        Entry last = null;
        while (e != null) {
            if (e == entry) {
                if (last == null) {
                    table[index] = e.refNext;
                } else {
                    last.refNext = e.refNext;
                }
            }
            last = e;
            e = last.refNext;
        }
    }

    private void synchValidateObjectNotYetRegistered(long objectId, Object object) {
        int refHash = DefaultObjectRegistry.hash(object);
        Entry e = this.refHashTable[refHash & this.hashRange];
        while (e != null) {
            if (e.get() == object) {
                throw new PersistenceExceptionConsistencyObjectId(object, e.objectId, objectId);
            }
            e = e.refNext;
        }
    }

    private Object synchAddGet(long objectId, Object object) {
        Object alreadyRegistered = this.synchAddGetCheck(objectId, object);
        if (alreadyRegistered != null) {
            return alreadyRegistered;
        }
        this.synchPutNewEntry(objectId, object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean consolidate() {
        Object object = this.mutex;
        synchronized (object) {
            return this.synchConsolidate();
        }
    }

    private boolean synchConsolidate() {
        Entry[] oidHashTable = this.oidHashTable;
        Entry[] refHashTable = this.refHashTable;
        int orphanCount = 0;
        for (int h = 0; h < oidHashTable.length; ++h) {
            orphanCount += DefaultObjectRegistry.consolidateOidHashChain(oidHashTable, h);
            DefaultObjectRegistry.consolidateRefHashChain(refHashTable, h);
        }
        this.size -= (long)orphanCount;
        return this.checkForDecrease();
    }

    private static int consolidateOidHashChain(Entry[] oidHashTable, int h) {
        int orphanCount = 0;
        Entry e = oidHashTable[h];
        Entry lastProper = null;
        while (e != null) {
            if (e.get() != null) {
                lastProper = e;
            } else {
                if (lastProper == null) {
                    oidHashTable[h] = e.oidNext;
                } else {
                    lastProper.oidNext = e.oidNext;
                }
                ++orphanCount;
            }
            e = e.oidNext;
        }
        return orphanCount;
    }

    private static void consolidateRefHashChain(Entry[] refHashTable, int h) {
        Entry e = refHashTable[h];
        Entry lastProper = null;
        while (e != null) {
            if (e.get() != null) {
                lastProper = e;
            } else if (lastProper == null) {
                refHashTable[h] = e.refNext;
            } else {
                lastProper.refNext = e.refNext;
            }
            e = e.refNext;
        }
    }

    private boolean checkForDecrease() {
        int requiredHashLength = DefaultObjectRegistry.calculateRequiredHashLength(this.size, this.hashDensity);
        if (requiredHashLength != this.synchHashLength()) {
            this.synchRebuild(requiredHashLength);
            return true;
        }
        return false;
    }

    private void synchIncreaseStorage() {
        this.synchRebuild(this.oidHashTable.length << 1);
    }

    private void synchRebuild(int hashLength) {
        Entry[] newOidHashTable = DefaultObjectRegistry.createHashTable(hashLength);
        Entry[] newRefHashTable = DefaultObjectRegistry.createHashTable(hashLength);
        this.size -= DefaultObjectRegistry.rebuildTables(this.oidHashTable, newOidHashTable, newRefHashTable);
        this.synchSetHashTables(newOidHashTable, newRefHashTable);
        this.checkForDecrease();
        this.synchEnsureConstantsColdStorage();
    }

    private static long rebuildTables(Entry[] oldOidHashTable, Entry[] newOidHashTable, Entry[] newRefHashTable) {
        int hashRange = newOidHashTable.length - 1;
        long orphanCount = 0L;
        for (int i = 0; i < oldOidHashTable.length; ++i) {
            if (oldOidHashTable[i] == null) continue;
            orphanCount += (long)DefaultObjectRegistry.rebuildEntryChain(oldOidHashTable[i], hashRange, newOidHashTable, newRefHashTable);
        }
        return orphanCount;
    }

    private static int rebuildEntryChain(Entry firstOidHashEntry, int hashRange, Entry[] newOidHashTable, Entry[] newRefHashTable) {
        Entry next;
        int orphanCount = 0;
        Entry e = firstOidHashEntry;
        do {
            next = e.oidNext;
            if (e.get() != null) {
                e.oidNext = newOidHashTable[(int)e.objectId & hashRange];
                e.refNext = newRefHashTable[e.refHash & hashRange];
                newOidHashTable[(int)e.objectId & hashRange] = e;
                newRefHashTable[e.refHash & hashRange] = e;
                continue;
            }
            ++orphanCount;
        } while ((e = next) != null);
        return orphanCount;
    }

    private static void iterateEntries(Entry[] oidHashTable, PersistenceAcceptor acceptor) {
        for (int s = 0; s < oidHashTable.length; ++s) {
            Entry e = oidHashTable[s];
            while (e != null) {
                acceptor.accept(e.objectId, e.get());
                e = e.oidNext;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.synchEnsureConstantsColdStorage();
            this.synchClear();
            this.synchReregisterConstants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearAll() {
        Object object = this.mutex;
        synchronized (object) {
            this.synchClear();
        }
    }

    private void synchClear() {
        Entry[] oidBuckets = this.oidHashTable;
        Entry[] refBuckets = this.refHashTable;
        for (int i = 0; i < oidBuckets.length; ++i) {
            refBuckets[i] = null;
            oidBuckets[i] = null;
        }
        this.size = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void truncate() {
        Object object = this.mutex;
        synchronized (object) {
            this.synchEnsureConstantsColdStorage();
            this.synchReset(Math.max((long)this.constantsColdStorageObjects.length, this.minCapacity));
            this.synchReregisterConstants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void truncateAll() {
        Object object = this.mutex;
        synchronized (object) {
            this.synchReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchReregisterConstants() {
        Object object = this.mutex;
        synchronized (object) {
            Object[] constantsObjects = this.constantsColdStorageObjects;
            long[] constantsObjectIds = this.constantsColdStorageObjectIds;
            for (int i = 0; i < constantsObjects.length; ++i) {
                this.synchRegisterObject(constantsObjectIds[i], constantsObjects[i]);
            }
        }
    }

    private EqHashTable<Long, Object> synchEnsureConstantsHotRegistry() {
        if (this.constantsHotRegistry == null) {
            this.synchBuildConstantsHotRegistry();
        }
        return this.constantsHotRegistry;
    }

    private void synchBuildConstantsHotRegistry() {
        EqHashTable constantsHotRegistry = EqHashTable.New();
        Object[] constantsObjects = this.constantsColdStorageObjects;
        long[] constantsObjectIds = this.constantsColdStorageObjectIds;
        int constantsLength = constantsObjects.length;
        for (int i = 0; i < constantsLength; ++i) {
            constantsHotRegistry.add((Object)constantsObjectIds[i], constantsObjects[i]);
        }
        this.constantsHotRegistry = constantsHotRegistry;
        this.constantsColdStorageObjects = null;
        this.constantsColdStorageObjectIds = null;
    }

    private void synchEnsureConstantsColdStorage() {
        if (this.constantsColdStorageObjects != null) {
            return;
        }
        this.synchBuildConstantsColdStorage();
    }

    private void synchBuildConstantsColdStorage() {
        EqHashTable<Long, Object> constantsHotRegistry = this.constantsHotRegistry;
        int constantCount = X.checkArrayRange((long)constantsHotRegistry.size());
        Object[] constantsObjects = new Object[constantCount];
        long[] constantsObjectIds = new long[constantCount];
        int i = 0;
        for (KeyValue e : constantsHotRegistry) {
            constantsObjects[i] = e.value();
            constantsObjectIds[i] = (Long)e.key();
            ++i;
        }
        this.constantsHotRegistry = null;
        this.constantsColdStorageObjects = constantsObjects;
        this.constantsColdStorageObjectIds = constantsObjectIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processLiveObjectIds(ObjectIdsProcessor processor) {
        Object object = this.mutex;
        synchronized (object) {
            processor.processObjectIdsByFilter(this::synchIsLiveObjectId);
            return true;
        }
    }

    final boolean synchIsLiveObjectId(long objectId) {
        boolean result = this.synchContainsObjectId(objectId);
        logger.debug("ObjectRegistry checking OID " + objectId + ": " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set_long selectLiveObjectIds(Set_long objectIdsBaseSet) {
        Object object = this.mutex;
        synchronized (object) {
            return objectIdsBaseSet.filter(this::synchIsLiveObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XGettingTable<String, HashStatisticsBucketBased> createHashStatistics() {
        Object object = this.mutex;
        synchronized (object) {
            return EqHashTable.New((KeyValue[])new KeyValue[]{X.KeyValue((Object)"PerObjectIds", (Object)this.synchCreateHashStatisticsOids()), X.KeyValue((Object)"PerObjects", (Object)this.synchCreateHashStatisticsRefs())});
        }
    }

    private HashStatisticsBucketBased synchCreateHashStatisticsOids() {
        EqHashTable distributionTable = EqHashTable.New();
        Entry[] oidHashTable = this.oidHashTable;
        for (int h = 0; h < oidHashTable.length; ++h) {
            Long bucketLength = DefaultObjectRegistry.countOidChainLength(oidHashTable[h]);
            DefaultObjectRegistry.registerDistribution((EqHashTable<Long, Long>)distributionTable, bucketLength);
        }
        DefaultObjectRegistry.complete((EqHashTable<Long, Long>)distributionTable);
        return HashStatisticsBucketBased.New((long)oidHashTable.length, (long)this.size, (float)this.hashDensity, (long)((Long)distributionTable.keys().last()), (XGettingTable)distributionTable);
    }

    private HashStatisticsBucketBased synchCreateHashStatisticsRefs() {
        EqHashTable distributionTable = EqHashTable.New();
        Entry[] refHashTable = this.refHashTable;
        for (int h = 0; h < refHashTable.length; ++h) {
            Long bucketLength = DefaultObjectRegistry.countRefChainLength(refHashTable[h]);
            DefaultObjectRegistry.registerDistribution((EqHashTable<Long, Long>)distributionTable, bucketLength);
        }
        DefaultObjectRegistry.complete((EqHashTable<Long, Long>)distributionTable);
        return HashStatisticsBucketBased.New((long)refHashTable.length, (long)this.size, (float)this.hashDensity, (long)((Long)distributionTable.keys().last()), (XGettingTable)distributionTable);
    }

    private static Long countOidChainLength(Entry firstEntry) {
        long count = 0L;
        Entry e = firstEntry;
        while (e != null) {
            if (e.get() != null) {
                ++count;
            }
            e = e.oidNext;
        }
        return count;
    }

    private static Long countRefChainLength(Entry firstEntry) {
        long count = 0L;
        Entry e = firstEntry;
        while (e != null) {
            if (e.get() != null) {
                ++count;
            }
            e = e.refNext;
        }
        return count;
    }

    private static void registerDistribution(EqHashTable<Long, Long> distributionTable, Long bucketLength) {
        Long count = (Long)distributionTable.get((Object)bucketLength);
        if (count == null) {
            distributionTable.put((Object)bucketLength, (Object)1L);
        } else {
            distributionTable.put((Object)bucketLength, (Object)(count + 1L));
        }
    }

    private static void complete(EqHashTable<Long, Long> distributionTable) {
        distributionTable.keys().sort(XSort::compare);
        Long highest = (Long)distributionTable.last().key();
        Long zero = 0L;
        for (long l = 0L; l < highest; ++l) {
            distributionTable.add((Object)l, (Object)zero);
        }
        distributionTable.keys().sort(XSort::compare);
    }

    public static final void printEntryInstanceSizeInfo() {
        XDebug.printInstanceSizeInfo(Entry.class);
    }

    static final class Entry
    extends WeakReference<Object> {
        final long objectId;
        int refHash;
        Entry oidNext;
        Entry refNext;

        Entry(long objectId, Object referent, Entry oidNext, Entry refnext) {
            super(referent);
            this.objectId = objectId;
            this.refHash = DefaultObjectRegistry.hash(referent);
            this.oidNext = oidNext;
            this.refNext = refnext;
        }
    }
}

