/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.chars.StringTable;
import one.microstream.chars.XChars;
import one.microstream.collections.BulkList;
import one.microstream.collections.ConstHashEnum;
import one.microstream.collections.HashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.interfaces.ChainStorage;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingSet;
import one.microstream.collections.types.XIterable;
import one.microstream.io.XIO;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistencyInvalidObjectId;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistencyInvalidTypeId;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeConsistencyDefinitionResolveTypeName;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import one.microstream.persistence.types.PersistenceEagerStoringFieldEvaluator;
import one.microstream.persistence.types.PersistenceFieldEvaluator;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceObjectRegistry;
import one.microstream.persistence.types.PersistenceRefactoringMappingProvider;
import one.microstream.persistence.types.PersistenceTypeEvaluator;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeIdLookup;
import one.microstream.persistence.types.PersistenceTypeMismatchValidator;
import one.microstream.persistence.types.PersistenceTypeRegistry;
import one.microstream.persistence.types.PersistenceTypeResolver;
import one.microstream.persistence.types.Persister;
import one.microstream.persistence.types.Unpersistable;
import one.microstream.reference.Lazy;
import one.microstream.reference.Swizzling;
import one.microstream.reflect.XReflect;
import one.microstream.typing.Composition;
import one.microstream.typing.KeyValue;
import one.microstream.util.xcsv.XCSV;
import one.microstream.util.xcsv.XCsvConfiguration;
import one.microstream.util.xcsv.XCsvDataType;

public class Persistence {
    static final long START_CID_BASE = 9000000000000000000L;
    static final long START_OID_BASE = 1000000000000000000L;
    static final long START_TID_BASE = 0L;
    static final long FIRST_CID = 9000000000000000001L;
    static final long FIRST_OID = 1000000000000000001L;
    static final long FIRST_TID = 1L;
    static final long BOUND_CID = 9100000000000000000L;
    static final long BOUND_OID = 9000000000000000000L;
    static final long BOUND_TID = 1000000000000000000L;
    static final long START_CID_BYTE = 9000000000000001000L;
    static final long START_CID_BOOLEAN = 9000000000000002000L;
    static final long START_CID_SHORT = 9000000000000003000L;
    static final long START_CID_CHARACTER = 9000000000000004000L;
    static final long START_CID_INTEGER = 9000000000000005000L;
    static final long START_CID_LONG = 9000000000000006000L;
    static final int JSL_CACHE_INTEGER_START = -128;
    static final int JSL_CACHE_INTEGER_BOUND = 128;
    static final int JSL_CACHE_CHARACTER_START = 0;
    static final int JSL_CACHE_CHARACTER_BOUND = 128;
    static final long START_CID_REAL = 9000000000000010000L;
    static final long START_TID_REAL = 1000000L;
    static final long TID_PRIMITIVE_byte = 1L;
    static final long TID_PRIMITIVE_boolean = 2L;
    static final long TID_PRIMITIVE_short = 3L;
    static final long TID_PRIMITIVE_char = 4L;
    static final long TID_PRIMITIVE_int = 5L;
    static final long TID_PRIMITIVE_float = 6L;
    static final long TID_PRIMITIVE_long = 7L;
    static final long TID_PRIMITIVE_double = 8L;
    static final long TID_PRIMITIVE_void = 9L;
    static final long TID_Object = 10L;
    static final long TID_Byte = 11L;
    static final long TID_Boolean = 12L;
    static final long TID_Short = 13L;
    static final long TID_Character = 14L;
    static final long TID_Integer = 15L;
    static final long TID_Float = 16L;
    static final long TID_Long = 17L;
    static final long TID_Double = 18L;
    static final long TID_Void = 19L;
    static final long TID_Class = 20L;
    static final long TID_Enum = 21L;
    static final long TID_String = 30L;
    static final long TID_AbstractStringBuilder = 31L;
    static final long TID_StringBuffer = 32L;
    static final long TID_StringBuilder = 33L;
    static final long TID_java_io_File = 34L;
    static final long TID_java_util_Date = 35L;
    static final long TID_Number = 36L;
    static final long TID_java_math_BigInteger = 37L;
    static final long TID_java_math_BigDecimal = 38L;
    static final long TID_java_util_AbstractCollection = 40L;
    static final long TID_java_util_AbstractList = 41L;
    static final long TID_java_util_AbstractSet = 42L;
    static final long TID_java_util_ArrayList = 43L;
    static final long TID_java_util_HashSet = 44L;
    static final long TID_java_util_AbstractMap = 45L;
    static final long TID_java_util_HashMap = 46L;
    static final long TID_java_util_Dictionary = 47L;
    static final long TID_java_util_Hashtable = 48L;
    static final long TID_java_util_ArrayDeque = 49L;
    static final long TID_java_util_IdentityHashMap = 50L;
    static final long TID_java_util_LinkedHashMap = 51L;
    static final long TID_java_util_LinkedHashSet = 52L;
    static final long TID_java_util_AbstractSequentialList = 53L;
    static final long TID_java_util_LinkedList = 54L;
    static final long TID_java_util_AbstractQueue = 55L;
    static final long TID_java_util_PriorityQueue = 56L;
    static final long TID_java_util_TreeMap = 57L;
    static final long TID_java_util_TreeSet = 58L;
    static final long TID_java_util_Vector = 59L;
    static final long TID_java_util_Stack = 60L;
    static final long TID_java_util_Properties = 61L;
    static final long TID_java_util_ConcurrentHashMap = 62L;
    static final long TID_java_util_ConcurrentLinkedDeque = 63L;
    static final long TID_java_util_ConcurrentLinkedQueue = 64L;
    static final long TID_java_util_ConcurrentSkipListMap = 65L;
    static final long TID_java_util_ConcurrentSkipListSet = 66L;
    static final long TID_java_util_WeakHashMap = 67L;
    static final long TID_java_util_Locale = 68L;
    static final long TID_ARRAY_byte = 101L;
    static final long TID_ARRAY_boolean = 102L;
    static final long TID_ARRAY_short = 103L;
    static final long TID_ARRAY_char = 104L;
    static final long TID_ARRAY_int = 105L;
    static final long TID_ARRAY_float = 106L;
    static final long TID_ARRAY_long = 107L;
    static final long TID_ARRAY_double = 108L;
    static final long TID_ARRAY_Object = 110L;
    static final long TID_ARRAY_Byte = 111L;
    static final long TID_ARRAY_Boolean = 112L;
    static final long TID_ARRAY_Short = 113L;
    static final long TID_ARRAY_Character = 114L;
    static final long TID_ARRAY_Integer = 115L;
    static final long TID_ARRAY_Float = 116L;
    static final long TID_ARRAY_Long = 117L;
    static final long TID_ARRAY_Double = 118L;
    static final long TID_ARRAY_Void = 119L;
    static final long TID_ARRAY_Class = 120L;
    static final long TID_ARRAY_Enum = 121L;
    static final long TID_ARRAY_String = 130L;
    static final long TID_ARRAY_AbsStringBuffr = 131L;
    static final long TID_ARRAY_StringBuffer = 132L;
    static final long TID_ARRAY_StringBuilder = 133L;
    static final long TID_persistence_Lazy_Default = 10000L;
    static final String OBJECT_ID_LABEL = "ObjectId";
    static final String OBJECT_ID_LABEL_SHORT = "OID";
    static final HashTable<Class<?>, Long> NATIVE_TYPES = HashTable.New();
    private static final ConstHashEnum<Class<?>> UNPERSISTABLE_TYPES;
    private static final String ENUM_ROOT_IDENTIFIER_START;

    public static String engineName() {
        return "MicroStream";
    }

    public static final String objectIdLabel() {
        return OBJECT_ID_LABEL;
    }

    public static final String objectIdShortLabel() {
        return OBJECT_ID_LABEL_SHORT;
    }

    public static final Class<?> objectIdType() {
        return Long.TYPE;
    }

    public static final PersistenceTypeIdLookup createDefaultTypeLookup() {
        return new PersistenceTypeIdLookup(){

            @Override
            public long lookupTypeId(Class<?> type) {
                Long nativeTypeId = (Long)NATIVE_TYPES.get(type);
                return nativeTypeId == null ? Swizzling.notFoundId() : nativeTypeId;
            }
        };
    }

    public static final long defaultStartTypeId() {
        return 1000000L;
    }

    public static final long defaultStartConstantId() {
        return 9000000000000010000L;
    }

    public static final long defaultStartObjectId() {
        return 1000000000000000000L;
    }

    public static final long defaultBoundConstantId() {
        return 9100000000000000000L;
    }

    public static final long classTypeId() {
        return 20L;
    }

    public static final boolean isNativeType(Class<?> type) {
        return NATIVE_TYPES.get(type) != null;
    }

    public static final Long getNativeTypeId(Class<?> type) {
        return (Long)NATIVE_TYPES.get(type);
    }

    public static final <R extends PersistenceObjectRegistry> R registerJavaNatives(R registry) {
        Persistence.registerJavaConstants(registry);
        return registry;
    }

    public static final <R extends PersistenceTypeRegistry> R registerJavaBasicTypes(R registry) {
        Persistence.iterateJavaBasicTypes((c, tid) -> registry.registerType((long)tid, (Class<?>)c));
        return registry;
    }

    public static final <C extends BiConsumer<Class<?>, Long>> C iterateJavaBasicTypes(C iterator) {
        NATIVE_TYPES.iterate(e -> iterator.accept((Class)e.key(), (Long)e.value()));
        return iterator;
    }

    public static final <R extends PersistenceObjectRegistry> R registerJavaConstants(R registry) {
        int i;
        long oidByte = 9000000000000001000L;
        long oidBoolean = 9000000000000002000L;
        long oidShort = 9000000000000003000L;
        long oidCharacter = 9000000000000004000L;
        long oidInteger = 9000000000000005000L;
        long oidLong = 9000000000000006000L;
        registry.registerConstant(oidBoolean++, Boolean.FALSE);
        registry.registerConstant(oidBoolean++, Boolean.TRUE);
        for (i = -128; i < 128; ++i) {
            registry.registerConstant(oidByte++, (byte)i);
            registry.registerConstant(oidShort++, (short)i);
            registry.registerConstant(oidInteger++, i);
            registry.registerConstant(oidLong++, i);
        }
        for (i = 0; i < 128; ++i) {
            registry.registerConstant(oidCharacter++, Character.valueOf((char)i));
        }
        return registry;
    }

    public static long validateObjectId(long id) throws PersistenceExceptionConsistencyInvalidObjectId {
        if (id < 1000000000000000000L) {
            throw new PersistenceExceptionConsistencyInvalidObjectId(id);
        }
        return id;
    }

    public static long validateTypeId(long id) throws PersistenceExceptionConsistencyInvalidTypeId {
        if (id < 0L) {
            throw new PersistenceExceptionConsistencyInvalidTypeId(id);
        }
        return id;
    }

    public static final void iterateReferences(PersistenceFunction iterator, Object[] array, int offset, int length) {
        int bound = offset + length;
        int i = offset;
        while (offset < bound) {
            iterator.apply(array[i]);
            ++i;
        }
    }

    public static final void iterateReferences(PersistenceFunction iterator, XIterable<?> elements) {
        elements.iterate(iterator::apply);
    }

    public static final void iterateReferencesIterable(PersistenceFunction iterator, Iterable<?> elements) {
        for (Object element : elements) {
            iterator.apply(element);
        }
    }

    public static final void iterateReferencesMap(PersistenceFunction iterator, Map<?, ?> elements) {
        for (Map.Entry<?, ?> element : elements.entrySet()) {
            iterator.apply(element.getKey());
            iterator.apply(element.getValue());
        }
    }

    public static final Charset standardCharset() {
        return XChars.utf8();
    }

    public static String defaultFilenameTypeDictionary() {
        return "PersistenceTypeDictionary.ptd";
    }

    public static XGettingEnum<Class<?>> unpersistableTypes() {
        return UNPERSISTABLE_TYPES;
    }

    public static boolean isPersistable(Class<?> type) {
        return !Persistence.isUnpersistable(type);
    }

    public static boolean isUnpersistable(Class<?> type) {
        return XReflect.isOfAnyType(type, Persistence.unpersistableTypes());
    }

    public static final <D> PersistenceTypeMismatchValidator<D> typeMismatchValidatorFailing() {
        return PersistenceTypeMismatchValidator.Failing();
    }

    public static final <D> PersistenceTypeMismatchValidator<D> typeMismatchValidatorNoOp() {
        return PersistenceTypeMismatchValidator.NoOp();
    }

    public static final PersistenceTypeEvaluator defaultTypeEvaluatorPersistable() {
        return type -> Persistence.isPersistable(type);
    }

    public static final boolean isPersistableField(Class<?> entityType, Field field) {
        return !XReflect.isTransient((Field)field);
    }

    public static final PersistenceFieldEvaluator defaultFieldEvaluatorPersistable() {
        return Persistence::isPersistableField;
    }

    public static final PersistenceFieldEvaluator defaultFieldEvaluatorPersister() {
        return (entityType, field) -> true;
    }

    public static final boolean isPersisterField(Field field) {
        return Persister.class.isAssignableFrom(field.getType());
    }

    public static boolean isHandleableEnumField(Class<?> enumClass, Field field) {
        return true;
    }

    public static final PersistenceFieldEvaluator defaultFieldEvaluatorEnum() {
        return (entityType, field) -> Persistence.isHandleableEnumField(entityType, field);
    }

    public static boolean isHandleableCollectionField(Class<?> collectionClass, Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive()) {
            return true;
        }
        if (Comparator.class.isAssignableFrom(collectionClass)) {
            return true;
        }
        if (XReflect.isJavaUtilCollectionType(collectionClass)) {
            return true;
        }
        XGettingSet<Type> entityClassTypeVairable = Persistence.getTypeVariales(collectionClass);
        if (entityClassTypeVairable.contains((Object)field.getGenericType())) {
            return true;
        }
        if (collectionClass == Object.class) {
            return true;
        }
        if (fieldType.isArray()) {
            Class<?> componentType = fieldType.getComponentType();
            if (entityClassTypeVairable.contains(componentType)) {
                return true;
            }
            return componentType == Object.class;
        }
        return false;
    }

    public static final PersistenceFieldEvaluator defaultFieldEvaluatorCollection() {
        return (entityType, field) -> Persistence.isHandleableCollectionField(entityType, field);
    }

    private static XGettingSet<Type> getTypeVariales(Class<?> entityType) {
        Object[] tvs = entityType.getTypeParameters();
        if (tvs == null || tvs.length == 0) {
            return X.empty();
        }
        return HashEnum.New((Object[])tvs);
    }

    public static final PersistenceEagerStoringFieldEvaluator defaultReferenceFieldEagerEvaluator() {
        return (entityType, field) -> false;
    }

    public static <T> Class<T> resolveEnumeratedClassIdentifierSeparatedType(String typeName, ClassLoader classLoader, String substituteClassIdentifierSeparator) {
        int sepIndex = typeName.indexOf(substituteClassIdentifierSeparator);
        if (sepIndex < 0) {
            return null;
        }
        String properTypeName = typeName.substring(0, sepIndex);
        Class<T> type = Persistence.resolveType(properTypeName, classLoader, substituteClassIdentifierSeparator);
        if (!XReflect.isDeclaredEnum(type)) {
            throw new UnsupportedOperationException("EnumeratedClassIdentifierNaming is only supported for sub enums");
        }
        String enumConstantName = typeName.substring(sepIndex + substituteClassIdentifierSeparator.length());
        T enumConstant = Enum.valueOf(type, enumConstantName);
        return enumConstant.getClass();
    }

    public static <T> Class<T> resolveType(String typeName, ClassLoader classLoader) {
        return Persistence.resolveType(typeName, classLoader, Persistence.substituteClassIdentifierSeparator());
    }

    public static <T> Class<T> resolveType(String typeName, ClassLoader classLoader, String substituteClassIdentifierSeparator) {
        Class<T> c = Persistence.resolveEnumeratedClassIdentifierSeparatedType(typeName, classLoader, substituteClassIdentifierSeparator);
        if (c != null) {
            return c;
        }
        try {
            return XReflect.resolveType((String)typeName, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceExceptionTypeConsistencyDefinitionResolveTypeName(typeName, e);
        }
    }

    public static <T> Class<T> tryResolveType(String typeName, ClassLoader classLoader) {
        try {
            return Persistence.resolveType(typeName, classLoader);
        }
        catch (PersistenceExceptionTypeConsistencyDefinitionResolveTypeName e) {
            return null;
        }
    }

    public static String deriveEnumRootIdentifier(PersistenceTypeHandler<?, ?> typeHandler) {
        XReflect.validateIsEnum(typeHandler.type());
        if (Swizzling.isNotProperId((long)typeHandler.typeId())) {
            throw new PersistenceException("Type handler not initialized for type " + typeHandler.type() + ". This is probably caused by a missing type dictionary entry for that type.");
        }
        return XReflect.typename_enum() + " " + typeHandler.typeId();
    }

    public static Object[] collectEnumConstants(PersistenceTypeHandler<?, ?> typeHandler) {
        XReflect.validateIsEnum(typeHandler.type());
        ?[] enumConstants = typeHandler.type().getEnumConstants();
        Object[] copy = new Object[enumConstants.length];
        System.arraycopy(enumConstants, 0, copy, 0, enumConstants.length);
        return copy;
    }

    public static String enumRootIdentifierStart() {
        return ENUM_ROOT_IDENTIFIER_START;
    }

    public static Long parseEnumRootIdentifierTypeId(String enumRootIdentifier) {
        if (!Persistence.isEnumRootIdentifier(enumRootIdentifier)) {
            return null;
        }
        String typeIdPart = enumRootIdentifier.substring(Persistence.enumRootIdentifierStart().length());
        try {
            return Long.parseLong(typeIdPart);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isEnumRootIdentifier(String enumRootIdentifier) {
        return Persistence.isPotentialEnumRootIdentifier(enumRootIdentifier) && XChars.applies((CharSequence)enumRootIdentifier, (int)Persistence.enumRootIdentifierStart().length(), XChars::isDigit);
    }

    public static boolean isPotentialEnumRootIdentifier(String enumRootIdentifier) {
        return enumRootIdentifier != null && enumRootIdentifier.startsWith(Persistence.enumRootIdentifierStart());
    }

    @Deprecated
    public static final String defaultRootIdentifier() {
        return "defaultRoot";
    }

    @Deprecated
    public static final String customRootIdentifier() {
        return "root";
    }

    public static final String rootIdentifier() {
        return "ROOT";
    }

    public static final PersistenceRefactoringMappingProvider RefactoringMapping(Path refactoringsFile) {
        return Persistence.RefactoringMapping(Persistence.readRefactoringMappings(refactoringsFile));
    }

    public static final PersistenceRefactoringMappingProvider RefactoringMapping(String refactoringMappings) {
        return Persistence.RefactoringMapping(Persistence.readRefactoringMappings(refactoringMappings));
    }

    public static final PersistenceRefactoringMappingProvider RefactoringMapping(String refactoringMappings, char valueSeparator) {
        return Persistence.RefactoringMapping(Persistence.readRefactoringMappings(refactoringMappings, valueSeparator));
    }

    public static final PersistenceRefactoringMappingProvider RefactoringMapping(String refactoringMappings, XCsvDataType dataType) {
        return Persistence.RefactoringMapping(Persistence.readRefactoringMappings(refactoringMappings, dataType));
    }

    public static final PersistenceRefactoringMappingProvider RefactoringMapping(String refactoringMappings, XCsvConfiguration configuration) {
        return Persistence.RefactoringMapping(Persistence.readRefactoringMappings(refactoringMappings, configuration));
    }

    public static final PersistenceRefactoringMappingProvider RefactoringMapping(XGettingSequence<KeyValue<String, String>> refactoringMappings) {
        return PersistenceRefactoringMappingProvider.New(refactoringMappings);
    }

    public static XGettingSequence<KeyValue<String, String>> readRefactoringMappings(Path file) {
        StringTable stringTable = XCSV.readFromFile((Path)file);
        return Persistence.parseRefactoringMappings(stringTable);
    }

    public static XGettingSequence<KeyValue<String, String>> readRefactoringMappings(AFile file) {
        String fileSuffix = XIO.getFileSuffix((String)file.identifier());
        String normalized = fileSuffix == null ? null : fileSuffix.trim().toLowerCase();
        XCsvDataType dataType = XCsvDataType.fromIdentifier((String)normalized);
        String fileContent = AFS.readString((AFile)file);
        StringTable stringTable = XCSV.parse((String)fileContent, (XCsvDataType)dataType);
        return Persistence.parseRefactoringMappings(stringTable);
    }

    public static XGettingSequence<KeyValue<String, String>> readRefactoringMappings(String string) {
        StringTable stringTable = XCSV.parse((String)string);
        return Persistence.parseRefactoringMappings(stringTable);
    }

    public static XGettingSequence<KeyValue<String, String>> readRefactoringMappings(String string, char valueSeparator) {
        StringTable stringTable = XCSV.parse((String)string, (char)valueSeparator);
        return Persistence.parseRefactoringMappings(stringTable);
    }

    public static XGettingSequence<KeyValue<String, String>> readRefactoringMappings(String string, XCsvDataType dataType) {
        StringTable stringTable = XCSV.parse((String)string, (XCsvDataType)dataType);
        return Persistence.parseRefactoringMappings(stringTable);
    }

    public static XGettingSequence<KeyValue<String, String>> readRefactoringMappings(String string, XCsvConfiguration configuration) {
        StringTable stringTable = XCSV.parse((String)string, (XCsvConfiguration)configuration);
        return Persistence.parseRefactoringMappings(stringTable);
    }

    public static XGettingSequence<KeyValue<String, String>> parseRefactoringMappings(StringTable stringTable) {
        BulkList entries = BulkList.New((long)stringTable.rows().size());
        stringTable.mapTo((k, v) -> entries.add((Object)X.KeyValue((Object)k, (Object)v)), row -> XChars.trimEmptyToNull((String)row[0]), row -> XChars.trimEmptyToNull((String)row[1]));
        return entries;
    }

    public static final String substituteClassIdentifierSeparator() {
        return "$\u00a7";
    }

    public static final String derivePersistentTypeName(Class<?> type) {
        return Persistence.derivePersistentTypeName(type, Persistence.substituteClassIdentifierSeparator());
    }

    public static final String derivePersistentTypeName(Class<?> type, String substituteClassIdentifierSeparator) {
        if (XReflect.isSubEnum(type)) {
            return Persistence.derivePersistentTypeNameEnum(type, substituteClassIdentifierSeparator);
        }
        if (XReflect.hasEnumeratedTypeName(type)) {
            throw new PersistenceExceptionTypeNotPersistable(type, "Synthetic classes ($1 etc.) are not reliably persistable since a simple reordering of source code elements would change the name identity of a class. For a type system that has to rely upon resolving types by their identifying name, this would silently cause a potentially fatal error. If handling synthetic classes (e.g. anonymous inner classes) is absolutely necessary, a custom " + PersistenceTypeResolver.class.getName() + " can be used to remove the exception and assume  complete responsibility for correctly handling synthetic class names.");
        }
        return type.getName();
    }

    public static final String derivePersistentTypeNameEnum(Class<?> type, String substituteClassIdentifierSeparator) {
        if (!XReflect.isSubEnum(type)) {
            throw new PersistenceException("Not an Enum type: " + type.getName());
        }
        X.notNull((Object)substituteClassIdentifierSeparator);
        Class declaredEnumType = XReflect.getDeclaredEnumClass(type);
        for (Object enumConstant : declaredEnumType.getEnumConstants()) {
            if (enumConstant.getClass() != type) continue;
            return declaredEnumType.getName() + substituteClassIdentifierSeparator + ((Enum)enumConstant).name();
        }
        throw new PersistenceException("Orphan sub enum type: " + type.getName());
    }

    public static <D, T> PersistenceTypeHandler<D, T> searchProvidedTypeHandler(Class<D> dataType, Class<T> entityType, Predicate<? super Method> selector) throws ReflectiveOperationException {
        for (Method m : entityType.getDeclaredMethods()) {
            if (!XReflect.isStatic((Member)m) || m.getParameterCount() != 0 || !PersistenceTypeHandler.class.isAssignableFrom(m.getReturnType())) continue;
            m.setAccessible(true);
            PersistenceTypeHandler providedTypeHandler = (PersistenceTypeHandler)m.invoke(null, new Object[0]);
            if (providedTypeHandler.dataType() != dataType || providedTypeHandler.type() != entityType || selector != null && !selector.test(m)) continue;
            PersistenceTypeHandler applicableTypeHandler = providedTypeHandler;
            return applicableTypeHandler;
        }
        return null;
    }

    protected Persistence() {
        throw new UnsupportedOperationException();
    }

    static {
        NATIVE_TYPES.add(Byte.TYPE, (Object)1L);
        NATIVE_TYPES.add(Boolean.TYPE, (Object)2L);
        NATIVE_TYPES.add(Short.TYPE, (Object)3L);
        NATIVE_TYPES.add(Character.TYPE, (Object)4L);
        NATIVE_TYPES.add(Integer.TYPE, (Object)5L);
        NATIVE_TYPES.add(Float.TYPE, (Object)6L);
        NATIVE_TYPES.add(Long.TYPE, (Object)7L);
        NATIVE_TYPES.add(Double.TYPE, (Object)8L);
        NATIVE_TYPES.add(Void.TYPE, (Object)9L);
        NATIVE_TYPES.add(Object.class, (Object)10L);
        NATIVE_TYPES.add(Number.class, (Object)36L);
        NATIVE_TYPES.add(Byte.class, (Object)11L);
        NATIVE_TYPES.add(Boolean.class, (Object)12L);
        NATIVE_TYPES.add(Short.class, (Object)13L);
        NATIVE_TYPES.add(Character.class, (Object)14L);
        NATIVE_TYPES.add(Integer.class, (Object)15L);
        NATIVE_TYPES.add(Float.class, (Object)16L);
        NATIVE_TYPES.add(Long.class, (Object)17L);
        NATIVE_TYPES.add(Double.class, (Object)18L);
        NATIVE_TYPES.add(Void.class, (Object)19L);
        NATIVE_TYPES.add(Class.class, (Object)20L);
        NATIVE_TYPES.add(Enum.class, (Object)21L);
        NATIVE_TYPES.add(String.class, (Object)30L);
        NATIVE_TYPES.add(StringBuffer.class.getSuperclass(), (Object)31L);
        NATIVE_TYPES.add(StringBuffer.class, (Object)32L);
        NATIVE_TYPES.add(StringBuilder.class, (Object)33L);
        NATIVE_TYPES.add(File.class, (Object)34L);
        NATIVE_TYPES.add(Date.class, (Object)35L);
        NATIVE_TYPES.add(Number.class, (Object)36L);
        NATIVE_TYPES.add(BigInteger.class, (Object)37L);
        NATIVE_TYPES.add(BigDecimal.class, (Object)38L);
        NATIVE_TYPES.add(ArrayList.class.getSuperclass().getSuperclass(), (Object)40L);
        NATIVE_TYPES.add(ArrayList.class.getSuperclass(), (Object)41L);
        NATIVE_TYPES.add(HashSet.class.getSuperclass(), (Object)42L);
        NATIVE_TYPES.add(ArrayList.class, (Object)43L);
        NATIVE_TYPES.add(HashSet.class, (Object)44L);
        NATIVE_TYPES.add(AbstractMap.class, (Object)45L);
        NATIVE_TYPES.add(HashMap.class, (Object)46L);
        NATIVE_TYPES.add(Dictionary.class, (Object)47L);
        NATIVE_TYPES.add(Hashtable.class, (Object)48L);
        NATIVE_TYPES.add(ArrayDeque.class, (Object)49L);
        NATIVE_TYPES.add(IdentityHashMap.class, (Object)50L);
        NATIVE_TYPES.add(LinkedHashMap.class, (Object)51L);
        NATIVE_TYPES.add(LinkedHashSet.class, (Object)52L);
        NATIVE_TYPES.add(AbstractSequentialList.class, (Object)53L);
        NATIVE_TYPES.add(LinkedList.class, (Object)54L);
        NATIVE_TYPES.add(AbstractQueue.class, (Object)55L);
        NATIVE_TYPES.add(PriorityQueue.class, (Object)56L);
        NATIVE_TYPES.add(TreeMap.class, (Object)57L);
        NATIVE_TYPES.add(TreeSet.class, (Object)58L);
        NATIVE_TYPES.add(Vector.class, (Object)59L);
        NATIVE_TYPES.add(Stack.class, (Object)60L);
        NATIVE_TYPES.add(Properties.class, (Object)61L);
        NATIVE_TYPES.add(ConcurrentHashMap.class, (Object)62L);
        NATIVE_TYPES.add(ConcurrentLinkedDeque.class, (Object)63L);
        NATIVE_TYPES.add(ConcurrentLinkedQueue.class, (Object)64L);
        NATIVE_TYPES.add(ConcurrentSkipListMap.class, (Object)65L);
        NATIVE_TYPES.add(ConcurrentSkipListSet.class, (Object)66L);
        NATIVE_TYPES.add(Locale.class, (Object)68L);
        NATIVE_TYPES.add(byte[].class, (Object)101L);
        NATIVE_TYPES.add(boolean[].class, (Object)102L);
        NATIVE_TYPES.add(short[].class, (Object)103L);
        NATIVE_TYPES.add(char[].class, (Object)104L);
        NATIVE_TYPES.add(int[].class, (Object)105L);
        NATIVE_TYPES.add(float[].class, (Object)106L);
        NATIVE_TYPES.add(long[].class, (Object)107L);
        NATIVE_TYPES.add(double[].class, (Object)108L);
        NATIVE_TYPES.add(Class[].class, (Object)120L);
        NATIVE_TYPES.add(Byte[].class, (Object)111L);
        NATIVE_TYPES.add(Boolean[].class, (Object)112L);
        NATIVE_TYPES.add(Short[].class, (Object)113L);
        NATIVE_TYPES.add(Character[].class, (Object)114L);
        NATIVE_TYPES.add(Integer[].class, (Object)115L);
        NATIVE_TYPES.add(Float[].class, (Object)116L);
        NATIVE_TYPES.add(Long[].class, (Object)117L);
        NATIVE_TYPES.add(Double[].class, (Object)118L);
        NATIVE_TYPES.add(Void[].class, (Object)119L);
        NATIVE_TYPES.add(Object[].class, (Object)110L);
        NATIVE_TYPES.add(String[].class, (Object)130L);
        NATIVE_TYPES.add(StringBuffer[].class, (Object)132L);
        NATIVE_TYPES.add(StringBuilder[].class, (Object)133L);
        NATIVE_TYPES.add(Enum[].class, (Object)121L);
        NATIVE_TYPES.add(Lazy.Default.class, (Object)10000L);
        UNPERSISTABLE_TYPES = ConstHashEnum.New((Object[])new Class[]{Unpersistable.class, ClassLoader.class, Thread.class, InputStream.class, OutputStream.class, FileChannel.class, Socket.class, ServerSocket.class, Composition.class, ChainStorage.class, ChainStorage.Entry.class, Map.Entry.class, new LinkedList().subList(0, 0).getClass(), new ArrayList(0).subList(0, 0).getClass(), Collections.emptyList().subList(0, 0).getClass(), new CopyOnWriteArrayList().subList(0, 0).getClass(), Enumeration.class, Iterator.class, Reference.class, Throwable.class});
        ENUM_ROOT_IDENTIFIER_START = XReflect.typename_enum() + " ";
    }

    public static enum IdType {
        NULL{

            @Override
            public boolean isInRange(long id) {
                return Swizzling.isNullId((long)id);
            }
        }
        ,
        TID{

            @Override
            public boolean isInRange(long id) {
                return id >= 1L && id < 1000000000000000000L;
            }
        }
        ,
        OID{

            @Override
            public boolean isInRange(long id) {
                return id >= 1000000000000000001L && id < 9000000000000000000L;
            }
        }
        ,
        CID{

            @Override
            public boolean isInRange(long id) {
                return id >= 9000000000000000001L && id < 9100000000000000000L;
            }
        }
        ,
        UNDEFINED{

            @Override
            public boolean isInRange(long id) {
                return id < 0L || id >= 9100000000000000000L;
            }
        };


        public boolean isInRange(long id) {
            return true;
        }

        public static IdType determineFromValue(long id) {
            return id >= 1000000000000000001L ? (id >= 9000000000000000001L ? (id >= 9100000000000000000L ? UNDEFINED : CID) : OID) : (id >= 1L ? TID : (Swizzling.isNullId((long)id) ? NULL : UNDEFINED));
        }
    }
}

