/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.collections.HashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerIterable;

public interface PersistenceCustomTypeHandlerRegistry<D>
extends PersistenceTypeHandlerIterable<D> {
    public <T> boolean registerTypeHandler(PersistenceTypeHandler<D, T> var1);

    public <T> boolean registerTypeHandler(Class<T> var1, PersistenceTypeHandler<D, ? super T> var2);

    public <T> boolean registerLegacyTypeHandler(PersistenceLegacyTypeHandler<D, T> var1);

    public PersistenceCustomTypeHandlerRegistry<D> registerLegacyTypeHandlers(XGettingCollection<? extends PersistenceLegacyTypeHandler<D, ?>> var1);

    public PersistenceCustomTypeHandlerRegistry<D> registerTypeHandlers(XGettingCollection<? extends PersistenceTypeHandler<D, ?>> var1);

    public <T> PersistenceTypeHandler<D, ? super T> lookupTypeHandler(Class<T> var1);

    public XGettingEnum<PersistenceLegacyTypeHandler<D, ?>> legacyTypeHandlers();

    public boolean knowsType(Class<?> var1);

    public static <D> Default<D> New() {
        return new Default();
    }

    public static final class Default<D>
    implements PersistenceCustomTypeHandlerRegistry<D> {
        private final HashTable<Class<?>, PersistenceTypeHandler<D, ?>> liveTypeHandlers = HashTable.New();
        private final HashEnum<PersistenceLegacyTypeHandler<D, ?>> legacyTypeHandlers = HashEnum.New();

        Default() {
        }

        @Override
        public synchronized boolean knowsType(Class<?> type) {
            return this.liveTypeHandlers.keys().contains(type);
        }

        @Override
        public final <T> boolean registerTypeHandler(Class<T> type, PersistenceTypeHandler<D, ? super T> typeHandlerInitializer) {
            typeHandlerInitializer.validateEntityType(type);
            return this.internalRegisterTypeHandler(type, typeHandlerInitializer);
        }

        @Override
        public <T> boolean registerTypeHandler(PersistenceTypeHandler<D, T> typeHandlerInitializer) {
            return this.internalRegisterTypeHandler(typeHandlerInitializer.type(), typeHandlerInitializer);
        }

        final synchronized <T> boolean internalRegisterTypeHandler(Class<T> type, PersistenceTypeHandler<D, ? super T> typeHandlerInitializer) {
            return this.liveTypeHandlers.put((Object)((Class)X.notNull(type)), (Object)((PersistenceTypeHandler)X.notNull(typeHandlerInitializer)));
        }

        @Override
        public synchronized Default<D> registerTypeHandlers(XGettingCollection<? extends PersistenceTypeHandler<D, ?>> typeHandlerInitializers) {
            for (PersistenceTypeHandler th : typeHandlerInitializers) {
                this.registerTypeHandler(th);
            }
            return this;
        }

        @Override
        public synchronized <T> boolean registerLegacyTypeHandler(PersistenceLegacyTypeHandler<D, T> legacyTypeHandler) {
            return this.legacyTypeHandlers.add(legacyTypeHandler);
        }

        @Override
        public synchronized PersistenceCustomTypeHandlerRegistry<D> registerLegacyTypeHandlers(XGettingCollection<? extends PersistenceLegacyTypeHandler<D, ?>> legacyTypeHandlers) {
            for (PersistenceLegacyTypeHandler lth : legacyTypeHandlers) {
                this.registerLegacyTypeHandler(lth);
            }
            return this;
        }

        private <T> PersistenceTypeHandler<D, T> internalLookupTypeHandler(Class<T> type) {
            return (PersistenceTypeHandler)this.liveTypeHandlers.get(type);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> lookupTypeHandler(Class<T> type) {
            return this.internalLookupTypeHandler(type);
        }

        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateTypeHandlers(C iterator) {
            this.liveTypeHandlers.values().iterate(iterator);
            return iterator;
        }

        @Override
        public <C extends Consumer<? super PersistenceLegacyTypeHandler<D, ?>>> C iterateLegacyTypeHandlers(C iterator) {
            return (C)this.legacyTypeHandlers().iterate(iterator);
        }

        @Override
        public final XGettingEnum<PersistenceLegacyTypeHandler<D, ?>> legacyTypeHandlers() {
            return this.legacyTypeHandlers;
        }
    }
}

