/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.lang.reflect.Field;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.reflect.XReflect;

public interface PersistenceFieldLengthResolver {
    default public long resolveMinimumLengthFromField(Field t) {
        return this.resolveMinimumLengthFromType(t.getType());
    }

    default public long resolveMaximumLengthFromField(Field t) {
        return this.resolveMaximumLengthFromType(t.getType());
    }

    default public long resolveMinimumLengthFromDictionary(String declaringTypeName, String memberName, String typeName) {
        if (PersistenceTypeDictionary.isVariableLength(typeName)) {
            return this.variableLengthTypeMinimumLength(declaringTypeName, memberName, typeName);
        }
        if (XReflect.isPrimitiveTypeName((String)typeName)) {
            return this.resolveMinimumLengthFromPrimitiveType(XReflect.tryResolvePrimitiveType((String)typeName));
        }
        return this.referenceMinimumLength();
    }

    default public long resolveMaximumLengthFromDictionary(String declaringTypeName, String memberName, String typeName) {
        if (PersistenceTypeDictionary.isVariableLength(typeName)) {
            return this.variableLengthTypeMaximumLength(declaringTypeName, memberName, typeName);
        }
        if (XReflect.isPrimitiveTypeName((String)typeName)) {
            return this.resolveMaximumLengthFromPrimitiveType(XReflect.tryResolvePrimitiveType((String)typeName));
        }
        return this.referenceMaximumLength();
    }

    default public long resolveMinimumLengthFromType(Class<?> type) {
        return type.isPrimitive() ? this.resolveMinimumLengthFromPrimitiveType(type) : this.referenceMinimumLength();
    }

    default public long resolveMaximumLengthFromType(Class<?> type) {
        return type.isPrimitive() ? this.resolveMaximumLengthFromPrimitiveType(type) : this.referenceMaximumLength();
    }

    default public long referenceMinimumLength() {
        return this.resolveMinimumLengthFromPrimitiveType(Persistence.objectIdType());
    }

    default public long referenceMaximumLength() {
        return this.resolveMinimumLengthFromPrimitiveType(Persistence.objectIdType());
    }

    public long variableLengthTypeMinimumLength(String var1, String var2, String var3);

    public long variableLengthTypeMaximumLength(String var1, String var2, String var3);

    public long resolveMinimumLengthFromPrimitiveType(Class<?> var1);

    public long resolveMaximumLengthFromPrimitiveType(Class<?> var1);

    public long resolveComplexMemberMinimumLength(String var1, String var2, XGettingSequence<? extends PersistenceTypeDescriptionMemberFieldGeneric> var3);

    public long resolveComplexMemberMaximumLength(String var1, String var2, XGettingSequence<? extends PersistenceTypeDescriptionMemberFieldGeneric> var3);
}

