/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.chars.ObjectStringConverter;
import one.microstream.chars.VarString;
import one.microstream.chars.XParsing;
import one.microstream.chars._charArrayRange;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XImmutableMap;
import one.microstream.collections.types.XReference;
import one.microstream.exceptions.ParsingException;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceIdStrategy;
import one.microstream.persistence.types.PersistenceObjectIdStrategy;
import one.microstream.persistence.types.PersistenceTypeIdStrategy;
import one.microstream.typing.KeyValue;

public interface PersistenceIdStrategyStringConverter
extends ObjectStringConverter<PersistenceIdStrategy> {
    public VarString assemble(VarString var1, PersistenceIdStrategy var2);

    default public VarString provideAssemblyBuffer() {
        return super.provideAssemblyBuffer();
    }

    default public String assemble(PersistenceIdStrategy subject) {
        return super.assemble((Object)subject);
    }

    public PersistenceIdStrategy parse(_charArrayRange var1);

    default public PersistenceIdStrategy parse(String input) {
        return (PersistenceIdStrategy)super.parse(input);
    }

    public static void validateIdStrategyName(Class<?> idStrategyType, String idStrategyName, String idStrategyContent) throws ParsingException {
        if (idStrategyContent.startsWith(idStrategyName)) {
            return;
        }
        throw new ParsingException("Invalid id strategy content for type name \"" + idStrategyName + "\" of type " + idStrategyType.getName() + ": " + idStrategyContent);
    }

    public static Creator Creator() {
        return new Creator.Default();
    }

    public static PersistenceIdStrategyStringConverter New() {
        return PersistenceIdStrategyStringConverter.Creator().register(PersistenceObjectIdStrategy.Transient.class, PersistenceObjectIdStrategy.Transient::assemble).register(PersistenceObjectIdStrategy.Transient.typeName(), PersistenceObjectIdStrategy.Transient::parse).register(PersistenceObjectIdStrategy.None.class, PersistenceObjectIdStrategy.None::assemble).register(PersistenceObjectIdStrategy.None.typeName(), PersistenceObjectIdStrategy.None::parse).register(PersistenceTypeIdStrategy.Transient.class, PersistenceTypeIdStrategy.Transient::assemble).register(PersistenceTypeIdStrategy.Transient.typeName(), PersistenceTypeIdStrategy.Transient::parse).register(PersistenceTypeIdStrategy.None.class, PersistenceTypeIdStrategy.None::assemble).register(PersistenceTypeIdStrategy.None.typeName(), PersistenceTypeIdStrategy.None::parse).create();
    }

    public static final class Default
    implements PersistenceIdStrategyStringConverter {
        final XImmutableMap<Class<?>, PersistenceObjectIdStrategy.Assembler<?>> oidsAssemblers;
        final XImmutableMap<Class<?>, PersistenceTypeIdStrategy.Assembler<?>> tidsAssemblers;
        final XImmutableMap<String, PersistenceObjectIdStrategy.Parser<?>> oidsParsers;
        final XImmutableMap<String, PersistenceTypeIdStrategy.Parser<?>> tidsParsers;

        public static String labelType() {
            return "Type";
        }

        public static String labelObject() {
            return "Object";
        }

        public static char typeAssigner() {
            return ':';
        }

        public static char separator() {
            return ',';
        }

        public static char quote() {
            return '\'';
        }

        public Default(XImmutableMap<Class<?>, PersistenceObjectIdStrategy.Assembler<?>> oidsAssemblers, XImmutableMap<Class<?>, PersistenceTypeIdStrategy.Assembler<?>> tidsAssemblers, XImmutableMap<String, PersistenceObjectIdStrategy.Parser<?>> oidsParsers, XImmutableMap<String, PersistenceTypeIdStrategy.Parser<?>> tidsParsers) {
            this.oidsAssemblers = oidsAssemblers;
            this.tidsAssemblers = tidsAssemblers;
            this.oidsParsers = oidsParsers;
            this.tidsParsers = tidsParsers;
        }

        private <S extends PersistenceObjectIdStrategy> PersistenceObjectIdStrategy.Assembler<S> lookupObjectIdStrategyAssembler(Class<?> type) {
            PersistenceObjectIdStrategy.Assembler assembler = (PersistenceObjectIdStrategy.Assembler)this.oidsAssemblers.get(type);
            return assembler;
        }

        private <S extends PersistenceTypeIdStrategy> PersistenceTypeIdStrategy.Assembler<S> lookupTypeIdStrategyAssembler(Class<?> type) {
            PersistenceTypeIdStrategy.Assembler assembler = (PersistenceTypeIdStrategy.Assembler)this.tidsAssemblers.get(type);
            return assembler;
        }

        private <S extends PersistenceObjectIdStrategy> void assembleObjectIdStrategy(VarString vs, S idStrategy) {
            PersistenceObjectIdStrategy.Assembler<S> assembler = this.lookupObjectIdStrategyAssembler(idStrategy.getClass());
            assembler.assembleIdStrategy(vs, idStrategy);
        }

        private <S extends PersistenceTypeIdStrategy> void assembleTypeIdStrategy(VarString vs, S idStrategy) {
            PersistenceTypeIdStrategy.Assembler<S> assembler = this.lookupTypeIdStrategyAssembler(idStrategy.getClass());
            assembler.assembleIdStrategy(vs, idStrategy);
        }

        @Override
        public VarString assemble(VarString vs, PersistenceIdStrategy idStrategy) {
            vs.add(Default.labelType()).add(Default.typeAssigner()).add(Default.quote()).apply(v -> this.assembleTypeIdStrategy((VarString)v, (PersistenceTypeIdStrategy)idStrategy.typeIdStragegy())).add(Default.quote()).add(Default.separator()).blank().add(Default.labelObject()).add(Default.typeAssigner()).add(Default.quote()).apply(v -> this.assembleObjectIdStrategy((VarString)v, (PersistenceObjectIdStrategy)idStrategy.objectIdStragegy())).add(Default.quote());
            return vs;
        }

        @Override
        public PersistenceIdStrategy parse(_charArrayRange input) {
            XReference tidsContent = X.Reference(null);
            XReference oidsContent = X.Reference(null);
            Default.parseContent(input, (XReference<String>)tidsContent, (XReference<String>)oidsContent);
            PersistenceTypeIdStrategy.Parser<?> tidsParser = this.lookupTypeIdStrategyParser((String)tidsContent.get());
            PersistenceObjectIdStrategy.Parser<?> oidsParser = this.lookupObjectIdStrategyParser((String)oidsContent.get());
            Object tidStrategy = tidsParser.parse((String)tidsContent.get());
            Object oidStrategy = oidsParser.parse((String)oidsContent.get());
            return PersistenceIdStrategy.New(oidStrategy, tidStrategy);
        }

        private static void parseContent(_charArrayRange inputRange, XReference<String> tidsContent, XReference<String> oidsContent) {
            char[] input = inputRange.array();
            int iBound = XParsing.skipWhiteSpacesReversed((char[])input, (int)inputRange.start(), (int)inputRange.bound()) + 1;
            int iTypeEnd = Default.parsePart(input, inputRange.start(), iBound, Default.labelType(), tidsContent);
            XParsing.checkIncompleteInput((int)iTypeEnd, (int)iBound);
            XParsing.checkCharacter((char[])input, (int)iTypeEnd, (char)Default.separator(), (String)"IdStrategy");
            Default.parsePart(input, iTypeEnd + 1, iBound, Default.labelObject(), oidsContent);
        }

        private static int parsePart(char[] input, int iStart, int iBound, String label, XReference<String> contentHolder) {
            int i = iStart;
            i = XParsing.skipWhiteSpaces((char[])input, (int)i, (int)iBound);
            XParsing.checkIncompleteInput((int)i, (int)iBound);
            i = Default.checkStartsWith(input, i, iBound, label);
            i = XParsing.skipWhiteSpaces((char[])input, (int)i, (int)iBound);
            XParsing.checkIncompleteInput((int)i, (int)iBound);
            i = XParsing.checkCharacter((char[])input, (int)i, (char)Default.typeAssigner(), (String)label);
            i = XParsing.skipWhiteSpaces((char[])input, (int)i, (int)iBound);
            XParsing.checkIncompleteInput((int)i, (int)iBound);
            XParsing.checkCharacter((char[])input, (int)i, (char)Default.quote(), (String)label);
            i = XParsing.parseSimpleQuote((char[])input, (int)i, (int)iBound, contentHolder);
            i = XParsing.skipWhiteSpaces((char[])input, (int)i, (int)iBound);
            return i;
        }

        private static int checkStartsWith(char[] input, int i, int iBound, String label) {
            if (XParsing.startsWith((char[])input, (int)i, (int)iBound, (String)label)) {
                return i + label.length();
            }
            throw new PersistenceException("IdStrategy type label \"" + label + "\" not found at index " + i + ".");
        }

        private PersistenceTypeIdStrategy.Parser<?> lookupTypeIdStrategyParser(String content) {
            for (KeyValue e : this.tidsParsers) {
                if (!content.startsWith((String)e.key())) continue;
                return (PersistenceTypeIdStrategy.Parser)e.value();
            }
            throw new PersistenceException("Unknown TypeIdStrategy: \"" + content + "\".");
        }

        private PersistenceObjectIdStrategy.Parser<?> lookupObjectIdStrategyParser(String content) {
            for (KeyValue e : this.oidsParsers) {
                if (!content.startsWith((String)e.key())) continue;
                return (PersistenceObjectIdStrategy.Parser)e.value();
            }
            throw new PersistenceException("Unknown ObjectIdStrategy: \"" + content + "\".");
        }
    }

    public static interface Creator {
        public <S extends PersistenceObjectIdStrategy> Creator register(Class<S> var1, PersistenceObjectIdStrategy.Assembler<S> var2);

        public <S extends PersistenceTypeIdStrategy> Creator register(Class<S> var1, PersistenceTypeIdStrategy.Assembler<S> var2);

        public <S extends PersistenceObjectIdStrategy> Creator register(String var1, PersistenceObjectIdStrategy.Parser<S> var2);

        public <S extends PersistenceTypeIdStrategy> Creator register(String var1, PersistenceTypeIdStrategy.Parser<S> var2);

        public PersistenceIdStrategyStringConverter create();

        public static final class Default
        implements Creator {
            private final HashTable<Class<?>, PersistenceObjectIdStrategy.Assembler<?>> oidAssemblers = HashTable.New();
            private final HashTable<Class<?>, PersistenceTypeIdStrategy.Assembler<?>> tidAssemblers = HashTable.New();
            private final EqHashTable<String, PersistenceObjectIdStrategy.Parser<?>> oidParsers = EqHashTable.New();
            private final EqHashTable<String, PersistenceTypeIdStrategy.Parser<?>> tidParsers = EqHashTable.New();

            Default() {
            }

            @Override
            public synchronized <S extends PersistenceObjectIdStrategy> Default register(Class<S> objectIdStrategyType, PersistenceObjectIdStrategy.Assembler<S> assembler) {
                this.oidAssemblers.put((Object)((Class)X.notNull(objectIdStrategyType)), (Object)((PersistenceObjectIdStrategy.Assembler)X.notNull(assembler)));
                return this;
            }

            @Override
            public synchronized <S extends PersistenceTypeIdStrategy> Default register(Class<S> typeIdStrategyType, PersistenceTypeIdStrategy.Assembler<S> assembler) {
                this.tidAssemblers.put((Object)((Class)X.notNull(typeIdStrategyType)), (Object)((PersistenceTypeIdStrategy.Assembler)X.notNull(assembler)));
                return this;
            }

            @Override
            public synchronized <S extends PersistenceObjectIdStrategy> Creator register(String strategyTypeName, PersistenceObjectIdStrategy.Parser<S> parser) {
                this.oidParsers.put((Object)((String)X.notNull((Object)strategyTypeName)), (Object)((PersistenceObjectIdStrategy.Parser)X.notNull(parser)));
                return this;
            }

            @Override
            public synchronized <S extends PersistenceTypeIdStrategy> Creator register(String strategyTypeName, PersistenceTypeIdStrategy.Parser<S> parser) {
                this.tidParsers.put((Object)((String)X.notNull((Object)strategyTypeName)), (Object)((PersistenceTypeIdStrategy.Parser)X.notNull(parser)));
                return this;
            }

            @Override
            public final synchronized PersistenceIdStrategyStringConverter create() {
                return new one.microstream.persistence.types.PersistenceIdStrategyStringConverter$Default((XImmutableMap<Class<?>, PersistenceObjectIdStrategy.Assembler<?>>)this.oidAssemblers.immure(), (XImmutableMap<Class<?>, PersistenceTypeIdStrategy.Assembler<?>>)this.tidAssemblers.immure(), (XImmutableMap<String, PersistenceObjectIdStrategy.Parser<?>>)this.oidParsers.immure(), (XImmutableMap<String, PersistenceTypeIdStrategy.Parser<?>>)this.tidParsers.immure());
            }
        }
    }
}

