/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.collections.HashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XEnum;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingSet;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XTable;
import one.microstream.persistence.types.PersistenceLegacyTypeMapper;
import one.microstream.persistence.types.PersistenceLegacyTypeMappingResult;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.typing.KeyValue;
import one.microstream.util.similarity.MultiMatch;
import one.microstream.util.similarity.Similarity;

public interface PersistenceLegacyTypeMappingResultor<D> {
    default public <T> PersistenceLegacyTypeMappingResult<D, T> createMappingResult(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, XGettingSet<PersistenceTypeDefinitionMember> explicitNewMembers, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers) {
        return PersistenceLegacyTypeMappingResultor.createLegacyTypeMappingResult(legacyTypeDefinition, currentTypeHandler, explicitMappings, explicitNewMembers, matchedMembers);
    }

    public static <D, T> PersistenceLegacyTypeMappingResult<D, T> createLegacyTypeMappingResult(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, XGettingSet<PersistenceTypeDefinitionMember> explicitNewMembers, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers) {
        HashTable legacyToCurrentMembers = HashTable.New();
        HashTable currentToLegacyMembers = HashTable.New();
        HashEnum discardedLegacyMembers = HashEnum.New();
        HashEnum newCurrentMembers = HashEnum.New();
        PersistenceLegacyTypeMappingResultor.combineMappings((XTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)legacyToCurrentMembers, (XTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)currentToLegacyMembers, (XEnum<PersistenceTypeDefinitionMember>)discardedLegacyMembers, (XEnum<PersistenceTypeDefinitionMember>)newCurrentMembers, legacyTypeDefinition, currentTypeHandler, explicitMappings, explicitNewMembers, matchedMembers);
        return PersistenceLegacyTypeMappingResult.New(legacyTypeDefinition, currentTypeHandler, (XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)legacyToCurrentMembers, (XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)currentToLegacyMembers, (XGettingEnum<PersistenceTypeDefinitionMember>)discardedLegacyMembers, (XGettingEnum<PersistenceTypeDefinitionMember>)newCurrentMembers);
    }

    public static void combineMappings(XTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToCurrentMembers, XTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers, XEnum<PersistenceTypeDefinitionMember> discardedLegacyMembers, XEnum<PersistenceTypeDefinitionMember> newCurrentMembers, PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<?, ?> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, XGettingSet<PersistenceTypeDefinitionMember> explicitNewMembers, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers) {
        HashTable sourceLookup = HashTable.New();
        HashTable targetLookup = HashTable.New();
        HashTable targetExplicits = HashTable.New();
        Static.fillLookupTables((HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)sourceLookup, (HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)targetLookup, (HashTable<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember>)targetExplicits, explicitMappings, explicitNewMembers, matchedMembers);
        Static.buildLegacyToCurrentMembersMapping(legacyTypeDefinition, (HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)sourceLookup, explicitMappings, legacyToCurrentMembers, discardedLegacyMembers);
        Static.buildCurrentToLegacyMembersMapping(currentTypeHandler, (HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)targetLookup, (XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember>)targetExplicits, currentToLegacyMembers, newCurrentMembers);
    }

    public static <D> PersistenceLegacyTypeMappingResultor<D> New() {
        return new Default();
    }

    public static final class Static {
        static void fillLookupTables(HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> sourceToTargetLookup, HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> targetToSourceLookup, HashTable<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> targetExplicitMappings, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, XGettingSet<PersistenceTypeDefinitionMember> explicitNewMembers, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers) {
            if (matchedMembers != null) {
                XGettingSequence matches = matchedMembers.result().sourceMatches();
                for (Similarity match : matches) {
                    sourceToTargetLookup.add((Object)((PersistenceTypeDefinitionMember)match.sourceElement()), (Object)match);
                    targetToSourceLookup.add((Object)((PersistenceTypeDefinitionMember)match.targetElement()), (Object)match);
                }
            }
            for (Object e : explicitMappings) {
                targetExplicitMappings.add((Object)((PersistenceTypeDefinitionMember)e.value()), (Object)((PersistenceTypeDefinitionMember)e.key()));
            }
            for (Object e : explicitNewMembers) {
                targetExplicitMappings.add(e, null);
            }
        }

        static void buildLegacyToCurrentMembersMapping(PersistenceTypeDefinition legacyTypeDefinition, HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> sourceToTargetLookup, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> sourceExplicitMappings, XTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToCurrentMembers, XEnum<PersistenceTypeDefinitionMember> discardedLegacyMembers) {
            for (PersistenceTypeDefinitionMember sourceMember : legacyTypeDefinition.allMembers()) {
                KeyValue explicitEntry = sourceExplicitMappings.lookup((Object)sourceMember);
                if (explicitEntry != null) {
                    if (explicitEntry.value() != null) {
                        legacyToCurrentMembers.add((Object)sourceMember, PersistenceLegacyTypeMapper.ExplicitMatch(sourceMember, (PersistenceTypeDefinitionMember)explicitEntry.value()));
                        continue;
                    }
                } else {
                    Similarity matchedTargetMember = (Similarity)sourceToTargetLookup.get((Object)sourceMember);
                    if (matchedTargetMember != null) {
                        legacyToCurrentMembers.add((Object)sourceMember, (Object)matchedTargetMember);
                        continue;
                    }
                }
                legacyToCurrentMembers.add((Object)sourceMember, null);
                discardedLegacyMembers.add((Object)sourceMember);
            }
        }

        static void buildCurrentToLegacyMembersMapping(PersistenceTypeHandler<?, ?> currentTypeHandler, HashTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> targetToSourceLookup, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> targetExplicitMappings, XTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers, XEnum<PersistenceTypeDefinitionMember> newCurrentMembers) {
            for (PersistenceTypeDefinitionMember trgMember : currentTypeHandler.allMembers()) {
                KeyValue explicitEntry = targetExplicitMappings.lookup((Object)trgMember);
                if (explicitEntry != null) {
                    if (explicitEntry.value() != null) {
                        currentToLegacyMembers.add((Object)trgMember, PersistenceLegacyTypeMapper.ExplicitMatch((PersistenceTypeDefinitionMember)explicitEntry.value(), trgMember));
                        continue;
                    }
                } else {
                    Similarity matchedSourceMember = (Similarity)targetToSourceLookup.get((Object)trgMember);
                    if (matchedSourceMember != null) {
                        currentToLegacyMembers.add((Object)trgMember, (Object)matchedSourceMember);
                        continue;
                    }
                }
                currentToLegacyMembers.add((Object)trgMember, null);
                newCurrentMembers.add((Object)trgMember);
            }
        }

        private Static() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Default<D>
    implements PersistenceLegacyTypeMappingResultor<D> {
    }
}

